/**
 * Copyright itsukichang ( http://wonderfl.net/user/itsukichang )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6KbM
 */

// forked from tomonobu's forked from: flash on 2011-7-3
package {
    import flash.display.*;
    import flash.events.*;
    import flash.geom.Matrix;
    
    public class Main extends Sprite {
        
        public function Main() {
            // BitmapDataの初期化
            var bmd:BitmapData = new BitmapData(465, 465, false, 0x0);
            var bmp:Bitmap = new Bitmap(bmd);
            var _glow:BitmapData;
            var _glowMtx:Matrix;
            addChild(bmp);
            
            _glow = new BitmapData(465 / 4, 465 / 4, false, 0xffffff); // キラキラを描く用のん。カンバスの 4 分の 1 のサイズ
            var bm:Bitmap = this.addChild(new Bitmap(_glow, PixelSnapping.NEVER, true)) as Bitmap; // smoothing を true にして配置
            bm.scaleX = bm.scaleY = 4 // 4 倍にする。
            bm.blendMode = BlendMode.ADD; // 加算モードで合成
            _glowMtx = new Matrix(0.25 ,0, 0, 0.25);
            
            // パーティクルの作成
            var particles:Array = [];
            for(var i:int=0; i<1000; i++){
                var p:Particle = new Particle();
                p.theta = Math.random() * 360;
                p.radius = (200 - i/5);
                p.x = p.radius * Math.cos(p.theta * Math.PI / 180) + (465 / 2); // 画面中央の座標を指定
                p.y = p.radius * Math.sin(p.theta * Math.PI / 180) + (465 / 2);
                p.color = i%2 ? 0x00aeef :0xec008c; // 白色を指定
                particles[i] = p;
            }
            
            // アニメーション処理
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
            
            function enterFrameHandler(e:Event):void{
                // リセット (画面を黒く塗りつぶす)
                bmd.lock();
                bmd.fillRect(bmd.rect, 0x000000);
                for(var i:int=0; i<particles.length; i++){
                    var p:Particle = particles[i];
                    // 速度を座標に適用
                    p.theta = p.theta + 2;
                    p.radius = (p.radius >= 0) ? p.radius - 1:0;
                    p.x = p.radius * Math.cos((p.theta) * Math.PI / 180) + mouseX;//(465 / 2);
                    p.y = p.radius * Math.sin((p.theta) * Math.PI / 180) + mouseY;//(465 / 2);
                    // 描画処理
                    bmd.setPixel(p.x, p.y, p.color);
                }
                bmd.unlock();
                _glow.draw(bmd, _glowMtx); // キラキラを描く
           }
            
        }
    }
}

/** パーティクルクラス */
class Particle {
    public var x:Number; // X座標
    public var y:Number; // Y座標
    public var vx:Number; // X軸方向の速さ
    public var vy:Number; // Y軸方向の速さ
    public var theta:Number; // 角度
    public var radius:Number;
    public var color:uint; // 色情報
}