/**
 * Copyright chenjinglin.xidian ( http://wonderfl.net/user/chenjinglin.xidian )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6KNJ
 */

// forked from ProjectNya's チョーク (1)
////////////////////////////////////////////////////////////////////////////////
// チョーク (1)
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.display.StageScaleMode;
    import flash.display.StageAlign;
    import flash.events.Event;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.geom.Point;
    import flash.display.BlendMode;

    [SWF(backgroundColor="#005500", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var bitmap:Bitmap;
        private var bitmapData:BitmapData;
        private var loader:PhotoLoader;
        private static var basePath:String = "http://assets.wonderfl.net/images/related_images/";
        private static var filePath:String = "8/80/8094/8094e540f4ab2a1c598986a861c592c143aac9d3";

        public function Main() {
            //Wonderfl.capture_delay(1);
            init();
        }

        private function init():void {
            graphics.beginFill(0x005500);
            graphics.drawRect(0, 0, 465, 450);
            graphics.endFill();
            graphics.beginFill(0x996633);
            graphics.drawRect(0, 450, 465, 15);
            graphics.endFill();
            //
            bitmapData = new BitmapData(400, 400, true, 0x00000000);
            bitmap = new Bitmap(bitmapData);
            bitmap.x = 32;
            bitmap.y = 32;
            addChild(bitmap);
            loader = new PhotoLoader();
            loader.addEventListener(Event.INIT, initialize, false, 0, true);
            loader.load(basePath + filePath, true);
        }
        private function initialize(evt:Event):void {
            var bd:BitmapData = Bitmap(evt.target.content).bitmapData;
            var seed:uint = uint(Math.random()*10000);
            bitmapData.lock();
            bitmapData.pixelDissolve(bd, bd.rect, new Point(), seed, 400*400*0.4, 0xff0000);
           // bitmapData.draw(bitmapData.clone(), null, null, BlendMode.ADD);
            bitmapData.unlock();
            bitmap.blendMode = BlendMode.ADD;
           
        }
        
    }

}


//////////////////////////////////////////////////
// PhotoLoaderクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Loader;
import flash.display.LoaderInfo;
import flash.net.URLRequest;
import flash.display.Bitmap;
import flash.events.Event;
import flash.events.IOErrorEvent;
import flash.events.HTTPStatusEvent;
import flash.events.SecurityErrorEvent;
import flash.system.LoaderContext;

class PhotoLoader extends Sprite {
    private var loader:Loader;
    private var info:LoaderInfo;
    public var content:*;
    private var smoothing:Boolean;
    public static const IO_ERROR:String = IOErrorEvent.IO_ERROR;
    public static const HTTP_STATUS:String = HTTPStatusEvent.HTTP_STATUS;
    public static const SECURITY_ERROR:String = SecurityErrorEvent.SECURITY_ERROR;
    public static const INIT:String = Event.INIT;
    public static const COMPLETE:String = Event.COMPLETE;

    public function PhotoLoader() {
        loader = new Loader();
        info = loader.contentLoaderInfo;
    }

    public function load(file:String, s:Boolean = false):void {
        smoothing = s;
        info.addEventListener(IOErrorEvent.IO_ERROR, ioerror, false, 0, true);
        info.addEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus, false, 0, true);
        info.addEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror, false, 0, true);
        info.addEventListener(Event.INIT, initialize, false, 0, true);
        info.addEventListener(Event.COMPLETE, complete, false, 0, true);
        try {
            loader.load(new URLRequest(file), new LoaderContext(true));
        } catch (err:Error) {
            trace(err.message);
        }
    }
    public function unload():void {
        loader.unload();
    }
    private function ioerror(evt:IOErrorEvent):void {
        loader.unload();
        dispatchEvent(new Event(PhotoLoader.IO_ERROR));
    }
    private function httpstatus(evt:HTTPStatusEvent):void {
        dispatchEvent(new Event(PhotoLoader.HTTP_STATUS));
    }
    private function securityerror(evt:SecurityErrorEvent):void {
        dispatchEvent(new Event(PhotoLoader.SECURITY_ERROR));
    }
    private function initialize(evt:Event):void {
        if (smoothing) {
            content = Bitmap(info.content);
            content.smoothing = true;
        } else {
            content = info.content;
        }
        dispatchEvent(new Event(PhotoLoader.INIT));
    }
    private function complete(evt:Event):void {
        info.removeEventListener(IOErrorEvent.IO_ERROR, ioerror);
        info.removeEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus);
        info.removeEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror);
        info.removeEventListener(Event.INIT, initialize);
        info.removeEventListener(Event.COMPLETE, complete);
        //addChild(loader);
        dispatchEvent(new Event(PhotoLoader.COMPLETE));
    }

}
