/**
 * Copyright psyark ( http://wonderfl.net/user/psyark )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6JrO
 */

package {
	import flash.display.*;
	import flash.events.*;
	import flash.geom.*;
	
	[SWF(width=465,height=465,frameRate=60,backgroundColor=0x000000)]
	/**
	 * このクラスでは、計算式から単純な形状（トーラス）を生成する例を示します。
	 */
	public class Test20 extends Sprite {
		private var viewport:Shape;
		private var vertices:Vector.<Number>;
		private var uvtData:Vector.<Number>;
		private var indices:Vector.<int>;
		private var worldMatrix:Matrix3D;
		private var viewMatrix:Matrix3D;
		private var projection:PerspectiveProjection;
		private var texture:BitmapData;
		
		public function Test20() {
			// 描画対象となるShapeを作成し、表示リストに追加します。
			viewport = new Shape();
			viewport.x = stage.stageWidth  * 0.5;
			viewport.y = stage.stageHeight * 0.5;
			addChild(viewport);
			
			createMesh();
			
			worldMatrix = new Matrix3D();
			viewMatrix = new Matrix3D();
			viewMatrix.appendTranslation(0, 0, 800);
			projection = new PerspectiveProjection();
			projection.fieldOfView = 60;
			
			texture = new BitmapData(512, 512, false);
			texture.perlinNoise(100, 100, 5, 0, true, true, 7);
			
			addEventListener(Event.ENTER_FRAME, enterFrameHandler);
		}
		
		/**
		 * 3D形状を作成します
		 */
		private function createMesh():void {
			vertices = new Vector.<Number>();
			uvtData = new Vector.<Number>();
			indices = new Vector.<int>();
			
			var hDiv:int = 32;
			var vDiv:int = 16;
			var hRadius:Number = 200;
			var vRadius:Number = 100;
			
			for (var i:uint=0; i<=hDiv; i++) {
				var s1:Number = Math.PI * 2 * i / hDiv;
				for (var j:uint=0; j<=vDiv; j++) {
					var s2:Number = Math.PI * 2 * j / vDiv;
					var r:Number = Math.cos(s2) * vRadius + hRadius;
					vertices.push(Math.cos(s1) * r, Math.sin(s1) * r, Math.sin(s2) * vRadius);
					uvtData.push(i / hDiv, j / vDiv, 1);
					if (j < vDiv && i < hDiv) {
						var a:uint =  i      * (vDiv + 1) + j;
						var b:uint = (i + 1) * (vDiv + 1) + j;
						indices.push(b, a + 1, a, a + 1, b, b + 1);
					}
				}
			}
		}
		
		/**
		 * フレームごとの処理
		 */
		private function enterFrameHandler(event:Event):void {
			update();
			render();
		}
		
		/**
		 * 更新
		 */
		private function update():void {
			worldMatrix.appendRotation(0.27, Vector3D.X_AXIS);
			worldMatrix.appendRotation(0.61, Vector3D.Y_AXIS);
		}
		
		/**
		 * 描画
		 */
		private function render():void {
			// World行列、View行列、Projection行列を結合して一つの行列にする
			var m:Matrix3D = new Matrix3D();
			m.append(worldMatrix);
			m.append(viewMatrix);
			m.append(projection.toMatrix3D());
			
			// 上記の行列を使って頂点座標を投影する
			var projected:Vector.<Number> = new Vector.<Number>();
			Utils3D.projectVectors(m, vertices, projected, uvtData);
			
			viewport.graphics.clear();
			viewport.graphics.beginBitmapFill(texture, null, false, true);
			viewport.graphics.drawTriangles(projected, getSortedIndices(), uvtData, TriangleCulling.POSITIVE);
			viewport.graphics.endFill();
		}
		
		/**
		 * Zソートされたインデックスを返す
		 */
		private function getSortedIndices():Vector.<int> {
			var triangles:Array = [];
			for (var i:int=0; i<indices.length; i+=3) {
				var i1:int = indices[i+0];
				var i2:int = indices[i+1];
				var i3:int = indices[i+2];
				var z:Number = Math.min(uvtData[i1 * 3 + 2], uvtData[i2 * 3 + 2], uvtData[i3 * 3 + 2]);
				if (z > 0) {
					triangles.push({i1:i1, i2:i2, i3:i3, z:z});
				}
			}
			triangles = triangles.sortOn("z", Array.NUMERIC);
			
			var sortedIndices:Vector.<int> = new Vector.<int>(0, false);
			for each (var triangle:Object in triangles) {
				sortedIndices.push(triangle.i1, triangle.i2, triangle.i3);
			}
			return sortedIndices;
		}
	}
}