/**
 * Copyright 883108 ( http://wonderfl.net/user/883108 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6JnM
 */

package {
	import flash.display.Sprite;
	import flash.text.TextField;
	import flash.events.MouseEvent;
	import flash.geom.Point;
	public class CurveLineDrawerDocument extends Sprite {
		private var _points:Object = {};
		private var _description:TextField;
		private var _line:Sprite;
		public function CurveLineDrawerDocument() {
			init();
		}
		private function init():void {
			// 
			var tex:TextField = new TextField  ;
			addChild(tex);
			tex.width = 450;
			tex.x = tex.y = 10;
			tex.multiline = true;
			tex.text = 
			'マウスでクリックした点を基準に、ランダムに生成された2点を曲線で繋ぎます。\n' +
			'・curveTo()メソッドにそのままクリック座標を与えた結果(黒線)、\n' + 
			'・クリック座標を通過するようにcurveTo()のパラメータを調整した結果(青線)\n' + 
			'2パターンのcurveTo()メソッド実行結果を表示します。\n';
			//  始点を作成
			var startPoint:Point = _points['start'] = new Point(Math.random() * stage.stageWidth,Math.random() * stage.stageHeight);
			var startPoint_text:TextField = new TextField  ;
			addChild(startPoint_text);
			startPoint_text.x = startPoint.x;
			startPoint_text.y = startPoint.y;
			startPoint_text.text = (startPoint.x|0) + ',' + (startPoint.y|0);

			//  終点を作成
			var endPoint:Point = _points['end'] = new Point(Math.random() * stage.stageWidth,Math.random() * stage.stageHeight);
			var endPoint_text:TextField = new TextField  ;
			addChild(endPoint_text);
			endPoint_text.x = endPoint.x;
			endPoint_text.y = endPoint.y;
			endPoint_text.text = (endPoint.x|0) + ',' + (endPoint.y|0);

			// ライン用のスプライトをインスタンス化
			addChild(_line = new Sprite);
			// 説明書き部分を作成
			addChild(_description = new TextField);

			// イベントリスナ
			stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
			stage.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
		}

		private function mouseDownHandler($event:MouseEvent):void {
			drawCurveLine();
			stage.addEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler);
		}

		private function mouseMoveHandler($event:MouseEvent):void {
			drawCurveLine();
			$event.updateAfterEvent();
		}

		private function mouseUpHandler($event:MouseEvent):void {
			stage.removeEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler);
		}

		private function drawCurveLine():void {
			// 説明フィールドをマウスに追随させ、必要な情報を出力する。
			_description.x = mouseX;
			_description.y = mouseY;
			_description.text = mouseX + ', ' + mouseY;

			// APIで描画したグラフィックを全て初期化する。
			graphics.clear();
			// 始点、終点をマーキング
			graphics.beginFill(0xcc0000);
			graphics.drawCircle(_points.start.x, _points.start.y, 4);
			graphics.drawCircle(_points.end.x, _points.end.y, 4);

			// ラインのグラフィックを全て初期化する。
			_line.graphics.clear();
			_line.graphics.lineStyle(0);

			// 単純にマウスの座標のみをパラメータに与えた例
			_line.graphics.moveTo(_points.start.x, _points.start.y);
			_line.graphics.curveTo(mouseX, mouseY, _points.end.x, _points.end.y);
			// マウス座標を曲線が通過するように調整した例
			var tX:Number = mouseX * 2 - (_points.start.x + _points.end.x) / 2;
			var tY:Number = mouseY * 2 - (_points.start.y + _points.end.y) / 2;
			_line.graphics.moveTo(_points.start.x, _points.start.y);
			_line.graphics.lineStyle(0, 0x33a3f8);
			_line.graphics.curveTo(tX, tY,  _points.end.x, _points.end.y);
		}
	}
}