/**
 * Copyright roll.sagawa ( http://wonderfl.net/user/roll.sagawa )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6JUh
 */

// forked from mousepancyo's カエル？ボタン？（Broken Pieces）
// forked from Event's Button
package  {
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.DisplayObject;
    import flash.display.Loader;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.BlurFilter;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.geom.ColorTransform;
    import flash.net.URLRequest;
    import flash.system.Security;
    import org.libspark.betweenas3.BetweenAS3
    import org.libspark.betweenas3.easing.*
    import org.libspark.betweenas3.tweens.ITween
    import org.libspark.betweenas3.events.TweenEvent

    [SWF(width = 465,height = 465,backgroundColor = 0,frameRate = 60)]    
    
    public class Main extends Sprite{
        private const W:int = 465;
        private const H:int = 465;
        private var _loader:Loader;
        private var _srcBmd:BitmapData;
        private var _particleList:Vector.<Particle> = new Vector.<Particle>;
        private var _ctf:ColorTransform = new ColorTransform(0.95, 0.95, 0.95);
        private var _glowBmd:BitmapData = new BitmapData(W, H, true, 0);
        private var container:Sprite = new Sprite();

        public function Main() {
            graphics.beginFill(0);
            graphics.drawRect(0, 0, W, H);
            graphics.endFill();
            Security.loadPolicyFile("http://www.digifie.jp/crossdomain.xml");
            loadImage("");
        }
        
        private function loadImage($url:String):void {
            _loader = new Loader();
            _loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onLoaded);
            _loader.load(new URLRequest($url));
        }

        private function onLoaded(e:Event):void {
            _loader.contentLoaderInfo.removeEventListener(Event.COMPLETE, onLoaded);
            //
            container.visible = false;
            container.buttonMode = true;
            addChild(container);
            //
            var bm:Bitmap = new Bitmap(_glowBmd);
            bm.blendMode = "add";
            addChild(bm);
            //
            _srcBmd = new BitmapData(300, 200, true, 0);
            _srcBmd.draw(_loader);
            createPieces(_srcBmd, 0);
        }
        
        private function createPieces(image:BitmapData, $delay:int):void{
            for(var i:int=0; i<40; i++){
                for(var j:int=0; j<60; j++){
                    var bmd:BitmapData = new BitmapData(5, 5, true);
                    bmd.copyPixels(image, new Rectangle(j*5, i*5, 5, 5), new Point(0, 0));
                    //
                    var bm:Particle = new Particle(bmd);
                    var radius:Number = Math.sqrt(Math.random())*10;
                    var angle:Number = Math.random() * (Math.PI)*2;
                    bm.alpha = 0;
                    bm.x = Math.random() * (W | 0);
                    bm.y = Math.random() * (H | 0);
                    bm.homeX = j * 5 + W / 2-160;
                    bm.homeY = i * 5 + H / 2-100;
                    bm.vx = Math.cos(angle) * radius;
                    bm.vy = Math.sin(angle) * radius;
                    //
                    container.addChild(bm);
                    tween(bm, 2, bm.homeX, bm.homeY, 1, $delay);
                    //
                    _particleList.push(bm);
                }
            }
        }
        
        private function tween($target:DisplayObject, $time:Number, $xPos:Number, $yPos:Number=0, $a:Number = 1, $delay:Number=0):void {
            var tween:ITween = BetweenAS3.tween($target, { x:$xPos, y:$yPos, alpha:$a }, null, $time, Cubic.easeIn);
            tween = BetweenAS3.delay(tween, $delay);
            tween.addEventListener(TweenEvent.COMPLETE, onComplete);
            tween.play();
             function onComplete(e:TweenEvent):void{
                container.buttonMode = true;
                container.visible = true;
                container.addEventListener(MouseEvent.MOUSE_DOWN, imgBreak);
             }
        }
        
        private function imgBreak(e:MouseEvent):void{
            container.removeEventListener(MouseEvent.MOUSE_DOWN, imgBreak);
            container.buttonMode = false;
            addEventListener(Event.ENTER_FRAME, update);
        }
        
        private function update(e:Event):void{
            var n:int = _particleList.length;
            while (n--) {
                var v:Number = Math.random() * 0.5 + 0.8;
                var p:Particle = _particleList[n];
                p.vy += 0.5;
                p.vx *= v * .95;
                p.vy *= v;
                p.x += p.vx;
                p.y += p.vy;
                //
                if(p.x < -100 || p.x > W + 100 || p.y < -100 || p.y > H * 2){
                    container.removeChild(_particleList[n]);
                    _particleList.splice(n, 1);
                    if(_particleList.length == 0){
                        removeEventListener(Event.ENTER_FRAME, update);
                        createPieces(_srcBmd, 1);
                    }
                }
            }
            _glowBmd.lock();
            _glowBmd.draw(container);
            _glowBmd.colorTransform(_glowBmd.rect, _ctf);
            _glowBmd.applyFilter(_glowBmd, _glowBmd.rect, new Point(0, 0), new BlurFilter(4,4,1));
            _glowBmd.unlock();
        }
    }
}

//
import flash.display.Bitmap;
import flash.display.BitmapData;

class Particle extends Bitmap{
    
    public var homeX:Number = 0;
    public var homeY:Number = 0;
    public var vx:Number = 0;
    public var vy:Number = 0;
    
    public function Particle(bmd:BitmapData, snap:String = "auto", somooth:Boolean = false){
        super(bmd, snap, somooth);
    }
}