/**
 * Copyright cpu_t ( http://wonderfl.net/user/cpu_t )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6Iv7
 */

package
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.SampleDataEvent;
    import flash.media.Sound;
    import flash.net.URLRequest;
    import flash.text.TextField;
    import flash.utils.ByteArray;
    
    [SWF(width=465,height=465)]
    public class FlashTest extends Sprite
    {
        public function FlashTest()
        {
            txOut=new TextField();
            addChild(txOut);
            txOut.width=stage.stageWidth;
            txOut.height=stage.stageHeight;
            txOut.wordWrap=true;
            
            sourceSnd=new Sound();
            outputSnd=new Sound();
            urlReq=new URLRequest("sample.mp3");
            
            view=new Sprite();
            addChild(view);
            view.y=465/2;
            
            sourceSnd.load(urlReq);
            sourceSnd.addEventListener(Event.COMPLETE, loaded);
        }
        
        private var txOut:TextField;
        
        private var sourceSnd:Sound;
        private var outputSnd:Sound;
        private var urlReq:URLRequest;
        
        private var view:Sprite;
        
        private function loaded(event:Event):void
        {
            outputSnd.addEventListener(SampleDataEvent.SAMPLE_DATA, processSound);
            outputSnd.play();
        }
        
        private function processSound(event:SampleDataEvent):void
        {
            var bytes:ByteArray = new ByteArray();
            var data:Vector.<Number>=new Vector.<Number>();
            sourceSnd.extract(bytes, 4096);
            txOut.text="";
            try{
                bytes.position=0;
                for(var i:int=0;i<4096*2;i++)
                {
                    data.push(bytes.readFloat());
                }
                bytes.clear();
                
                // 加工処理
                for(i=0;i<data.length;i++)
                {
                    data[i] *= Math.random();
                }
                
                for(i=0;i<data.length;i++)
                {
                    bytes.writeFloat(data[i]);
                }
            }
            catch(e:Error)
            {
                txOut.appendText(e.toString());
            }
            event.data.writeBytes(bytes);
        }
    }
}