/**
 * Copyright gupon ( http://wonderfl.net/user/gupon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6Ika
 */

package {
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.events.Event;
    
    [SWF(frameRate=60)]
    public class C extends Sprite{
    		private var v:V;
    		private var list:Array = [];
    		
        public function C() {
        		addChild( v = new V() );
        		v.addEventListener('clicked', clickHandler );
        		addEventListener( Event.ENTER_FRAME, enterFrameHandler );
        }
        
        private function clickHandler(event:ClickEvent):void {
        		var m:M = new M();
        		m.x = event.x;
        		m.y = event.y;
        		m.vx = Math.random() * 10 - 5;
        		m.vy = Math.random() * 10 - 5;
        		m.thickness = Math.random() * 5 + 10;
        		if( Math.abs( m.vx ) < 1 ) m.vx *= 3;
        		if( Math.abs( m.vy ) < 1 ) m.vy *= 3;
        		m.radius = Math.random() * 30 + 5;
        		list.push( m );
        		enterFrameHandler(null);
        }
        
        private function enterFrameHandler(event:Event=null):void {
        		if( list.length ) {
        			v.clear();
        			for each ( var m:M in list ) {
        				if (		m.x > 465 + m.radius ||
        						m.y > 465 + m.radius ||
        						m.x < 0 - m.radius ||
        						m.y < 0 - m.radius ) {
        							
        					list.splice( list.indexOf(m), 1 );
        					
        				} else {
        					m.x += m.vx;
        					m.y += m.vy;
        					m.radius ++;
        					m.thickness *= .99;
        					m.alpha = m.thickness - .3;
	        				v.draw( m );
	        				if( m.thickness < .1 )
	        					list.splice( list.indexOf(m), 1 );
        				}
        			}
        		} else {
        			v.ready();
        		}
        }
    }
}

import flash.display.Graphics;
import flash.events.MouseEvent;
import flash.display.Sprite;

import flash.display.Bitmap;
import flash.display.BitmapData;
class V extends Sprite{
	private var g:Graphics;
	
	public function V () {
		graphics.beginFill( 0xFFFFFF );
		graphics.drawRect( 0, 0, 465, 465 );
		
		var canvas:Sprite = new Sprite();
		g = canvas.graphics;
		addChild( canvas );
		
		addEventListener( MouseEvent.MOUSE_DOWN, mouseDownHandler );
	}
	
	public function draw ( m:M ):void {
		g.lineStyle( m.thickness , 0x880033, m.alpha );
		g.drawCircle( m.x, m.y, m.radius );
	}
	
	public function clear():void {
		g.clear();
	}
	
	public function ready():void {
		g.clear();
		g.beginFill( 0x333333 );
		g.drawRect( 0, 0, 465, 465 );
	}
	
	private function mouseDownHandler( event:MouseEvent ):void {
		dispatchEvent( new ClickEvent("clicked", mouseX, mouseY ));
	}
}

class M {
	public var	x:Number,
				y:Number,
				vx:Number,
				vy:Number,
				radius:Number,
				alpha:Number = 1,
				thickness:Number;
}

import flash.events.Event;
class ClickEvent extends Event{
	public var	x:Number,
				y:Number;
				
	public function ClickEvent(type:String, x:Number, y:Number) {
		super(type,false,false);
		this.x = x;
		this.y = y;
	}
}