/**
 * Copyright sinketu ( http://wonderfl.net/user/sinketu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6IWQ
 */

package 
{
    import caurina.transitions.*;
    import caurina.transitions.properties.*;
    import flash.display.*;
    import flash.events.*;
    import flash.utils.*;
    import net.hires.debug.*;
    /**
     * ...
     * @author michiro
     */
    [SWF(backgroundColor="0x0", frameRate="30", width="465", height="465")]
    public class Main extends Sprite 
    {
        private static const FONTSIZE:Number = 46;
        private static const DENSITY:Number = 26;
        
        private var count:Number=0;
        private const bai: Number = 0.04;
        private var hankei:Number=0.01;
        private var kakudo:Number=0;
        private var base:Sprite;
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
            
        }
        /**
         * 初期化
         * @param    e
         */
        private function init(e:Event = null):void 
        {
            Wonderfl.capture_delay( 120 );
            DisplayShortcuts.init();
            ColorShortcuts.init();
            
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            setSpiral();
            //addChild(new Stats());
        }
        
        /**
         * 0.9秒に一回、文字が現れる。
         */
        public function setSpiral():void {

            base = new Sprite();
            base.x = stage.stageWidth/2;
            base.y = stage.stageHeight / 2;
            
            addChild(base);
            
            var myTimer:Timer = new Timer(900);
            myTimer.addEventListener(TimerEvent.TIMER, xCharAppear);
            myTimer.start();
        }
        
        /**
         * 文字は、fontMakerでつくる。
         * @param    e
         */
        private function xCharAppear(e:TimerEvent):void 
        {
                hankei = 0.01;
                kakudo = 0;
                var temp:Sprite = fontMaker(count);    
                base.addChild(temp);                
                count++;
                if (count >= DENSITY ) {
                    count = 0;
                }
        }
        
        /**
         * 文字を作る
         * TextAnimationがクラス内で処理。
         * * 最初の値を与える。
         * 
         */
        private function fontMaker(num:Number):Sprite
        {
                var myString:String;
                
                var mySp:TextAnimation = new TextAnimation(num);
                mySp.addEventListener(Event.ENTER_FRAME, xEnterFrame);
                
                mySp.rotation = kakudo;
                mySp.x = hankei*Math.PI*2*Math.cos(mySp.rotation/180*Math.PI);
                mySp.y = hankei * Math.PI * 2 * Math.sin(mySp.rotation / 180 * Math.PI);
                mySp.hankei = hankei;
                mySp.scaleX = mySp.scaleY = hankei*bai;
                
                return mySp;
        }
        
        /**
         * 回転しながら大きくなる。
         * @param    e
         */
        private function xEnterFrame(e:Event):void 
        {
            base.rotation+=0.005
            var temp:TextAnimation = e.target as TextAnimation;
            temp.hankei+=0.02;
            temp.rotation += 0.75;
            temp.x = temp.hankei*Math.PI*2*Math.cos(temp.rotation/180*Math.PI);
            temp.y = temp.hankei * Math.PI * 2 * Math.sin(temp.rotation / 180 * Math.PI);
            temp.scaleX = temp.scaleY =  temp.hankei * bai;
            Tweener.addTween(temp, { _brightness: -2.55 * temp.scaleX } );
            if (temp.scaleX > 1) {
                temp.removeEventListener(Event.ENTER_FRAME, xEnterFrame);
                base.removeChild(temp);
                
            }
            
        }
        
    }
    
}



/**
 * TextAnimation テキストをアニメーションさせるクラス。
 */

import caurina.transitions.*;
import caurina.transitions.properties.*;
import flash.display.*;
import flash.events.*;
import flash.geom.*;
import flash.text.*;
import flash.utils.*;
import net.hires.debug.*;

class TextAnimation extends Sprite 
{
    public var hankei:Number;
    private var myTextField:TextField;
    private var setString:String = "";
    private var arraytext/*String*/:Array = [];
    private var setStringArray/*:String*/:Array = [
    "Although things are not perfect",
    "Be Loved ",
    "Continue in thanksgiving",
    "Do not begin to blame",
    "Even when the times are hard",
    "Fierce winds",
    "God is forever",
    "Hold on to what you know",
    "Imagine life",
    "Joyfull time",
    "Keep thanking Your Family",
    "Love is here",
    'Move out',
    "No weapon",
    "On your eyes",
    "Pride can do it",
    "Quit to be afraid of the future",
    "Redeem the time?",
    "Start every day",
    'To "thank" is a command',
    "Until we see it",
    "Victorious in the sky",
    "We'll run the race",
    "Xalting God most high",
    "Yes, there'll be good",
    "Zelda waits in glory"
    ];
    private var timerHolderA/*Timer*/:Array = [];
    private var timerHolderB/*Timer*/:Array = [];
    private var myBitmapData:BitmapData;
    private var myCopyBitmapData:BitmapData;
    private var mybmp:Bitmap;
    private var mySprite:Sprite;
    private var rect:Rectangle;
    private var pointArray:Array;
    private const FONTSIZE:Number = 40;
    private var _initialChar:String;

    /**
     * @param    e
     */
    public function TextAnimation(num:Number):void 
    {
        ColorShortcuts.init();
        DisplayShortcuts.init();
        _initialChar = String.fromCharCode(num + 65);
        addEventListener(Event.ADDED_TO_STAGE, xAdded);
        setString = setStringArray[num];
    }
    
    /**
     * num
     * @param    e
     */
    private function xAdded(e:Event):void 
    {
        removeEventListener(Event.ADDED_TO_STAGE, xAdded);
        
        addEventListener(Event.REMOVED_FROM_STAGE, xRemoved);
        //ビットマップデータ作成
        myBitmapData = new BitmapData(600, FONTSIZE+10,true,0x00000000);
        myCopyBitmapData = myBitmapData.clone();
        mybmp = new Bitmap(myCopyBitmapData);
        mybmp.y = -FONTSIZE / 2;
        mybmp.smoothing = true;
        addChild(mybmp);
        rect = new Rectangle(0, 0, 600, FONTSIZE + 10 );        
        mySprite = new Sprite();

        myTextField = textPropertySet(600, 40,false,0xDDFFFF,false,false);
        textFormatProperty(myTextField, FONTSIZE,0xDDFFFF,"Verdana",TextFormatAlign.LEFT,1);
        mySprite.addChild(myTextField);
        myTextField.text = _initialChar;
        addEventListener(Event.ENTER_FRAME, xEnterFrame);
        setAnimation();
    }
    
    /**
     * けすー
     * @param    e
     */
    private function xRemoved(e:Event):void 
    {
        removeEventListener(Event.REMOVED_FROM_STAGE, xRemoved);
        removeEventListener(Event.ENTER_FRAME, xEnterFrame);
        resetAnimation();
        mySprite.removeChild(myTextField);
        removeChild(mybmp);
    }
    
    /**
     * ビットマップデータの処理
     * 
     * @param    e
     */
    private function xEnterFrame(e:Event):void 
    {
        myCopyBitmapData.fillRect(rect, 0x00000000);
        myCopyBitmapData.draw(mySprite);
    }
    
    /**
     * アニメーション開始
     */
    private function setAnimation():void
    {
        arraytext = [];
        
        for (var i:uint = 0; i < setString.length; i++) {
            arraytext[i] = "";
        }
        //時間とともに動くモーションタイポ
        var myDelayAnimation:Timer = new Timer(15000, 1);
        myDelayAnimation.addEventListener(TimerEvent.TIMER, xTimerDelay);
        myDelayAnimation.start();
    }
    
    private function xTimerDelay(e:TimerEvent):void 
    {
        createAnimation();
    }
    
    
    /**
     * リセット
     * なんかメモリリークしてるっぽい
     */
    private function resetAnimation():void
    {
        //timerを全部とめる。
        for (var i:uint = 0; i < timerHolderA.length; i++ ) {
            timerHolderA[i].stop();
            timerHolderA[i].removeEventListener(TimerEvent.TIMER, xTimer);
            timerHolderA[i] = null;
        }
        timerHolderA = [];
        
        for (i = 0; i < timerHolderB.length; i++ ) {
            timerHolderB[i].stop();
            timerHolderB[i].removeEventListener(TimerEvent.TIMER, xRand);
            timerHolderB[i].removeEventListener(TimerEvent.TIMER_COMPLETE,xFinish);
            timerHolderB[i] = null;
        }
        timerHolderB = [];
    }
    
    /**
     * 各文字ごとに 40+i*2 の時間差を発生させて、後ろの文字ほど遅らせてスタート。
     */
    private function createAnimation():void
    {
        for (var i:uint = 0; i < setString.length ;i++ ){
            var myTimer:Timer = new Timer((30+i*2)*i,1);
            myTimer.addEventListener(TimerEvent.TIMER, xTimer(i));
            myTimer.start();
            timerHolderA.push(myTimer);
        }
    }
    
    /**
     * 各文字ごとの文字の変更繰り返し
     * 
     * @param    num
     * @return
     */
    private function xTimer(num:Number):Function
    {
        return function(e:TimerEvent):void 
        {
            var myTimer:Timer = new Timer(30, 20);
            myTimer.addEventListener(TimerEvent.TIMER, xRand(num));
            myTimer.addEventListener(TimerEvent.TIMER_COMPLETE,xFinish(num));
            myTimer.start();
            timerHolderB.push(myTimer);
        }
    }
    
    /**
     * xTimerの終了時に正しい文字をあてる。
     * 
     * @param    num
     * @return
     */
    private function xFinish(num:Number):Function
    {
        return function(e:TimerEvent):void 
        {
            arraytext[num] = setString.charAt(num);
            setText();
        }
    }
    
    /**
     * 適当な文字を発生させる。
     * 
     * @param    num
     * @return
     */
    private function xRand(num:Number):Function
    {
        return function(e:TimerEvent):void 
        {
            var rand:uint = Math.floor(Math.random() * 94+33);
            var char:String = String.fromCharCode(rand);
            arraytext[num] = char;
            setText();
        }
    }
    
    /**
     * 作った文字を、指定の場所に割り当てる。
     */
    private function setText():void
    {
        myTextField.text = "";
        for (var i:uint = 0; i < arraytext.length; i++ ) {
            myTextField.appendText(arraytext[i]);
        }
    }
    
    /**
     * クラス化するほどでもないメソッド１
     * 
     * @param    w
     * @param    h
     * @param    txttype
     * @param    txtColr
     * @param    b
     * @param    thick
     * @param    sharp
     * @param    auto
     * @param    multi
     * @param    wrap
     * @param    embed
     * @return
     */
    private function textPropertySet(w:Number = 200, h:Number = 40, select:Boolean = false , txtColr:uint = 0x0, multi:Boolean = true, wrap:Boolean = true, auto:String = TextFieldAutoSize.LEFT, txttype:String = TextFieldType.DYNAMIC, b:Boolean = false, thick:Number = 1, sharp:Number = 1, embed:Boolean = false ):TextField {
        var txt:TextField=new TextField;
        txt.width = w;
        txt.height = h;
        txt.selectable = select;
        txt.type= txttype;
        txt.textColor = txtColr;
        txt.thickness = thick;//（埋め込みフォント時のみ動作）
        txt.sharpness = sharp;//（埋め込みフォント時のみ動作）
        txt.border = b;
        txt.autoSize = auto;
        txt.multiline = multi;
        txt.wordWrap = wrap;
        txt.embedFonts = embed;//（埋め込みフォント時のみ動作）
        return txt;
        
    }
    
    /**
     * クラス化するほどでもないメソッド２
     * 
     * @param    txt
     * @param    size
     * @param    color
     * @param    font
     * @param    format
     * @param    space
     * @param    lead
     * @param    bold
     * @param    kerning
     */
    private function textFormatProperty(txt:TextField, size:Number = 10,color:uint = 0x0,  font:String = "Verdana", format:String = TextFormatAlign.LEFT, space:Number = 0, lead:Number = 0, bold:Boolean = false, kerning:Boolean = false ):void
    {
        var myTextFormat:TextFormat = new TextFormat();
        myTextFormat.size = size;
        myTextFormat.font = font;
        myTextFormat.align = format; // 整列
        myTextFormat.color = color;// 文字の色
        myTextFormat.letterSpacing = space;// 文字間スペースの量(単位:ピクセル)
        myTextFormat.leading = lead;// 行間の垂直の行送り
        myTextFormat.bold = bold;// 太字にするか？
        myTextFormat.kerning = kerning;// カーニングが有効か？（埋め込みフォント時のみ動作）
        
        txt.defaultTextFormat = myTextFormat; 
    }
}
