/**
 * Copyright hourglasseye ( http://wonderfl.net/user/hourglasseye )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6INN
 */

package
{
    import flash.display.Sprite;
    import flash.events.Event;
    
    public class FlashTest extends Sprite
    {
    		private var circle:Sprite;
    		private var elapsedTime:Number;
    		private var lastIteration:Date;
    		private var pulseDuration:Number;
    		
        public function FlashTest() : void
        {
        		addEventListener( Event.ADDED_TO_STAGE, init );
        }
        
        public function init( e:Event ) : void
        {
        		elapsedTime = 0;
        		lastIteration = new Date();
        		pulseDuration = 2;
        		
        		circle = new Sprite();
        		circle.graphics.beginFill( 0x000000 );
        		circle.graphics.drawCircle( 0, 0, 50 );
        		circle.x = 225;
        		circle.y = 225;
        		
        		addChild( circle );
        	
        		addEventListener( Event.ENTER_FRAME, update );
        }
        
        public function update( e:Event ) : void
        {
        		var thisIteration:Date = new Date();
        		var deltaTime:Number = ( thisIteration.getTime() - lastIteration.getTime() ) / 1000;
        		lastIteration = thisIteration;
        		elapsedTime += deltaTime * 2;
        		
        		var scale:Number = Math.cos( elapsedTime * 0.5 );
        		circle.scaleX = scale;
        		circle.scaleY = scale;
        		
        		circle.x = 225 + Math.sin( elapsedTime ) * 120;
        		circle.y = 225 + Math.cos( elapsedTime ) * 60;
        		
        		circle.graphics.beginFill( scale * 0x0000FF );
        		circle.graphics.drawCircle( 0, 0, 50 );
        }
    }
}