/**
 * Copyright brendansean ( http://wonderfl.net/user/brendansean )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6IFo
 */

// forked from TX_298's jiglibサンプル改造
package
{
     /** 
     * jiglibサンプル改造
     * 3D文字をドラッグで動かす
     */
	import flash.events.*;
	import flash.geom.Point;
	import jiglib.math.JNumber3D;
	import jiglib.physics.RigidBody;
	import jiglib.plugin.papervision3d.Papervision3DPhysics;
	import jiglib.plugin.papervision3d.constraint.MouseConstraint;
	import jiglib.geometry.JBox;
	import jiglib.plugin.papervision3d.*;
	import org.papervision3d.cameras.CameraType;
	import org.papervision3d.core.math.Number3D;
	import org.papervision3d.events.InteractiveScene3DEvent;
	import org.papervision3d.lights.PointLight3D;
	import org.papervision3d.materials.WireframeMaterial;
	import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
	import org.papervision3d.objects.primitives.Plane;
	import org.papervision3d.view.BasicView;
	import org.papervision3d.view.layer.ViewportLayer;
	import org.papervision3d.view.layer.util.ViewportLayerSortMode;
	import org.papervision3d.core.geom.* 
	import org.papervision3d.core.geom.renderables.*;
	import org.papervision3d.core.math.*;
	import org.papervision3d.core.proto.MaterialObject3D
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.events.FileLoadEvent;
	import flash.net.*;
	import flash.utils.*;

	[SWF(width="465", height="465", backgroundColor="#000000", frameRate="60")]
	public class MouseConstraintTest extends BasicView
	{
		private var physics:Papervision3DPhysics;
		private var sceneLight:PointLight3D;
		private var mouseConstraint:MouseConstraint;
		private var vplObjects:ViewportLayer;
		public var letters:Array=new Array();
		private var spacer:int = 30;
		public function MouseConstraintTest()
		{
			super(stage.stageWidth, stage.stageHeight, true, true, CameraType.TARGET);
			physics = new Papervision3DPhysics(scene, 8);
			setupVPLayer();
			setupLighting();
			createFloor();
			setCamera();
			createText();
			startRendering();
		}
		
		private function setupVPLayer():void
		{
			vplObjects = new ViewportLayer(viewport, null);
			vplObjects.layerIndex = 2;
			vplObjects.sortMode = ViewportLayerSortMode.Z_SORT;
			viewport.containerSprite.addLayer(vplObjects);
		}
		
		private function setupLighting():void
		{
			sceneLight = new PointLight3D(true, true);
			sceneLight.x = 0;
			sceneLight.y = 400;
			sceneLight.z = -300;
		}
		
		private function createFloor():void
		{
			physics.createGround(new WireframeMaterial(0xFFFFFF, 0), 1800, 0);
			
			var floor:Plane = new Plane(new WireframeMaterial(0xFFFFFF), 10000, 10000, 10000*0.001, 10000*0.001);
			floor.rotationX = 90;
			floor.y = -200
			scene.addChild(floor);
		}
		
		private function setCamera():void
		{
			camera.y = 800
			camera.focus = 250;
			camera.zoom = 1;
		}
		private function createText():void {
			var val:URLVariables = new URLVariables();
			val.text="COMRAD";
			val.depth=3.5;
			val.bevel=2;
			val.font = "ipagp";
			var req:URLRequest = new URLRequest("http://www.3dtext.in/api/for_wonderfl_demo_key");
			req.data=val;
			var loader:URLLoader = new URLLoader();
			loader.dataFormat = URLLoaderDataFormat.BINARY;
			loader.addEventListener(Event.COMPLETE, completeHandler);
			loader.load(req);
		}
		private function completeHandler(event:Event):void
		{
			var randomBox:RigidBody;
			var flatShadedMaterial:FlatShadeMaterial = new FlatShadeMaterial(sceneLight, 0x77ee77);
			flatShadedMaterial.interactive = true;
			var prevSphere:RigidBody;
			var data:ByteArray = event.target.data;
			data.endian = Endian.LITTLE_ENDIAN
			var q:int; var sum:int = 0
			try {
				while (q = data.readUnsignedShort()) {
					var t:TriangleMesh3D = new TriangleMesh3D(flatShadedMaterial, new Array(), new Array());
					var arr: Array = new Array();
					if(q>1)for (var a:int = 0; a < q; a++) {
						var v1:Vertex3D = new Vertex3D(data.readFloat(), data.readFloat(),data.readFloat())
						var v2:Vertex3D = new Vertex3D(data.readFloat(), data.readFloat(),data.readFloat())
						var v3:Vertex3D = new Vertex3D(data.readFloat(), data.readFloat(),data.readFloat())
						t.geometry.vertices.push(v1);t.geometry.vertices.push(v2);t.geometry.vertices.push(v3);
						t.geometry.faces.push(new Triangle3D(t, [v1,v2,v3],flatShadedMaterial, [new NumberUV(data.readFloat(),data.readFloat()),new NumberUV(data.readFloat(),data.readFloat()),new NumberUV(data.readFloat(),data.readFloat())]));
					}
					for (var i:int = 0; i < 9; i++) {arr.push(data.readFloat());}
					t.extra = { stat:arr }; sum += arr[0];
					letters.push(t);	
				}
			} catch (err:Error) {
			}finally {
				var xy:Array = [new Point(-220,200),new Point(0,250),new Point(220,300),new Point(-90,700),new Point(90,800),new Point(0,1200)];
				if (letters.length > 1) { sum +=(letters.length - 1)* spacer; }
				letters[0].x = -sum / 2+letters[0].extra.stat[0]/2;
				for (var i:int = 0; i < letters.length; i++ ) {
					scene.addChild(letters[i]);
					var jbox:JBox = new JBox(new Pv3dMesh(letters[i]), letters[i].extra.stat[0], letters[i].extra.stat[2], letters[i].extra.stat[1]);
					physics.addBody(jbox);
					jbox.mass = 2;jbox.y = xy[i].y + 75;jbox.x = xy[i].x;
					physics.getMesh(jbox).addEventListener(InteractiveScene3DEvent.OBJECT_PRESS, handleMousePress);
					vplObjects.addDisplayObject3D(physics.getMesh(jbox));	
				}
			}
		}
		private function handleMousePress(event:InteractiveScene3DEvent):void
		{
			mouseConstraint = new MouseConstraint(event.displayObject3D, new Number3D(0, 0, 0.3), camera, viewport);
			stage.addEventListener(MouseEvent.MOUSE_UP, removeMouseConstraint);
		}
		private function removeMouseConstraint(e:MouseEvent):void
		{
			stage.removeEventListener(MouseEvent.MOUSE_UP, removeMouseConstraint);
			mouseConstraint.destroy();
			mouseConstraint = null;
		}
		override protected function onRenderTick(event:Event = null):void
		{
			physics.step();
			renderer.renderScene(scene, camera, viewport);
		}
	}
}

