/**
 * Copyright Nos_lkSsvOhB ( http://wonderfl.net/user/Nos_lkSsvOhB )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6IFL
 */

// forked from daijimachine's Dobuemon ~With Suneo's Theme~
/**
* Dobuemon ~With Suneo's Theme~
* 
* Blenderでモデリングの練習。
* 自分のTwitterアイコンとして使わせてもらっているドブえもんを3D化してみた。
* わりとキモいです。ごめんなさい。
* ついでにスネオのテーマを添えてみました。
* 
* モデリング下手くそだなー。自分を戒めて今後頑張る意味で晒してみる。
* 
* フェイスアニメーションを入れたかったけど、ColladaにExportしてくれなかったので、
* あとでやる気が出たら、Pythonなどいじったりして頑張ってみる。
* 
* スネオのテーマのMMLは以下から拝借しました。ありがとうございます。
* http://wonderfl.net/c/Acjv
* 
* @author Masayuki Daijima (ARCHETYP Inc.)
* http://www.daijima.jp/
* http://twitter.com/daijimachine
*/

package 
{
    import com.bit101.components.ProgressBar;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.easing.Quad;
    import org.libspark.betweenas3.tweens.ITween;
    import org.papervision3d.events.FileLoadEvent;
    import org.papervision3d.objects.parsers.DAE;
    import org.papervision3d.view.BasicView;
    import org.si.sion.SiONData;
    import org.si.sion.SiONDriver;
    
    [SWF(backgroundColor = "#000000", frameRate = "60", width = "465", height = "465")]
    
    public class Document extends BasicView
    { 
        private var _dobuemon:DAE;
        private var _driver:SiONDriver;
        private const DAE_URL:String = "";
        private var _p_bar:ProgressBar;
        private var _loadPercent:Number = 0;
        
        private var _tw:ITween;
        
        public function Document()
        {
            super(0, 0, true, false, "TARGET");
            this.addEventListener(Event.ADDED_TO_STAGE, onAdd);
        }
        
        private function onAdd(event:Event):void 
        {
            event.target.removeEventListener(event.type, arguments.callee);
            init();
        }
        
        public function init():void 
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            //stage.quality = "MEDIUM";
            
            setProgressBar();
            initPapervision();
        }
        
        private function setProgressBar():void
        {
            _p_bar = new ProgressBar(this, 182, 232);
            addEventListener(Event.ENTER_FRAME, update);
        }
        
        private function update(event:Event):void 
        {
            _p_bar.value += (_loadPercent - _p_bar.value) * .3;
            
            if (_p_bar.value > .999) {
                _p_bar.value = 1;
                event.target.removeEventListener(event.type, arguments.callee);
                
                _tw = BetweenAS3.serial(
                    BetweenAS3.to(_p_bar, { alpha:0 }, .5, Quad.easeOut), 
                    BetweenAS3.removeFromParent(_p_bar)
                );
                _tw.play();
                start();
            }
        }
        
        protected function initPapervision():void 
        {
            camera.zoom = 1;
            camera.focus = 800;
            camera.z = -800;
            //camera.y = 300;
            
            _dobuemon = new DAE(false);
            _dobuemon.addEventListener(FileLoadEvent.LOAD_PROGRESS, onLoadProgressDae);
            _dobuemon.addEventListener(FileLoadEvent.LOAD_COMPLETE, onLoadCompleteDae);
            _dobuemon.load(DAE_URL);
            _dobuemon.scale = 30;
            //camera.target = _dobuemon;
        }
        
        private function onLoadProgressDae(event:FileLoadEvent):void 
        {
            var per:Number = event.bytesLoaded / event.bytesTotal
            if (isNaN(per)) per = 0;
            _loadPercent = per;
        }
        
        private function onLoadCompleteDae(event:FileLoadEvent):void 
        {
            _dobuemon.removeEventListener(FileLoadEvent.LOAD_PROGRESS, onLoadProgressDae);
            _dobuemon.removeEventListener(FileLoadEvent.LOAD_COMPLETE, onLoadCompleteDae);
        }
        
        private function start():void
        {
            scene.addChild(_dobuemon);
            startRendering();
            setSion();
        }
        
        private function setSion():void
        {
            _driver = new SiONDriver();
            
            //Suneo's Theme
            var mml:String = "#EFFECT0{reverb 70,80,60,30};";
            mml += "#REV;t82;";
            mml += "#OPM@0{5,7,19,11,18,10,1,24,0,1,3,0,0,21,18,10,7,2,10,1,1,0,0,0,21,18,10,7,2,0,0,1,-3,0,0,21,18,10,7,2,10,0,1,7,0,0};";
            mml += "#OPM@10{3,7,31,0,0,7,0,35,0,1,0,0,0,25,14,0,4,2,40,0,4,0,0,0,31,0,0,8,0,38,0,2,0,0,0,18,7,0,8,1,0,0,1,0,0,0};";
            mml += "%6 @10 v12 q3 l16 r1$r2..[d+e g8r4 d+eg8r4ec <a8r2. b>c|<a8r4b>c<a8r4b>c d8r2.] e8r4dc<a8r4b8>c8r2..;";
            mml += "%6 @0 v12 o4 q5 l16 $[[c8f64*f+32.f+64*g32.| >c8<g8]>c<gf+g] [c8f64*f+32.f+64*g32.| >c8<g8]>c<gf+g [[<a8>d+e|a8e8] aed+e] <g8>cdg8e8 <g8>cdg4 [c8f64*f+32.f+64*g32.| >c8<g8]>c<gf+g [<a8>d+e|a8e8] aed+e d8f+16a16>d8<a8 g4gfed;";
            
            var playData:SiONData = _driver.compile(mml);
            _driver.play(playData);
        }
        
        protected override function onRenderTick(event:Event = null):void 
        {
            _dobuemon.rotationX += (((stage.mouseY - (stage.stageHeight/2)) * -.3) - _dobuemon.rotationX ) * .6;
            _dobuemon.rotationY += (((stage.mouseX - (stage.stageWidth/2)) * -.3) - _dobuemon.rotationY ) * .6;
            
            super.onRenderTick(event);
        }
    }
}