/**
 * Copyright aobyrne ( http://wonderfl.net/user/aobyrne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6HvM
 */

 package 
{
    import com.bit101.components.CheckBox;
    import com.bit101.components.HUISlider;
    import com.bit101.components.VBox;
    import flash.display.Bitmap;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.system.fscommand;
    import flash.geom.Point;
    
    public class WonderflTejido extends Sprite 
    {
        static private const GOLDEN_RATIO:Number = 0.618;
        private var tejidoGrid:TejidoGrid;
        private var elementWidth:Number;
        private var gridWidth:int;
        private var gridHeight:int;
        private var isRandom:Boolean;
        private var isTransforming:Boolean;
        private var hUISliderRatio:HUISlider;
        private var checkBoxTransforming:CheckBox;
        private var perlinNoiseOffset:uint;
        
        public function WonderflTejido():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            stage.addEventListener(KeyboardEvent.KEY_DOWN, function (e:KeyboardEvent):void { if ("Q" == String.fromCharCode(e.keyCode)) fscommand("quit"); }, false, 0, true);
            
            graphics.lineStyle(0);
            
            elementWidth = 15;
            isRandom = true;
            isTransforming = true;
            
            
            resetTejidoGrid();
            
            tejidoGrid.draw(graphics,isTransforming);
            
            graphics.lineStyle(10);
            graphics.drawRect(0, 0, gridWidth, gridHeight);
            var vBox:VBox = new VBox(this, 10, 10);
            hUISliderRatio = new HUISlider(null, 0, 0, 'ratio', onRatio);
            hUISliderRatio.maximum = 1;
            var hUISliderSize:HUISlider = new HUISlider(null, 0, 0, 'size', onSize);
            hUISliderSize.minimum = 10;
            hUISliderSize.maximum = 100;
            hUISliderSize.value = elementWidth;
            
            var checkBoxRandom:CheckBox = new CheckBox(null, 0, 0, 'isRandom', onRandom);
            checkBoxRandom.selected = isRandom;
            checkBoxTransforming = new CheckBox(null, 0, 0, 'isTransforming', onTransform);
            checkBoxTransforming.selected = isTransforming;
            
            vBox.addChildAt(hUISliderSize, vBox.numChildren);
            vBox.addChildAt(checkBoxRandom, vBox.numChildren);
            vBox.addChildAt(checkBoxTransforming, vBox.numChildren);
            vBox.addChildAt(hUISliderRatio, vBox.numChildren);
            
            hUISliderRatioAbility();
            addEventListener(Event.ENTER_FRAME, loopIt);
        }
        
        private function loopIt(e:Event):void 
        {
            if (isRandom) 
            {
                
            perlinNoiseOffset += 10;
            trace( "perlinNoiseOffset : " + perlinNoiseOffset );
            tejidoGrid.bitmapData.perlinNoise(50, 50, 1, 1, false, true, 7, true, [new Point(perlinNoiseOffset,0)]);
            clearGraphics();
            tejidoGrid.draw(graphics, isTransforming);
            }
        }
        
        private function onTransform(e:Event):void 
        {
            isTransforming = CheckBox(e.target).selected;
            clearGraphics();
            tejidoGrid.draw(graphics, isTransforming);
            hUISliderRatioAbility();
            hUISliderRatio.enabled = !isTransforming;
        }
        
        private function hUISliderRatioAbility():void 
        {
            
            hUISliderRatio.enabled = !tejidoGrid.isRandomRatio;
            checkBoxTransforming.enabled = !tejidoGrid.isRandomRatio;
            hUISliderRatio.enabled = !isTransforming && !tejidoGrid.isRandomRatio;
        }
        
        private function onRandom(e:Event):void 
        {
            clearGraphics();
            isRandom= tejidoGrid.isRandomRatio = CheckBox(e.target).selected;
            tejidoGrid.draw(graphics, isTransforming);
            hUISliderRatioAbility();
        }
        
        private function onSize(e:Event):void 
        {
            clearGraphics();
            elementWidth = uint(HUISlider(e.target).value);
            resetTejidoGrid();
        }
        
        private function onRatio(e:Event):void 
        {
            clearGraphics();
            tejidoGrid.ratio = HUISlider(e.target).value;
            tejidoGrid.draw(graphics, isTransforming);
        }
        
        private function resetTejidoGrid():void 
        {
            var elementHeight:Number = GOLDEN_RATIO * elementWidth;
            var separation:Number = elementHeight * 0.5 + elementWidth * 0.5;
            gridWidth = stage.stageWidth;
            var columns:int = Math.ceil(gridWidth / separation);
            columns = columns % 2 ? columns + 1:columns;
            gridHeight = stage.stageHeight;
            var rows:int = Math.ceil(gridHeight / separation);
            rows++;
            var totalElements:int = columns * rows;
            if (!tejidoGrid) 
            {
                tejidoGrid = new TejidoGrid(columns, totalElements, elementWidth, elementHeight, 0.2,[0x00,0x555555],isRandom);
            }
            else
            {
                tejidoGrid.colsAmount = columns;
                tejidoGrid.totalAmount = totalElements;
                tejidoGrid.eWidth = elementWidth;
                tejidoGrid.eHeight = elementHeight;
                tejidoGrid.draw(graphics,isTransforming)
            }
        }
        
        private function clearGraphics():void 
        {
            graphics.clear();
            graphics.lineStyle(0);
        }
        
    }
    
}
import flash.display.BitmapData;
import flash.display.Graphics;
class TejidoGrid 
{
    private var _colsAmount:uint;
    private var _totalAmount:uint;
    private var _eWidth:Number;
    private var _eHeight:Number;
    private var separation:Number;
    private var _ratio:Number;
    private var colors:Array;
    public var bitmapData:BitmapData;
    private var _isRandomRatio:Boolean;
    
    public function TejidoGrid(colsAmount:uint, totalAmount:uint, width:Number, height:Number, ratio:Number, colors:Array,isRandomRatio:Boolean=false) 
    {
        this.isRandomRatio = isRandomRatio;
        this.colors = colors;
        this.ratio = ratio;
        this.eHeight = height;
        this.eWidth = width;
        this.totalAmount = totalAmount;
        this.colsAmount = colsAmount;
        setSeparation();
        var rowsAmount:uint = totalAmount / colsAmount;
        bitmapData = new BitmapData(colsAmount*separation, rowsAmount*separation);
        bitmapData.perlinNoise(50,50,1,1,false,true,1,true)
    }
    
    public function draw(g:Graphics, isTransforming:Boolean = true):void 
    {
        var orientation:Number;
        var actualRatio:Number;
        var yy:Number;
        var xx:uint;
        var fundamentalElement:FundamentalElement;
        for (var i:int = 0; i <= totalAmount; i++) 
        {
            yy = Math.floor(i / colsAmount);
            xx = uint(i % colsAmount);
            actualRatio = isTransforming?GaussianDistribution.getNormalizedValue(2 * xx / colsAmount - 1, 0, 0.25):ratio;
            //actualRatio = isTransforming?SCMath.normalDistribution(2*xx / colsAmount-1, 0.5, 1):ratio;
            //actualRatio = isTransforming?xx / colsAmount:ratio;
            actualRatio = isRandomRatio?((bitmapData.getPixel(xx*separation, yy*separation) & 0xff) / 255):actualRatio;
            fundamentalElement = new FundamentalElement(separation * xx, separation * yy, eHeight, eWidth, actualRatio);
            orientation = (yy % 2 + i) % 2;
            g.beginFill(colors[orientation]);
            fundamentalElement.draw(g, orientation);
            
        }
        g.beginFill(0, 0);
    }
    
    private function setSeparation():void 
    {
        separation = _eWidth * 0.5 + _eHeight * 0.5;
    }
    
    public function get ratio():Number 
    {
        return _ratio;
    }
    
    public function set ratio(value:Number):void 
    {
        _ratio = value;
    }
    
    public function get colsAmount():uint 
    {
        return _colsAmount;
    }
    
    public function set colsAmount(value:uint):void 
    {
        _colsAmount = value;
    }
    
    public function get totalAmount():uint 
    {
        return _totalAmount;
    }
    
    public function set totalAmount(value:uint):void 
    {
        _totalAmount = value;
    }
    
    public function get eWidth():Number 
    {
        return _eWidth;
    }
    
    public function set eWidth(value:Number):void 
    {
        _eWidth = value;
        setSeparation();
    }
    
    public function get eHeight():Number 
    {
        return _eHeight;
    }
    
    public function set eHeight(value:Number):void 
    {
        _eHeight = value;
        setSeparation();
    }
    
    public function get isRandomRatio():Boolean 
    {
        return _isRandomRatio;
    }
    
    public function set isRandomRatio(value:Boolean):void 
    {
        _isRandomRatio = value;
    }
    
    
}

import flash.display.Graphics;
import flash.geom.Matrix;
import flash.geom.Point;
class FundamentalElement 
{
    private var cx:Number;
    private var cy:Number;
    private var height:Number;
    private var width:Number;
    private var ratio:Number;
    private var AA:Point;
    private var BB:Point;
    private var matrix:Matrix;
    private var array:Array;
    
    public function FundamentalElement(cx:Number, cy:Number, height:Number, width:Number, ratio:Number) 
    {
        this.ratio = ratio;
        this.width = width;
        this.height = height;
        this.cy = cy;
        this.cx = cx;
        AA = new Point;
        BB = new Point;
        matrix = new Matrix;
        matrix.rotate(Math.PI * 0.5);
        
        doSet();
    }
    
    private function doSet():void 
    {
        AA.x = ratio * width * 0.5;
        AA.y = 0.5 * height;
        
        
        BB.x = 0.5 * width;
        array = [AA,BB,new Point(AA.x,-AA.y),new Point(-AA.x,-AA.y),new Point(-BB.x,BB.y),new Point(-AA.x,AA.y)];
    }
    
    public function draw(g:Graphics,isRotated:uint=0):void 
    {
        if (isRotated) 
        {
            for (var i:int = 0; i < array.length; i++) 
            {
                array[i] = matrix.transformPoint(array[i]);
            }
        }
        g.moveTo(cx + array[array.length-1].x, cy + array[array.length-1].y);
        for (var j:int = 0; j < array.length; j++) 
        {
            g.lineTo(cx+array[j].x, cy+array[j].y);
        }
    }
    
    
}
class SCMath
{
    static private var normalDistriutionFactor:Number = 1 / Math.sqrt(Math.PI * 2);
    static public function normalDistribution(x:Number, mu:Number, sigma:Number):Number
    {
        var s:Number = 1 / sigma;
        return s*normalDistriutionFactor*Math.pow(Math.E,-(x-mu)*(x-mu)*s*s*0.5);
    }
}
class GaussianDistribution 
{
    private var mu:Number;
    private var _sigma:Number;
    private var factor:Number;
    
    public function GaussianDistribution(mu:Number, sigma:Number) 
    {
        this.sigma = sigma;
        this.mu = mu;
        
        
    }
    
    public function getData():Array 
    {
        var gaussian:Number;
        var pow:Number;
        var xx:Number;
        var normal:Number;
        var steps:int = 100;
        var delta:Number = 1 / steps;
        var data:Array = [];
        var initxx:Number = -5;
        var finalxx:Number = 5;
        var size:Number = 10;
        size = finalxx > initxx?finalxx - initxx:initxx - finalxx;
        for (var i:int = 0; i < steps; i++) 
        {
            normal = i * delta;
            xx = size * (normal - 0.5);
            pow = -(xx - mu) * (xx - mu)/(2*sigma*sigma);
            gaussian = factor * Math.pow(Math.E, pow);
            data[i] = gaussian;
        }
        return data;
    
    }
    
    public static function getNormalizedValue(xx:Number, mu:Number, sigma:Number):Number
    {
        return getValue(xx, mu, sigma) / getValue(mu, mu, sigma);
    }
    public static function getValue(xx:Number, mu:Number, sigma:Number):Number
    {
        var gaussian:Number;
        var pow:Number;
        var s:Number = 1 / sigma;
        var factor:Number  = s / Math.sqrt(2 * Math.PI);
        pow = -(xx - mu) * (xx - mu)*s*s*0.5;            
        gaussian = factor * Math.pow(Math.E, pow);
        return gaussian
    }
    
    public function get sigma():Number 
    {
        return _sigma;
    }
    
    public function set sigma(value:Number):void 
    {
        _sigma = value;
        factor = 1 /( sigma * Math.sqrt(2 * Math.PI));
    }
    
}
