/**
 * Copyright sakusan393 ( http://wonderfl.net/user/sakusan393 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6Ga1
 */

/*
 * MosquitoAttackReal
 * (to use the headphone)
 * 
 * 蚊叩き
 * (ヘッドフォン推奨)
 * 羽音を頼りに耳障りな蚊をクリックで潰しましょう。
 * 
 * 蚊の羽音は友達が気持ち悪いの作ってくれましたｗ
 *
 * 蚊の描画のソースはnutsuさんのcheckmate作品より拝借しました。
 * http://wonderfl.net/c/3OcH
 * 
 * */

package  
{
    import flash.display.BitmapData;
    import flash.display.Shape;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.ProgressEvent;
    import flash.events.TimerEvent;
    import flash.geom.Transform;
    import flash.media.Sound;
    import flash.media.SoundMixer;
    import flash.media.SoundTransform;
    import flash.net.URLRequest;
    import flash.text.TextField;
    import flash.utils.Timer;
    import org.papervision3d.events.InteractiveScene3DEvent;
    import org.papervision3d.materials.BitmapMaterial;
    import org.papervision3d.materials.WireframeMaterial;
    import org.papervision3d.objects.primitives.Cube;
    import org.papervision3d.objects.primitives.Cylinder;
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.objects.special.Sound3D;
    import org.papervision3d.view.BasicView;
    
    [SWF(backgroundColor="0x0", frameRate="30", width="465", height="465")]
    /**
     * ...
     * @author 393
     */
    public class MosquitoAttack2 extends BasicView
    {
        
        private var _cylinder:Cylinder;
        private var _cube:Cube;
        private var _angle:Number = Math.random();
        private var _mosquitoPlane:Plane;
        private var _mosquitoGraArray:Vector.<BitmapMaterial> = new Vector.<BitmapMaterial>();
        
        //羽音
        private static const SAMPLING_RATE:int = 44100;
        private static const SAMPLE_SIZE:int = 8192; // 2048 〜 8192
        private var frequency:Number = 1700;
        private var phase:Number = 0.0;
        private var _sound:Sound;
        private var _sound3D:Sound3D;
        private var _count:int;
        private var _timer:Timer;
        private var _clapSound:Sound;
        private var _loadBar:Shape;
        private var _tf:TextField;
        
        public function MosquitoAttack2() 
        {
            super(465, 465, true, true, "Free");
            this.addEventListener(Event.ADDED_TO_STAGE , loadSound);
        }
        
        private function loadSound(e:Event):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, loadSound);
            _clapSound = new Sound(new URLRequest("http://393.bz/data/claphands.mp3"));
            
            _sound = new Sound();
            _sound.load(new URLRequest("http://393.bz/data/Mosquito_loop2_3.mp3"));
            _sound.addEventListener(Event.COMPLETE , init);
            _sound.addEventListener(ProgressEvent.PROGRESS , progressHandler);
            
            var sT:SoundTransform = new SoundTransform();
            sT.volume = .3;
            SoundMixer.soundTransform = sT;
            
            //羽音のロードバー
            _loadBar = new Shape();
            _loadBar.graphics.beginFill(0xFFFFFF);
            _loadBar.graphics.drawRect(0, stage.stageHeight / 2, stage.stageWidth, 20);
            _loadBar.graphics.endFill();
            addChild(_loadBar);
            _loadBar.scaleX = 0;
            //
            _tf = new TextField();
            _tf.text = "sound loading...";
            _tf.x = stage.stageWidth / 2 - _tf.width / 2;
            _tf.y = stage.stageHeight / 2 - 20;
            _tf.textColor = 0xFFFFFF;
            addChild(_tf);
        }
        
        private function progressHandler(e:ProgressEvent):void 
        {
            _loadBar.scaleX = e.bytesLoaded / e.bytesTotal;
            trace("_loadBar.scaleX : " + _loadBar.scaleX);
        }
        
        private function init(e:Event):void 
        {
            removeChild(_loadBar);
            removeChild(_tf);
            
            //カメラ位置初期化
            camera.x = camera.z = 0;
            camera.y = 1000;
            camera.zoom = 40
            camera.rotationX = 10;
            camera.rotationY = 180;
            
            // 地面を作成
            var wireP:WireframeMaterial = new WireframeMaterial(0x666699);
            var plane:Plane = new Plane(wireP, 10000, 10000, 10, 10);
            plane.rotationX = 90;
            plane.x = 10;
            plane.y = 0;
            plane.z = 10;
            scene.addChild(plane);
            
            //蚊を生成
            //var colorMaterial:ColorMaterial = new ColorMaterial(0xFFFFFF);
            _mosquitoGraArray[0] = new BitmapMaterial(fig1());
            _mosquitoGraArray[1] = new BitmapMaterial(fig2());
            _mosquitoGraArray[2] = new BitmapMaterial(fig3());
            for (var i:int = 0; i < 2; i++)
            {
                _mosquitoGraArray[0].interactive = true;
            }
            _mosquitoPlane = new Plane(_mosquitoGraArray[0], 20, 20, 1);
            _mosquitoPlane.addEventListener(InteractiveScene3DEvent.OBJECT_CLICK , clickHandler);
            _mosquitoPlane.addEventListener(InteractiveScene3DEvent.OBJECT_OVER , overHandler);
            _mosquitoPlane.addEventListener(InteractiveScene3DEvent.OBJECT_OUT , outHandler);
            scene.addChild(_mosquitoPlane);
            _mosquitoPlane.y = 900;
            _mosquitoPlane.x = Math.sin(_angle) * 100;
            _mosquitoPlane.z = Math.cos(_angle) * 100;
            
            //蚊の羽音
            // サウンド3Dを作成
            _sound3D = new Sound3D(_sound);
            scene.addChild(_sound3D);
            _sound3D.play(0, 9999);            
            
            addEventListener(Event.ENTER_FRAME , enterFrameHandler);
            
            startRendering();
            
            //蚊のグラフィック変化
            _timer = new Timer(100);
            _timer.addEventListener(TimerEvent.TIMER, timerHandler);
            _timer.start();
            
            stage.addEventListener(MouseEvent.MOUSE_DOWN, downHandler);
        }
        
        private function overHandler(e:InteractiveScene3DEvent):void 
        {
            viewport.buttonMode = true;
        }
        private function outHandler(e:InteractiveScene3DEvent):void 
        {
            viewport.buttonMode = false;
        }
        
        private function downHandler(e:MouseEvent):void 
        {
            _clapSound.play();
        }
        
        private function timerHandler(e:TimerEvent):void 
        {
            _count ++;
            var bMat:BitmapMaterial;
            if (_count % 2 == 0) bMat = _mosquitoGraArray[0];
            else bMat = _mosquitoGraArray[1];
            _mosquitoPlane.material = bMat;
        }
        public function fig1():BitmapData 
        {
         return BitmapPatternBuilder.build(
            [[1,0,0,1,0,0,1],
            [1,0,1,1,1,0,1],
            [1,1,1,1,1,1,1],
            [0,1,1,1,1,1,0],
            [0,0,1,1,1,0,0],
            [0,1,0,1,0,1,0],
            [1,0,0,1,0,0,1]],
            [0x00000000, 0xFFFFFFFF]);
        }    
        public function fig2():BitmapData 
        {
         return BitmapPatternBuilder.build(
            [[0,0,0,1,0,0,0],
            [0,0,1,1,1,0,0],
            [0,1,1,1,1,1,0],
            [1,1,1,1,1,1,1],
            [1,0,1,1,1,0,1],
            [0,1,0,1,0,1,0],
            [0,1,0,1,0,1,0]],
            [0x00000000, 0xFFFFFFFF]);
        }
        public function fig3():BitmapData 
        {
         return BitmapPatternBuilder.build(
            [[1,0,0,1,0,0,1],
            [0,1,0,1,1,1,0],
            [1,1,1,1,1,0,0],
            [0,1,1,1,1,1,0],
            [0,0,1,1,1,0,1],
            [0,1,0,1,1,1,0],
            [1,0,0,0,1,0,1]],
            [0x00000000, 0xFFFF0000]);
        }
        
        
        private function clickHandler(e:InteractiveScene3DEvent):void 
        {
            trace("attack");
            _sound3D.stop();
            _timer.stop();
            var bMat:BitmapMaterial = _mosquitoGraArray[2];
            _mosquitoPlane.material = bMat;
            stopRendering();
            singleRender();
        }
        private function enterFrameHandler(e:Event):void 
        {
            
            camera.rotationY += (((mouseX / stage.stageWidth) * 360)-camera.rotationY)*0.02;
            camera.rotationX += ((((mouseY / stage.stageHeight) - 0.5) * 45) - camera.rotationX) * 0.02;
            
            _mosquitoPlane.x = Math.sin(_angle) * 3500;
            _mosquitoPlane.z = Math.cos(_angle*1.3) * 1000;
            _mosquitoPlane.y = Math.cos(_angle * 5) * 500 + 1000;
            _sound3D.copyPosition(_mosquitoPlane);
            
            _mosquitoPlane.rotationY = camera.rotationY;
            _angle -= 0.005;

        }
        
    }

}
import flash.display.BitmapData;
import flash.display.Graphics;
     
 class BitmapPatternBuilder{
     /**
      * creates BitmapData filled with dot pattern.
      * First parameter is 2d array that contains color index for each pixels;
      * Second parameter contains color reference table.
      *
      * @parameter pattern:Array 2d array that contains color index for each pixel.
      * @parameter colors:Array 1d array that contains color table.
      * @returns BitmapData
      */
     public static function build(pattern:Array, colors:Array):BitmapData{
         var bitmapW:int = pattern[0].length;
         var bitmapH:int = pattern.length;
         var bmd:BitmapData = new BitmapData(bitmapW,bitmapH,true,0x000000);
         for(var yy:int=0; yy<bitmapH; yy++){
             for(var xx:int=0; xx<bitmapW; xx++){
                 var color:int = colors[pattern[yy][xx]];
                 bmd.setPixel32(xx, yy, color);
             }
         }
         return bmd;
     }
     
     /**
      * short cut function for Graphics.beginBitmapFill with pattern.
      */
     public static function beginBitmapFill(pattern:Array, colors:Array, graphics:Graphics):void{
         var bmd:BitmapData = build(pattern, colors);
         graphics.beginBitmapFill(bmd);
         bmd.dispose();        
     }
 }