/**
 * Copyright WLAD ( http://wonderfl.net/user/WLAD )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6FrK
 */

package {
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.geom.Vector3D;
    import flash.text.TextField;
    import flash.events.Event;
    import flash.system.System;
    import flash.display.Sprite;
    import away3d.containers.View3D;
    import away3d.debug.AwayStats;
    import away3d.Away3D;

    public class FlashTest extends Sprite {
        
        private var view:View3D;
        private var cube:Cube3D;
        private var stats:AwayStats;
        //private var source:BitmapData = new BitmapData(465, 465, false, 0x000000);
        
        public function FlashTest() {
            // write as3 code here..
            if(stage) init();
            else addEventListener("addedToStage", init);                 
        }
        private function init(e:Event = null):void
        {    
            stage.align = "topLeft";
            stage.scaleMode = "noScale";
            var w:Number = stage.stageWidth;
            var h:Number = stage.stageHeight;
           
            Wonderfl.disable_capture();
           // addChild(new Bitmap(source));
            

            System.pauseForGCIfCollectionImminent(1);
        
            
            view = new View3D();
            addChild(view);
            view.backgroundColor = 0x000000;
            view.antiAlias = 4;
            view.camera.z = -60;
            cube = new Cube3D(30, 0xFF8000);
            view.scene.addChild(cube);
            
            stats = new AwayStats(view, false, false, 0, false, true);
            stage.addChild(stats);
            stats.x = stage.stageWidth - stats.width;

            
            addEventListener("enterFrame", loop);
           
            OnScreenTrace.init(this);
            
            addEventListener("click", onClick);
            
        }
        
        private var rotationModeIsNative:Boolean = true;
        private function onClick(e:Event):void
        {
            rotationModeIsNative = !rotationModeIsNative;
        }
        
        private var xRot:Number = 0;
        private var yRot:Number = 0;
        private var zRot:Number = 0;
        
        private function loop(e:Event):void
        {
            var my:int = int(-mouseY/4);
            var mx:int = int(-mouseX/4);
            
            if(rotationModeIsNative)
            {
                cube.rotationZ = my;
                cube.rotationY = mx;
            } else {
                
                cube.rotate(Vector3D.Z_AXIS, my - zRot);
                zRot = my;
                
                cube.rotate(Vector3D.Y_AXIS, mx - yRot);
                yRot = mx;
            }

            trace("Rotation mode: '" + (rotationModeIsNative ? "native" : "fixed") + "'\n"+
                "[Click to change]\n" + 
                "Rotation "+
                    "X:" + cube.rotationX.toFixed(1) + 
                    ", Y:" + cube.rotationY.toFixed(1) + 
                    ", Z:" + cube.rotationZ.toFixed(1));

            view.render();
            //view.renderer.queueSnapshot(source);
        }


        
    }
}
import flash.display.Sprite;
import flash.text.TextField;
import flash.geom.Vector3D;
import away3d.entities.Mesh;
import away3d.debug.Trident;
import away3d.materials.ColorMaterial;
import away3d.primitives.CubeGeometry;
class OnScreenTrace {
    private static var ost:TextField;
    public static function init(parent:Sprite):void {
        ost = new TextField();ost.autoSize = "left";ost.background =true;ost.visible = false;
        ost.backgroundColor = 0x0;ost.textColor = 0xFFFFFF;parent.addChild(ost);}
    public static function out(text:String):void{ost.visible = true;ost.text = text;}
}
function trace(...argumnets):void {
    OnScreenTrace.out(String(argumnets));
}


class V3D extends Vector3D
{
    private static const deg2rad:Number = Math.PI / 180;
    private static const rad2deg:Number = 180 / Math.PI;
    
    public function V3D(x:Number = 0, y:Number = 0, z:Number = 0, w:Number = 0)
    {
        super(x, y, z, w);
    }
    
    public function get rotationX():Number {
        return rotationXRadians * rad2deg;
    }
    public function set rotationX(value:Number):void {
        rotationXRadians = value * deg2rad;
    }
    public function get rotationXRadians():Number {
        return Math.atan2(z, y);
    }
    public function set rotationXRadians(value:Number):void {
        var length:Number = this.length;
        y = Math.cos(value) * length;
        z = Math.sin(value) * length;
    }
    public function get rotationY():Number {
        return rotationYRadians * rad2deg;
    }
    public function set rotationY(value:Number):void {
        rotationYRadians = value * deg2rad;
    }
    public function get rotationYRadians():Number {
        return Math.atan2(z, x);
    }
    public function set rotationYRadians(value:Number):void {
        var length:Number = this.length;
        x = Math.sin(value) * y;
        z = Math.cos(value) * y;
    }
    public function get rotationZ():Number {
        return rotationZRadians * rad2deg;
    }
    public function set rotationZ(value:Number):void {
        rotationZRadians = value * deg2rad;
    }
    public function get rotationZRadians():Number {
        return Math.atan2(y, x);
    }
    public function set rotationZRadians(value:Number):void {
        var length:Number = this.length;
        x = Math.cos(value) * z;
        y = Math.sin(value) * z;
    }
}


class Cube3D extends Mesh
{
    private var tridnet:Trident;
    public function Cube3D(size:int, color:uint, tridnet:Boolean = true)
    {
        super(new CubeGeometry(size, size, size), new ColorMaterial(color, 0.3));
        showBounds = true;
        if (tridnet)
        {
            this.tridnet = new Trident(size , false);
            addChild(this.tridnet);
        }

    }    
}