/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6Fpq
 */

// forked from umhr's RTMFPChat with Speed Test
package  {
    import com.bit101.components.*;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.NetStatusEvent;
    import flash.net.GroupSpecifier;
    import flash.net.NetConnection;
    import flash.net.NetGroup;
        
    [SWF(width = "465", height = "465", backgroundColor = "0", frameRate = "60")]
    public class RTMFPChat extends Sprite{        
        private const GROUP_NAME:String = "RTMFPChat/SpeedTest";
        private var _netConnection:NetConnection;
        private var _netGroup:NetGroup;
        private var _groupSpecifier:GroupSpecifier;
        private var _messageTextArea:TextArea;
        private var _inputTxt:InputText;
        private var _speedTxt:InputText;
        private var _startScreen:StartScreen;
        private var _time:Number;
        private var _numericStepper:NumericStepper;
        
        public function RTMFPChat() {
            //
            Style.embedFonts = false;
            Style.fontName = "_typewriter";
            Style.fontSize = 12;
            new PushButton(this, 359, 20, "Send Message", sendMsg);
            _messageTextArea = new TextArea(this, 10, 50);
            _messageTextArea.width = 448;
            _messageTextArea.height = 250;
            _inputTxt = new InputText(this, 10, 20);
            _inputTxt.width = 340;
            _inputTxt.height = 20;
            new Label(this, 10, 0, "Send Message");
            
            // Speed Test
            new PushButton(this, 10, 310, "Speed Test", speedTest);
            _speedTxt = new InputText(this, 114, 310);
            _speedTxt.width = 100;
            _speedTxt.height = 20;
            new Label(this, 220, 310, "msec");
            
            setFPSStepper();
            
            // Start Screen
            _startScreen = new StartScreen();
            _startScreen.pushButton.addEventListener(MouseEvent.CLICK, doConnect);
            addChild(_startScreen);
            

        }
        
        private function speedTest(event:MouseEvent):void 
        {
            _time = new Date().time;
            _netGroup.sendToAllNeighbors( { mode:"echoRequest", time:_time } );
        }
        
        private function doConnect(event:MouseEvent):void {
            _startScreen.pushButton.removeEventListener(MouseEvent.CLICK, doConnect);
            removeChild(_startScreen);
            //
            _netConnection = new NetConnection();
            _netConnection.addEventListener(NetStatusEvent.NET_STATUS, netStatusHandler);
            _netConnection.connect("rtmfp:");
        }

        private function netStatusHandler(event:NetStatusEvent):void {
            
            if (event.info.code == "NetGroup.Posting.Notify" || event.info.code == "NetGroup.SendTo.Notify") {
                if(event.info.message.mode == "echoRequest") {
                    _netGroup.post( { mode:"echoReply", time:new Date().time } );
                    return;
                }else if (event.info.message.mode == "echoReply") {
                    _speedTxt.text = String(new Date().time - _time);
                    return;
                }
            }
            
            //trace(e.target, e.info.code);
            _messageTextArea.text = event.info.code + "\n" + _messageTextArea.text;
            switch(event.info.code){
                case "NetConnection.Connect.Success":
                    addNetGroup()
                    break;
                case "NetGroup.Connect.Success":
                    break;
                case "NetStream.Connect.Success":
                    break;
                case "NetStream.Publish.Start":
                    break;
                case "NetGroup.Posting.Notify":
                case "NetGroup.SendTo.Notify":
                    _messageTextArea.text = event.info.message.text + "\n\n" +_messageTextArea.text;
                    break;
            }
        }
        
        // NetGroup
        private function addNetGroup():void{
            _groupSpecifier = new GroupSpecifier(GROUP_NAME);
            _groupSpecifier.routingEnabled = true;
            _groupSpecifier.postingEnabled = true;
            _groupSpecifier.ipMulticastMemberUpdatesEnabled = true;
            _groupSpecifier.addIPMulticastAddress("225.225.0.1:30303");
            _netGroup = new NetGroup(_netConnection, _groupSpecifier.groupspecWithAuthorizations());
            _netGroup.addEventListener(NetStatusEvent.NET_STATUS, netStatusHandler);
        }
        
        private function sendMsg(event:MouseEvent):void{
            var message:Object = new Object();
            message.text = _inputTxt.text;
            message.sender = _netGroup.convertPeerIDToGroupAddress(_netConnection.nearID); 
            _netGroup.sendToAllNeighbors(message);
        }
        
        private function setFPSStepper():void 
        {
            new Label(this, 320, 440, "FPS:");
            _numericStepper = new NumericStepper(this, 350, 440, onNumericStepper);
            _numericStepper.minimum = 1;
            _numericStepper.maximum = 120;
            _numericStepper.value = 60;
        }
        
        private function onNumericStepper(event:Event):void 
        {
            stage.frameRate = int(_numericStepper.value);
        }
    }
}

import com.bit101.components.*;
import flash.display.Sprite;
class StartScreen extends Sprite{
    public var pushButton:PushButton;
    public function StartScreen(){
        graphics.beginFill(0, .7);
        graphics.drawRect(0, 0, 465, 465);
        pushButton = new PushButton(this, 180, 230, "Start Connect", null);
        new Label(this, 95, 260, "To begin, please click the connections");
    }
}