/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6FFY
 */

// forked from bradsedito's Target 3D
 
 
 
package 
{
    import flash.display.*;
    import flash.geom.*;
    import flash.events.*;
    import com.greensock.*;
    import com.greensock.easing.*;

    [SWF(width="465",height="465",frameRate="30")]
 
 
    public class Main extends Sprite 
    {
        private var arrows:Array = new Array()
        private var arrowsNum:uint = 32
        private var Arrow:MovingObject
        
        public function Main():void 
        {
            for (var i:uint = 0; i < arrowsNum; i++) 
            {
                var movingTarget:Shape = new Shape()
                movingTarget.x = Math.random()*465
                movingTarget.y = Math.random()*465
                movingTarget.z = Math.random()*465
                Arrow = new MovingObject(movingTarget,            // Target
                                              Math.random()*465,  // x
                                              Math.random()*465,  // y
                                              Math.random()*465,  // z
                                              Math.random()*360,  // rotationZ
                                              Math.random()*360,  // rotationX
                                              6                   // Speed
                );
                
                addChild(Arrow);
                arrows.push(Arrow);
            }
            addEventListener(Event.ENTER_FRAME, sortZ);
        }
        
        private function sortZ(e:Event):void 
        {
            arrows = arrows.sortOn("z",Array.DESCENDING | Array.NUMERIC);
            for (var i:uint = 0; i < arrowsNum; i++) 
            {
                addChildAt(arrows[i] , i);
            }
        }
        
    }
}


import flash.display.*;
import flash.events.*;
import flash.geom.*;
import flash.filters.*;
class MovingObject extends Sprite 
{
    private var myTarget:Shape;
    private var nSpeed:Number;
    private var Speed:Number;
    private var curveLimit:Number = 12; 
    
    public function MovingObject(    vTarget:Shape, 
                                     vX:Number, vY:Number, vZ:Number, 
                                     vRotationZ:Number, vRotationX:Number, 
                                     Speed:Number
                                     ):void 
    {
        myTarget   =  vTarget;
        x          =  vX
        y          =  vY
        z          =  vZ
        rotationZ  =  vRotationZ
        rotationX  =  vRotationX
        Speed      =  Speed
        
        // Draw
        graphics.beginFill(Math.ceil(Math.random()*0xffffff));
        graphics.drawCircle( 0,0,10 ); 
        //graphics.moveTo(10,0);
        //graphics.lineTo(-40,-15); 
        //graphics.lineTo(-40,15);
        addEventListener(Event.ENTER_FRAME, xMove);
        addEventListener(Event.ENTER_FRAME, mLOC );
    }
    
    public  function mLOC( e:Event ):void
    {
        var mX:Number
        var mY:Number
        var mZ:Number
        mX = this.x
        mY = this.y
        mZ = this.z
    }

    private function xMove(e:Event):void 
    {
        var distXY:Number = Point.distance(new Point(x,y), new Point(myTarget.x, myTarget.y));
        var distYZ:Number = Point.distance(new Point(y,z), new Point(myTarget.y, myTarget.z));
        var distZX:Number = Point.distance(new Point(z,x), new Point(myTarget.z, myTarget.x));
        
        while(distXY < 200 && distYZ < 200 && distZX < 200) 
        {
            myTarget.x = Math.random()*600-67.5;
            myTarget.y = Math.random()*600-67.5;
            myTarget.z = Math.random()*600-67.5;
            distXY = Point.distance(new Point(x,y), new Point(myTarget.x, myTarget.y));
            distYZ = Point.distance(new Point(y,z), new Point(myTarget.y, myTarget.z));
            distZX = Point.distance(new Point(z,x), new Point(myTarget.z, myTarget.x));
        }

        var targetRadian:Number = Math.atan2(myTarget.y-y, myTarget.x-x);
        var targetAngle:Number = targetRadian/Math.PI*180;

        var dif:Number = angleBetween(rotationZ,targetAngle);
        if (Math.abs(dif) > curveLimit) {
            if (dif > 0) {
                rotationZ+=curveLimit;
            } else {
                rotationZ-=curveLimit;
            }
        } else {
            rotationZ+=dif;
        }

        var radian:Number = rotationZ / 180 * Math.PI;
        x += Math.cos(radian)*nSpeed;
        y += Math.sin(radian)*nSpeed;
        

        targetRadian = Math.atan2(myTarget.z-z, myTarget.y-y);
        targetAngle = targetRadian/Math.PI*180;

        dif = angleBetween(rotationX,targetAngle);
        if (Math.abs(dif) > curveLimit) {
            if (dif > 0) {
                rotationX+=curveLimit;
            } else {
                rotationX-=curveLimit;
            }
        } else {
            rotationX+=dif;
        }

        radian = rotationX / 180 * Math.PI;
        y += Math.cos(radian)*nSpeed;
        z += Math.sin(radian)*nSpeed;

        if (z > 0) {
            var vBlur:uint = Math.floor(z/30);
            filters = [new BlurFilter(vBlur,vBlur,3)];
        }
    }

    private function angleBetween(myAngle:Number, targetAngle:Number):Number {
        var diffAngle:Number = targetAngle - myAngle;
        while (diffAngle < 0) diffAngle+=360;
        diffAngle %= 360;
        if (diffAngle > 180) diffAngle = diffAngle-360;
        return (diffAngle);
    }
}



        /*
        // ターゲットの方向を得る ## Y軸(z, x) ##
        targetRadian = Math.atan2(myTarget.x-x, myTarget.z-z);
        targetAngle = targetRadian/Math.PI*180;
        // 角度の差から進む方向を決め、徐々に向きを変える
        dif = angleBetween(rotationY,targetAngle);
        if (Math.abs(dif) > curveLimit) {
            if (dif > 0) {
                rotationY+=curveLimit;
            } else {
                rotationY-=curveLimit;
            }
        } else {
            rotationY+=dif;
        }
        // 移動
        radian = rotationY / 180 * Math.PI;
        z += Math.cos(radian)*nSpeed;
        x += Math.sin(radian)*nSpeed;
        */