/**
 * Copyright GreekFellows ( http://wonderfl.net/user/GreekFellows )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6EXC
 */

package {
    import flash.media.SoundMixer;
    import flash.utils.ByteArray;
    import flash.media.SoundLoaderContext;
    import flash.media.SoundChannel;
    import flash.media.Sound;
    import flash.events.MouseEvent;
    import flash.net.URLRequest;
    import flash.events.Event;
    import flash.text.TextFormat;
    import flash.text.TextField;
    import flash.display.Sprite;
    
    public class Pulse extends Sprite {
        private var instructions:Sprite;
        private var canvas:Sprite;
        
        private var url:URLRequest;
        private var sound:Sound;
        private var channel:SoundChannel;
        
        private var bytes:ByteArray;
        private var b:Number;
        private var max:Number;
        
        private var angle:Number;
        private var radius:Number;
        
        private var shapes:Array;
        
        public function Pulse() {
            stage.frameRate = 60;
            
            config();
            
            setupInstructions();
            showInstructions();
            fadeinInstructions();
            
            waitForButtonPress();
        }
        
        private function config():void {
            radius = 100;
        }
        
        private function setupInstructions():void {
            instructions = new Sprite();
            instructions.x = 465 / 2;
            instructions.y = 465 / 2;
            instructions.alpha = 0;
            
            this.addChild(instructions);
        }
        
        private function showInstructions():void {
            instructions.addChild(addTextField("Type in the URL of the music", 24, 0, -60));
            instructions.addChild(addTextField("HERE.", 24, 0, -20, true, 400));
            instructions.addChild(addButton("Then hit here.", 18, 0, 60));
        }
        
        private function fadeinInstructions():void {
            instructions.addEventListener(Event.ENTER_FRAME, fadein);
        }
        
        private function fadein(e:Event):void {
            if ((e.currentTarget.alpha += .1) >= 1) {
                if (e.currentTarget == canvas) {
                    prepareMusic();
                    startFunk();
                }
                e.currentTarget.removeEventListener(Event.ENTER_FRAME, fadein);
            }
        }
        
        private function waitForButtonPress():void {
            instructions.getChildAt(2).addEventListener(MouseEvent.CLICK, buttonPressed);
        }
        
        private function buttonPressed(me:MouseEvent):void {
            url = new URLRequest((instructions.getChildAt(1) as TextField).text);
            
            instructions.addEventListener(Event.ENTER_FRAME, fadeout);
        }
        
        private function fadeout(e:Event):void {
            if ((instructions.alpha -= .1) <= 0) {
                setupCanvas();
                fadeinCanvas();
                instructions.removeEventListener(Event.ENTER_FRAME, fadeout);
            }
        }
        
        private function prepareMusic():void {
            sound = new Sound(url, new SoundLoaderContext(0, true));
            channel = sound.play();
        }
        
        private function setupCanvas():void {
            canvas = new Sprite();
            canvas.x = 465 / 2;
            canvas.y = 465 / 2;
            canvas.graphics.beginFill(0, 1);
            canvas.graphics.drawRect(-465 / 2, -465 / 2, 465, 465);
            canvas.graphics.endFill();
            canvas.alpha = 0;
            this.addChild(canvas);
            
            shapes = [];
        }
        
        private function fadeinCanvas():void {
            canvas.addEventListener(Event.ENTER_FRAME, fadein);
        }
        
        // let's get this party started
        
        private function startFunk():void {
            this.addEventListener(Event.ENTER_FRAME, funk);
        }
        
        private function funk(e:Event):void {
            bytes = new ByteArray();
            SoundMixer.computeSpectrum(bytes, false);
            
            max = 0;
            b = 0;
            
            for (var ri:int = 0; ri < 256; ri++) {
                b = Math.abs(bytes.readFloat() * 10);
                if (b > max) {
                    max = b;
                }
            }
            
            for (var ait:int = 0; ait < max; ait++) {
                if (shapes.length < 50) {
                    if (mouseX < 465 / 2) {
                        shapes.push(new Circle(canvas, 0, 0, Math.random() * 150 - 75, Math.random() * 150 - 75, Math.ceil(Math.random() * max * 5)));
                    } else {
                        angle = Math.random() * 360;
                        shapes.push(new Circle(canvas, 0, 0, Math.cos(angle / 180 * Math.PI) * radius, Math.sin(angle / 180 * Math.PI) * radius, Math.ceil(Math.random() * max * 5)));
                    }
                }
            }
            
            canvas.graphics.clear();
            
            canvas.graphics.beginFill(0, 1);
            canvas.graphics.drawRect(-465 / 2, -465 / 2, 465, 465);
            canvas.graphics.endFill();
            
            for (var rei:int = 0; rei < shapes.length; rei++) {
                (shapes[rei] as Circle).render();
                if ((shapes[rei] as Circle).radius <= 0.1) {
                    shapes.splice(rei, 1);
                }
            }
        }
        
        private function addButton(text:String, size:Number, cx:Number, cy:Number):Sprite {
            var sprite:Sprite = new Sprite();
            
            sprite.x = cx;
            sprite.y = cy;
            
            sprite.addChild(addTextField(text, size, 0, 0, false, 0, 0xffffff));
            
            var w:Number = sprite.getChildAt(0).width - sprite.getChildAt(0).width % 20 + 20;
            var h:Number = sprite.getChildAt(0).height - sprite.getChildAt(0).height % 20 + 20;
            
            sprite.graphics.beginFill(0, 1);
            sprite.graphics.drawRect(-w / 2, -h / 2, w, h);
            
            return sprite;
        }
        
        private function addTextField(text:String, size:Number, cx:Number, cy:Number, input:Boolean = false, width:Number = 200, color:uint = 0):TextField {
            var tf:TextField = new TextField();
            if (input) {
                tf.type = "input";
            } else {
                tf.selectable = false;
            }

            
            var fmt:TextFormat = new TextFormat();
            fmt.color = color;
            fmt.font = "Segoe UI Light";
            fmt.size = size;
            fmt.align = "center";
            
            tf.text = text;
            tf.setTextFormat(fmt);
            
            if (input) {
                tf.width = width;
            } else {
                tf.width = tf.textWidth + 4;
            }
            tf.height = tf.textHeight + 4;
            tf.x = cx - tf.width / 2;
            tf.y = cy - tf.height / 2;
            
            return tf;
        }
    }
}
import flash.display.Sprite;

class Circle {
    public var base:Sprite;
    public var x:Number;
    public var y:Number;
    public var gx:Number;
    public var gy:Number;
    public var radius:Number;
    
    public function Circle(base:Sprite, x:Number, y:Number, gx:Number, gy:Number, radius:Number):void {
        this.base = base;
        this.x = x;
        this.y = y;
        this.gx = gx;
        this.gy = gy;
        this.radius = radius;
    }
    
    public function render():void {
        if (Math.abs(this.gx - this.x) < 2) {
            this.radius *= .75;
        } else {
            this.radius *= .9;
            this.x += (this.gx - this.x) / 5;
            this.y += (this.gy - this.y) / 5;
        }
        
        base.graphics.beginFill(0xffffff, 1);
        base.graphics.drawCircle(this.x, this.y, this.radius);
        base.graphics.endFill();
    }
}