/**
 * Copyright tkinjo ( http://wonderfl.net/user/tkinjo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6DnZ
 */

package
{
    import flash.display.*;
    import flash.events.*;
    import flash.geom.Point;
    
    [SWF(width="465", height="465", backgroundColor="0xffffff", frameRate="60")] 
    /**
     * Star Class
     * 
     * 星クラス
     * 
     * 使い方は createStar メソッドを参照
     * 
     * @author tkinjo
     */
    public class Main extends Sprite
    {
        private var stageWidth:Number = stage.stageWidth;
        private var stageHeight:Number = stage.stageHeight;
        private var stageCenter:Point = new Point( stageWidth / 2, stageHeight / 2 );
        
        /** --------------------------------------------------
         * component
         */
        private var configPanel:SlidePanel;
        private var numVertexInputTextAndHSlider:InputTextAndHSlider;
        private var outerRadiusInputTextAndHSlider:InputTextAndHSlider;
        private var innerRadiusInputTextAndHSlider:InputTextAndHSlider;
        
        private var canvas:Sprite;
        private var star:Star;
        
        public function Main() 
        {
            canvas = new Sprite();
            addChild( canvas );
            
            createComponent();
            
            createStar();
        }
        
        private function createStar():void {
            
            var starStroke:GraphicsStroke = new GraphicsStroke( 10 );
            starStroke.fill = new GraphicsSolidFill();
            
            star = new Star( numVertexInputTextAndHSlider.value, outerRadiusInputTextAndHSlider.value, innerRadiusInputTextAndHSlider.value, null, starStroke );
            star.x = stageCenter.x;
            star.y = stageCenter.y;
            
            canvas.addChild( star );
        }
        
        
        
        
        
        private function createComponent():void {
            
            configPanel = new SlidePanel( 0, 0, stageWidth, 0, 1, 0xffffff, 0.9 );
            addChild( configPanel );
            
            // numVertexInputTextAndHSlider
            numVertexInputTextAndHSlider = createInputTextAndHSlider( "numVertex" );
            numVertexInputTextAndHSlider.round = 0;
            numVertexInputTextAndHSlider.hSlider.minimum = 1;
            numVertexInputTextAndHSlider.hSlider.maximum = 32;
            numVertexInputTextAndHSlider.value = 5;
            numVertexInputTextAndHSlider.addEventListener(Event.CHANGE, function( event:Event ):void {
                    star.numVertex = numVertexInputTextAndHSlider.value;
                } );
            
            // outerRadiusInputTextAndHSlider
            outerRadiusInputTextAndHSlider = createInputTextAndHSlider( "outerRadius", numVertexInputTextAndHSlider );
            outerRadiusInputTextAndHSlider.round = 0;
            outerRadiusInputTextAndHSlider.hSlider.maximum = 300;
            outerRadiusInputTextAndHSlider.value = 200;
            outerRadiusInputTextAndHSlider.addEventListener(Event.CHANGE, function( event:Event ):void {
                    star.outerRadius = outerRadiusInputTextAndHSlider.value;
                } );
            
            // innerRadiusInputTextAndHSlider
            innerRadiusInputTextAndHSlider = createInputTextAndHSlider( "innerRadius", outerRadiusInputTextAndHSlider );
            innerRadiusInputTextAndHSlider.round = 0;
            innerRadiusInputTextAndHSlider.hSlider.maximum = 200;
            innerRadiusInputTextAndHSlider.value = 100;
            innerRadiusInputTextAndHSlider.addEventListener(Event.CHANGE, function( event:Event ):void {
                    star.innerRadius = innerRadiusInputTextAndHSlider.value;
                } );
            
            configPanel.height = innerRadiusInputTextAndHSlider.y + innerRadiusInputTextAndHSlider.height + 9;
        }
        
        private function createInputTextAndHSlider( text:String = "", component:DisplayObject = null ):InputTextAndHSlider {
            
            var inputTextAndHSlider:InputTextAndHSlider = new InputTextAndHSlider( configPanel, 10, ( component != null ) ? component.y + component.height + 10 : 10, text );
            inputTextAndHSlider.label.width     = 70;
            inputTextAndHSlider.inputText.width = 30;
            inputTextAndHSlider.hSlider.width   = 300;
            
            return inputTextAndHSlider;
        }
    }
}



import com.bit101.components.*;
import flash.display.*;
import flash.geom.*;
import flash.events.*;
import flash.text.*;
import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.easing.Cubic;

class Star extends Sprite {
    
    /**
     * 
     */
    public function get numVertex():uint { return _numVertex; }
    public function set numVertex(value:uint):void 
    {
        _numVertex = value;
        draw();
    }
    private var _numVertex:uint;
    
    
    /**
     * 
     */
    public function get outerRadius():Number { return _outerRadius; }
    public function set outerRadius(value:Number):void 
    {
        _outerRadius = value;
        draw();
    }
    private var _outerRadius:Number;
    
    
    
    /**
     * 
     */
    public function get innerRadius():Number { return _innerRadius; }
    public function set innerRadius(value:Number):void 
    {
        _innerRadius = value;
        draw();
    }
    private var _innerRadius:Number;
    
    
    
    /**
     * 
     */
    public function get fill():IGraphicsData { return _fill; }
    public function set fill(value:IGraphicsData):void 
    {
        _fill = value;
        draw();
    }
    private var _fill:IGraphicsData;
    
    
    
    /**
     * 
     */
    public function get stroke():IGraphicsData { return _stroke; }
    public function set stroke(value:IGraphicsData):void 
    {
        _stroke = value;
        draw();
    }
    private var _stroke:IGraphicsData;
    
    
    
    /**
     * 
     */
    public function Star( numVertex:uint, outerRadius:Number, innerRadius:Number, fill:IGraphicsData = null, stroke:IGraphicsData = null ):void {
        
        _numVertex   = numVertex;
        _outerRadius = outerRadius;
        _innerRadius = innerRadius;
        _fill        = fill;
        _stroke      = stroke;
        
        draw();
    }
    
    private function draw():void {
        
        graphics.clear();
        
        var drawGraphicsData:Vector.<IGraphicsData> = Vector.<IGraphicsData>([ fill, stroke ]);
        
        
        
        // path
        var exteriorAngle:Number = Math.PI * 2 / numVertex;
        
        var pathData:Vector.<Point> = new Vector.<Point>();
        
        for ( var i:uint = 0; i < numVertex; i++ ) {
            
            pathData.push( new Point( Math.sin( exteriorAngle * i - ( exteriorAngle / 2 ) ) * outerRadius, 0 + Math.cos( exteriorAngle * i - ( exteriorAngle / 2 ) ) * outerRadius ) );
            pathData.push( new Point( Math.sin( exteriorAngle * i ) * innerRadius, Math.cos( exteriorAngle * i ) * innerRadius ) );
        }
        
        var path:GraphicsPath = createGraphicsPathAtData( pathData );
        drawGraphicsData.push( path );
        
        
        
        // draw
        graphics.drawGraphicsData( drawGraphicsData );
    }
}



function createGraphicsPathAtData( pathData:Vector.<Point> ):GraphicsPath 
{
    var commands:Vector.<int> = new Vector.<int>();
    var data:Vector.<Number> = new Vector.<Number>();
    
    var pathDataLength:int = pathData.length; 
    
    for ( var i:uint = 0; i < pathDataLength; i++ ) {
        
        if( i != 0 )
            commands.push( GraphicsPathCommand.LINE_TO );
        else if( i == 0 )
            commands.push( GraphicsPathCommand.MOVE_TO );
        
        data.push( pathData[i].x, pathData[i].y );
    }
    
    commands.push( GraphicsPathCommand.LINE_TO );
    data.push( pathData[0].x, pathData[0].y );
    
    return new GraphicsPath( commands, data );
}







/* -----
 * component
 *//*
import com.bit101.components.*;
import flash.display.*;
import flash.events.*;
import flash.text.*;
import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.easing.Cubic;
//*/
class LabelEx extends Label {
    
    /**
     * Dispatched after a control value is modified, unlike the textInput event, which is dispatched before the value is modified.
     * @eventType flash.events.Event.CHANGE
     */
    [Event(name = "change", type = "flash.events.Event")] 
    
    /**
     * ...
     * @eventType com.bit101.components.Component.DRAW
     */
    [Event(name = "draw", type = "com.bit101.components.Component")] 
    
    
    
    private var textField:TextField;
    
    public function LabelEx(parent:DisplayObjectContainer = null, xpos:Number = 0, ypos:Number =  0, text:String = ""):void
    {
        super(parent, xpos, ypos, text);
    }
    
    /**
     * Initializes the component.
     */
    override protected function init():void
    {
        super.init();
        setSize(100, 16);
    }
    
    /**
     * Creates and adds the child display objects of this component.
     */
    override protected function addChildren():void
    {
        super.addChildren();
        
        for ( var i:uint = 0; i < numChildren; i++ ) {
            
            var child:DisplayObject = getChildAt( i );
            
            if ( child is TextField ) {
                
                textField = child as TextField;
                break;
            }
        }
    }
}

class InputTextEx extends InputText {
    
    /**
     * Dispatched after a control value is modified, unlike the textInput event, which is dispatched before the value is modified.
     * @eventType flash.events.Event.CHANGE
     */
    [Event(name = "change", type = "flash.events.Event")] 
    
    /**
     * ...
     * @eventType com.bit101.components.Component.DRAW
     */
    [Event(name = "draw", type = "com.bit101.components.Component")] 
    
    private var textField:TextField;
    
    public function InputTextEx(parent:DisplayObjectContainer = null, xpos:Number = 0, ypos:Number =  0, text:String = "", defaultHandler:Function = null)
    {
        super( parent, xpos, ypos, text, defaultHandler );
    }
    
    /**
     * Creates and adds child display objects.
     */
    override protected function addChildren():void
    {
        super.addChildren();
        
        for ( var i:uint = 0; i < numChildren; i++ ) {
            
            var child:DisplayObject = getChildAt( i );
            
            if ( child is TextField ) {
                
                textField = child as TextField;
                break;
            }
        }
        
        textField.autoSize = TextFieldAutoSize.LEFT;
    }
    
    protected override function onChange(event:Event):void
    {
        super.onChange( event );
        dispatchEvent( event );
    }
}

class HSliderEx extends HSlider {
    
    /**
     * Dispatched after a control value is modified, unlike the textInput event, which is dispatched before the value is modified.
     * @eventType flash.events.Event.CHANGE
     */
    [Event(name = "change", type = "flash.events.Event")] 
    
    /**
     * ...
     * @eventType com.bit101.components.Component.DRAW
     */
    [Event(name = "draw", type = "com.bit101.components.Component")] 
    
    public function HSliderEx(parent:DisplayObjectContainer = null, xpos:Number = 0, ypos:Number =  0, defaultHandler:Function = null):void
    {
        super(parent, xpos, ypos, defaultHandler);
    }
}

class InputTextAndHSlider extends Sprite {
    
    /**
     * Dispatched after a control value is modified, unlike the textInput event, which is dispatched before the value is modified.
     * @eventType flash.events.Event.CHANGE
     */
    [Event(name = "change", type = "flash.events.Event")]
    
    
    
    /**
     * label
     */
    public function get label():Label {
        
        return _label;
    }
    private var _label:Label;
    
    
    
    /**
     * inputText
     */
    public function get inputText():InputTextEx {
        
        return _inputText;
    }
    private var _inputText:InputTextEx;
    
    
    
    /**
     * hSlider
     */
    public function get hSlider():HSliderEx {
        
        return _hSlider;
    }
    private var _hSlider:HSliderEx;
    
    
    
    /**
     * round
     */
    public var round:int = 2;
    
    
    
    /**
     * value
     */
    public function get value():Number {
        
        return _value;
    }
    public function set value( tempValue:Number ):void {
        
        hSlider.value = tempValue;
        
        _value = Math.round( hSlider.value * Math.pow( 10, round ) ) / Math.pow( 10, round );
        
        if ( !isNaN( value ) )
            inputText.text = value.toString();
        
        dispatchEvent( new Event( Event.CHANGE ) );
    }
    private var _value:Number;
    
    
    
    /**
     * 
     * @param    parent
     * @param    xpos
     * @param    ypos
     * @param    text
     */
    public function InputTextAndHSlider(parent:DisplayObjectContainer=null, xpos:Number=0, ypos:Number=0, text:String = ""):void
    {
        parent.addChild( this );
        x = xpos;
        y = ypos;
        
        // label
        _label = new LabelEx( this, 0, 0, text );
        
        // inputText
        _inputText = new InputTextEx( this );
        inputText.restrict = "-0-9.";
        updateInputTextPosition( label );
        
        // hSlider
        _hSlider = new HSliderEx( this );
        hSlider.backClick = true;
        updateHSliderPosition( inputText );
        
        
        
        // hSlider eventlistener
        label.addEventListener(Component.DRAW, function( event:Event ):void {
                updateInputTextPosition( label );
            } );
        
        // inputText eventlistener
        inputText.addEventListener(Event.CHANGE, function( event:Event ):void {
                value = parseFloat( inputText.text );
            } );
        inputText.addEventListener(Component.DRAW, function( event:Event ):void {
                updateHSliderPosition( inputText );
            } );
        inputText.addEventListener(FocusEvent.FOCUS_OUT, function( event:FocusEvent ):void {
                if ( isNaN( value ) )
                    inputText.text = "0";
            } );
        
        // hSlider eventlistener
        hSlider.addEventListener(Event.CHANGE, function( event:Event ):void {
                value = hSlider.value;
            } );
    }
    
    
    
    /**
     * 
     * @param    component
     */
    private function updateInputTextPosition( component:DisplayObject ):void {
        
        inputText.y = component.y + ( component.height - inputText.height ) / 2;
        inputText.x = ( component.x + component.width ) + ( inputText.y - component.y );
    }
    
    
    
    /**
     * 
     * @param    component
     */
    private function updateHSliderPosition( component:Component ):void {
        
        hSlider.y = component.y + ( component.height - hSlider.height ) / 2;
        hSlider.x = ( component.x + component.width ) + ( hSlider.y - component.y );
    }
}



class ClearColorPanel extends Sprite {
    
    private var _backgroundColor:Number;
    public function get backgroundColor():Number { return _backgroundColor; }
    public function set backgroundColor(value:Number):void 
    {
        _backgroundColor = value;
        draw();
    }
    
    
    
    private var _backgroundAlpha:Number;
    public function get backgroundAlpha():Number { return _backgroundAlpha; }
    public function set backgroundAlpha(value:Number):void 
    {
        _backgroundAlpha = value;
        draw();
    }
    
    private var _width:Number;
    public override function get width():Number { return _width; }
    public override function set width(value:Number):void 
    {
        _width = value;
        draw();
    }
    
    private var _height:Number;
    public override function get height():Number { return _height; }
    public override function set height(value:Number):void 
    {
        _height = value;
        draw();
    }
    
    
    
    
    
    public function ClearColorPanel( x:Number = 0, y:Number = 0, width:Number = 0, height:Number = 0, alpha:Number = 1, backgroundColor:int = 0, backgroundAlpha:Number = 0.1 ) {
        
        this.x = x;
        this.y = y;
        _width = width;
        _height = height;
        this.alpha = alpha;
        _backgroundColor = backgroundColor;
        _backgroundAlpha = backgroundAlpha;
        
        draw();
    }
    
    public function draw():void {
        
        graphics.clear();
        graphics.beginFill( backgroundColor, backgroundAlpha );
        graphics.drawRect( 0, 0, width, height );
        graphics.endFill();
    }
}

class SlidePanel extends Sprite {
    
    private var panel:ClearColorPanel;
    private var openCloseSwitchButton:PushButton;
    private var open:Boolean;
    
    
    public override function set width(value:Number):void 
    {
        super.width = value;
        panel.width = value;
        openCloseSwitchButton.x = width - 20;
    }
    
    public override function set height(value:Number):void 
    {
        super.height = height;
        panel.height = value;
    }
    
    
    public function SlidePanel( x:Number = 0, y:Number = 0, width:Number = 0, height:Number = 0, alpha:Number = 1, backgroundColor:int = 0, backgroundAlpha:Number = 0.1 ) {
        
        this.x = x;
        this.y = y;
        
        panel = new ClearColorPanel( 0, 0, width, height, alpha, backgroundColor, backgroundAlpha );
        super.addChild( panel );
        
        openCloseSwitchButton = new PushButton(super, width - 20, 0);
        super.addChild( openCloseSwitchButton );
        openCloseSwitchButton.width = 20;
        openCloseSwitchButton.addEventListener(MouseEvent.CLICK, openCloseSwitchButtonClickHandler );
        
        openCloseSwitchButton.label = "-";
        open = true;
    }
    
    private function openCloseSwitchButtonClickHandler( event:MouseEvent ):void {
        
        // hide
        if ( open )
            show();
            
        // show
        else
            hide();
    }
    
    private function show():void {
        
        open = false;
        openCloseSwitchButton.label = "+";
        BetweenAS3.tween(panel, {y: -panel.height}, null, 0.5, Cubic.easeInOut ).play();
    }
    
    private function hide():void {
        
        open = true;
        openCloseSwitchButton.label = "-";
        BetweenAS3.tween(panel, { y: 0 }, null, 0.5, Cubic.easeInOut ).play();
    }
    
    
    override public function addChild(child:DisplayObject):DisplayObject 
    {
        return panel.addChild(child);
    }
    
    override public function addChildAt(child:DisplayObject, index:int):DisplayObject 
    {
        return panel.addChildAt(child, index);
    }
}