/**
 * Copyright gaina ( http://wonderfl.net/user/gaina )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6DHO
 */

package 
{
    import com.bit101.components.Slider;
    import com.bit101.components.Label;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.SampleDataEvent;
    import flash.media.Sound;
    import flash.media.SoundLoaderContext;
    import flash.net.URLLoader;
    import flash.net.URLRequest;
    import flash.utils.ByteArray;
    
    import net.hires.debug.Stats;
    
    /**
     * ...
     * @author nagai
     * sound by AlainMikuni 
     * すげー不完全燃焼
     * 難しいです・・・
     */
    
    [SWF(width="465",height="465")]
    public class Main extends Sprite 
    {
        private var sound:Sound;
        private var sound_mix:Sound;
        
        private var _slider:Slider;
        private var _v:Number = 2048;
        
        private var _label:Label;
        
        private var _right:Sprite;
        private var _left:Sprite;
        
        
        public function Main():void 
        {
            
            addChild(new Stats());
            
            var _url:String = "http://www.takasumi-nagai.com/soundfiles/sound004.mp3";
            _slider = new Slider("horizontal", stage, 350, 10, SliderEventHandler);
            _slider.maximum = 8192;
            _slider.minimum = 2048;
            
            _label = new Label(stage, 350, 10 + _slider.height, "");
            _label.text = String(_slider.value);
            
            PlaySound(_url);
            
            _left = new Sprite();
            _left.graphics.beginFill(0);
            _left.graphics.drawCircle(0, 0, 5);
            _left.graphics.endFill();
            _left.x = stage.stageWidth / 3;
            _left.y = stage.stageHeight / 2;
            addChild(_left);
            
            _right = new Sprite();
            _right.graphics.beginFill(0);
            _right.graphics.drawCircle(0, 0, 5);
            _right.graphics.endFill();
            _right.x = stage.stageWidth / 3 * 2;
            _right.y = stage.stageHeight / 2;
            addChild(_right);
        }
        
        private function SliderEventHandler(e:Event):void
        {
            _v = _slider.value;
            _label.text = String(_v);
        }
        
        private function PlaySound(url:String):void {
            var _context:SoundLoaderContext = new SoundLoaderContext(1000, true);
            sound_mix = new Sound();
            sound = new Sound();
            sound.load(new URLRequest(url), _context);
            sound.addEventListener(Event.COMPLETE, SoundLoadComplete);
        }
        
        private function SoundLoadComplete(e:Event):void 
        {
            sound_mix.addEventListener(SampleDataEvent.SAMPLE_DATA, SoundExtract);
            sound_mix.play();
        }
        
        private function SoundExtract(e:SampleDataEvent):void 
        {
            var _byte:ByteArray = new ByteArray();
            sound.extract(_byte, _v);
            
            e.data.writeBytes(_byte);
            Drawing(_byte);
        }
        
        private function Drawing(_byte:ByteArray):void
        {
            _byte.position = 0;
            
            var _l:Number = 0;
            var _r:Number = 0;
            
            for (var i:int; i < 16; i++)
            {
                _l += _byte.readFloat();
                _r += _byte.readFloat();
            }
            
            _left.scaleX = _left.scaleY = _l;
            _right.scaleX = _right.scaleY = _r;
            
        }
        
        
    }
    
}