/**
 * Copyright wh0 ( http://wonderfl.net/user/wh0 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6CuN
 */

package {
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.media.*;
    import flash.net.*;
    import flash.utils.*;
    public class FlashTest extends Sprite {
        
        private var src:Sound;
        private var bd:BitmapData;
        private var ba:ByteArray;
        
        public function FlashTest() {
            src = new Sound(new URLRequest('http://www.apmmusic.com/audio/DED/DED_DED_0132/DED_DED_0132_03801.mp3'));
            src.addEventListener(ProgressEvent.PROGRESS, progress);
            src.addEventListener(Event.COMPLETE, complete);
            bd = new BitmapData(256, 256, false, 0x000000);
            addChild(new Bitmap(bd));
        }
        
        private function progress(e:ProgressEvent):void {
            bd.lock();
            bd.fillRect(bd.rect, 0x000000);
            bd.fillRect(new Rectangle(0, 0, 256 * e.bytesLoaded / e.bytesTotal, 256), 0x808080);
            bd.unlock();
        }
        
        private function complete(e:Event):void {
            var dst:Sound = new Sound();
            dst.addEventListener(SampleDataEvent.SAMPLE_DATA, sample);
            dst.play();
            addEventListener(Event.ENTER_FRAME, frame);
            ba = new ByteArray();
            bd.fillRect(bd.rect, 0x000000);
        }
        
        private function sample(e:SampleDataEvent):void {
            src.extract(e.data, 8192);
        }
        
        private function frame(e:Event):void {
            SoundMixer.computeSpectrum(ba, true);
            ba.position = 0;
            bd.lock();
            bd.scroll(-1, 0);
            for (var i:int = 0; i < 256; i++) {
                bd.setPixel(255, 255 - i, uint(ba.readFloat() * 256) * 0x010101);
            }
            bd.unlock();
        }
        
    }
}