/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6BvB
 */

package {
  import flash.display.*;
  import flash.events.*;
  import flash.text.*;
  import flash.ui.*;
  import flash.utils.*;
  
  import net.user1.reactor.Attribute;
  import net.user1.reactor.IClient;
  import net.user1.reactor.Reactor;
  import net.user1.reactor.ReactorEvent;
  import net.user1.reactor.Room;
  import net.user1.reactor.RoomEvent;
  import net.user1.reactor.SynchronizationState; 

  public class UnionChatPart2 extends Sprite {
    // Union objects
    protected var reactor:Reactor;
    protected var chatRoom:Room;
    // User interface objects
    protected var t1:TextField;//チャット欄
    protected var t2:TextField;//入力ボックス
    protected var userlist:TextField;//ユーザーリスト
    protected var nameInput:TextField;//ユーザー名入力ボックス
    private var roomName:String = "chatRoom0001";
    

    // Constructor    
    public function UnionChatPart2 () {
      // Create the user interface
      init();
      // Make the Reactor object
      reactor = new Reactor();
      // Run readyListener() when the connection is ready
      reactor.addEventListener(ReactorEvent.READY, 
                               readyListener);
      // Connect to the server
      reactor.connect("tryunion.com", 80);
    }
    
    // Method invoked when the connection is ready
    protected function readyListener (e:ReactorEvent):void {
      t1.appendText("Connected to Union\n");
      chatRoom = reactor.getRoomManager().createRoom(roomName);
      chatRoom.addMessageListener("CHAT_MESSAGE", 
                                  chatMessageListener);
      chatRoom.addEventListener(RoomEvent.JOIN,
                                joinRoomListener);
      chatRoom.addEventListener(RoomEvent.ADD_OCCUPANT,
                                addClientListener);
      chatRoom.addEventListener(RoomEvent.REMOVE_OCCUPANT,
                                removeClientListener);
      chatRoom.addEventListener(RoomEvent.UPDATE_CLIENT_ATTRIBUTE,
                                updateClientAttributeListener);
      chatRoom.join();
    }
    
    // Create the user interface
    private function init():void {
      t1 = new TextField;
      with(t1){
          border = true;
          background = true;
          width = 300;
          height = 200;
      }
      t2 = new TextField();
      with(t2){
          type = TextFieldType.INPUT;
          border = true;
          background = true;
          width = 300;
          height = 20;
          y = 210;
          addEventListener(KeyboardEvent.KEY_UP, 
                                        outgoingKeyUpListener);
      }                               
      userlist = new TextField();
      userlist.border = true;
      userlist.background = true;
      userlist.width = 89;
      userlist.height = 200;
      userlist.x = 310;
      
      nameInput = new TextField();
      with(nameInput){
          type = TextFieldType.INPUT;
          border = true;
          background = true;
          width = 90;
          height = 20;
          y = 210;
          x = 310
          addEventListener(KeyboardEvent.KEY_UP, 
                                        nameKeyUpListener);
      }

                                        
   
      
      addChild(t1);
      addChild(t2);
      addChild(userlist);
      addChild(nameInput);
  
    }
    
    //発言送信
    protected function outgoingKeyUpListener (e:KeyboardEvent):void {
      if (e.keyCode == Keyboard.ENTER) {
        chatRoom.sendMessage("CHAT_MESSAGE", true, null, t2.text);
        t2.text = "";
      }
    }
    
    //名前変更
    // Keyboard listener for nameInput
    protected function nameKeyUpListener (e:KeyboardEvent):void {
      var self:IClient;
      if (e.keyCode == Keyboard.ENTER) {
        self = reactor.self();
        self.setAttribute("username", nameInput.text);
        //nameInput.text = "";
      }
    }
    
    //メッセージ受信
    // Method invoked when a chat message is received
    protected function chatMessageListener (fromClient:IClient, 
                                            messageText:String
                                            ):void {
      t1.appendText(getUserName(fromClient)
                                  + " : " 
                                  + messageText + "\n");
      t1.scrollV = t1.maxScrollV;
    }
    
    //ユーザーリスト更新イベント
    // Method invoked when the current client joins the room
    protected function joinRoomListener (e:RoomEvent):void {
      updateUserList();
    }
    
    
    //入室
    // Method invoked when a client joins the room
    protected function addClientListener (e:RoomEvent):void {
      var d:Date = new Date();
      if (e.getClient().isSelf()) {
        t1.appendText("You joined the chat. ["+ d.toLocaleTimeString() + "]\n");
        var self:IClient = reactor.self();
        nameInput.text = self.getAttribute("username");
      } else {
        if (chatRoom.getSyncState() != SynchronizationState.SYNCHRONIZING) {
   
          t1.appendText(getUserName(e.getClient())
                                      + " joined the chat. ["+ d.toLocaleTimeString() + "]\n");
        }
      }
      t1.scrollV = t1.maxScrollV;
      updateUserList();
    }
    
    //退室
    // Method invoked when a client leave the room
    protected function removeClientListener (e:RoomEvent):void {
      var d:Date = new Date();
      t1.appendText(getUserName(e.getClient())
                                  + " left the chat. ["+ d.toLocaleTimeString() + "]\n");
      t1.scrollV = t1.maxScrollV;
      updateUserList();
    }
    

    protected function updateClientAttributeListener (e:RoomEvent):void {
      var changedAttr:Attribute = e.getChangedAttr();
      if (changedAttr.name == "username") {
        if (changedAttr.oldValue == null) {
          t1.appendText("Guest" + e.getClientID());
        } else {
          t1.appendText(changedAttr.oldValue);
        }
        t1.appendText(" 's name changed to "
                                    + getUserName(e.getClient())
                                    + ".\n");
        t1.scrollV = t1.maxScrollV;
        updateUserList();
      }
    }
    
    //ユーザーリスト更新
    protected function updateUserList ():void {
      userlist.text = "";
      for each (var client:IClient in chatRoom.getOccupants()) {
        userlist.appendText(getUserName(client) + "\n");
      }
    }
    
    //ユーザー名取得
    protected function getUserName (client:IClient):String {
      var username:String = client.getAttribute("username");
        if (username == null) {
          return "Guest" + client.getClientID();
        } else {
          return username;
        }
    }
  }
}




import flash.display.*;
import flash.events.*;
import flash.text.*;
import flash.ui.*;
import flash.utils.*;
  
import net.user1.reactor.Attribute;
import net.user1.reactor.IClient;
import net.user1.reactor.Reactor;
import net.user1.reactor.ReactorEvent;
import net.user1.reactor.Room;
import net.user1.reactor.RoomEvent;
import net.user1.reactor.SynchronizationState; 

class UnionChat extends Sprite {
    // Union objects
    protected var reactor:Reactor;
    protected var chatRoom:Room;
    // User interface objects
    
    private var chatStr:String = "";
    private var userName:String;
    //protected var t1:TextField;//チャット欄
    //protected var t2:TextField;//入力ボックス
    protected var userlist:TextField;//ユーザーリスト
    protected var nameInput:TextField;//ユーザー名入力ボックス
    private var roomName:String = "chatRoom0001";
    

    // Constructor    
    public function UnionChat(_roomName:String="") {
        if(_roomName.length!=0)roomName = _roomName;
        init();
        reactor = new Reactor();
        reactor.addEventListener(ReactorEvent.READY,ready);
        reactor.connect("tryunion.com", 80);//union接続
    }
    
    // Method invoked when the connection is ready
    protected function ready(e:ReactorEvent):void {
      chatStr +="Connected to Union\n";
      chatRoom = reactor.getRoomManager().createRoom(roomName);
      chatRoom.addMessageListener("CHAT_MESSAGE", 
                                  chatMessageListener);
      chatRoom.addEventListener(RoomEvent.JOIN,
                                joinRoomListener);
      chatRoom.addEventListener(RoomEvent.ADD_OCCUPANT,
                                addClientListener);
      chatRoom.addEventListener(RoomEvent.REMOVE_OCCUPANT,
                                removeClientListener);
      chatRoom.addEventListener(RoomEvent.UPDATE_CLIENT_ATTRIBUTE,
                                updateClientAttributeListener);
      chatRoom.join();
    }
    
    // Create the user interface
    private function init():void {

      userlist = new TextField();
      userlist.border = true;
      userlist.background = true;
      userlist.width = 89;
      userlist.height = 200;
      userlist.x = 310;
      
      nameInput = new TextField();
      with(nameInput){
          type = TextFieldType.INPUT;
          border = true;
          background = true;
          width = 90;
          height = 20;
          y = 210;
          x = 310
          addEventListener(KeyboardEvent.KEY_UP, 
                                        nameKeyUpListener);
      }

      addChild(userlist);
      addChild(nameInput);
  
    }
    
    //発言送信
    protected function postComment(comment:String):void {
        chatRoom.sendMessage("CHAT_MESSAGE", true, null, comment);
    }
    
    //名前変更
    // Keyboard listener for nameInput
    protected function nameKeyUpListener (e:KeyboardEvent):void {
      var self:IClient;
      if (e.keyCode == Keyboard.ENTER) {
        self = reactor.self();
        self.setAttribute("username", nameInput.text);
        //nameInput.text = "";
      }
    }
    
    //メッセージ受信
    // Method invoked when a chat message is received
    protected function chatMessageListener (fromClient:IClient, 
                                            messageText:String
                                            ):void {
        chatStr += getUserName(fromClient) + " : " + messageText + "\n";
    }
    
    //ユーザーリスト更新イベント
    // Method invoked when the current client joins the room
    protected function joinRoomListener (e:RoomEvent):void {
      updateUserList();
    }
    
    
    //入室
    // Method invoked when a client joins the room
    protected function addClientListener (e:RoomEvent):void {
      var d:Date = new Date();
      if (e.getClient().isSelf()) {
        chatStr += "You joined the chat. ["+ d.toLocaleTimeString() + "]\n";
        var self:IClient = reactor.self();
        nameInput.text = self.getAttribute("username");
      } else {
        if (chatRoom.getSyncState() != SynchronizationState.SYNCHRONIZING) {
   
          chatStr += getUserName(e.getClient())
                                      + " joined the chat. ["+ d.toLocaleTimeString() + "]\n";
        }
      }
      updateUserList();
    }
    
    //退室
    // Method invoked when a client leave the room
    protected function removeClientListener (e:RoomEvent):void {
      var d:Date = new Date();
      chatStr += getUserName(e.getClient())
                                  + " left the chat. ["+ d.toLocaleTimeString() + "]\n";
      updateUserList();
    }
    

    protected function updateClientAttributeListener (e:RoomEvent):void {
      var changedAttr:Attribute = e.getChangedAttr();
      if (changedAttr.name == "username") {
        if (changedAttr.oldValue == null) {
          chatStr += "Guest" + e.getClientID();
        } else {
          chatStr += changedAttr.oldValue;
        }
        chatStr += " 's name changed to "
                                    + getUserName(e.getClient())
                                    + ".\n";
        updateUserList();
      }
    }
    
    //ユーザーリスト更新
    protected function updateUserList ():void {
      userlist.text = "";
      for each (var client:IClient in chatRoom.getOccupants()) {
        userlist.appendText(getUserName(client) + "\n");
      }
    }
    
    //ユーザー名取得
    protected function getUserName (client:IClient):String {
      var username:String = client.getAttribute("username");
        if (username == null) {
          return "Guest" + client.getClientID();
        } else {
          return username;
        }
    }
  }