/**
 * Copyright Scmiz ( http://wonderfl.net/user/Scmiz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6Bv8
 */

// forked from Scmiz's rainbow
package {
	import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.events.Event;
	import flash.events.MouseEvent;
    public class FlashTest extends Sprite {
        private var _frame:uint;
        private var _startX:Number;
        private var _startY:Number;
        private var _endX:Number;
        private var _endY:Number;
        private var _controlX:Number;
        private var _controlY:Number;

        private const MAX_FRAME:uint = 18;

        public function FlashTest() {
            reset();
            this.addEventListener(Event.ENTER_FRAME, proc);
        }

        private function proc(e:Event):void {
            if (_frame < MAX_FRAME) {
                ++_frame;
            }
            else {
                reset();
            }

            redraw();
        }

        private function reset():void {
            _frame = 0;

			var rnd:Function = function():Number { return Math.random() * 465; };
			_startX = rnd();
			_startY = rnd();
			_endX = rnd();
			_endY = rnd();
			_controlX = rnd();
			_controlY = rnd();
        }
		
		private function redraw():void {
			var g:Graphics = this.graphics;
			g.clear();
			
            var ratio:Number = Number(_frame) / MAX_FRAME;

			var startX:Number = _startX;
			var startY:Number = _startY;
			var endX:Number = (_endX * ratio) + (_startX * (1.0 - ratio));
			var endY:Number = (_endY * ratio) + (_startY * (1.0 - ratio));
			var controlX:Number = (_controlX * ratio) + (_startX * (1.0 - ratio));
			var controlY:Number = (_controlY * ratio) + (_startY * (1.0 - ratio));
			
			var thickness:Number = 4.0;
			
			var drawLine:Function = function(color:uint, offset:Number):void {
				g.lineStyle(thickness, color);
				g.moveTo(startX + offset, startY + offset);
				g.curveTo(controlX, controlY, endX + offset, endY + offset);
			};
			
			drawLine(0xff4040, thickness * 0);
			drawLine(0xffa040, thickness * 1);
			drawLine(0xffff40, thickness * 2);
			drawLine(0x40ff40, thickness * 3);
			drawLine(0x40ffff, thickness * 4);
			drawLine(0x40a0ff, thickness * 5);
			drawLine(0x4040ff, thickness * 6);
		}
    }
}