/**
 * Copyright clockmaker ( http://wonderfl.net/user/clockmaker )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6BiL
 */

// -----------------------------------------
// 特定の3Dオブジェクトにフォグを適用しない方法
// -----------------------------------------

// フォグはレンダラーのフィルタなので、
// フォグフィルタを適用するレンダラーと
// そうでないレンダラーの2種類を用意して適用する

// 結果、球体にはフォグは適用されず
// 地面にのみフォグを適用できる

// フォーラムの回答
// http://forum.papervision3d.jp/viewtopic.php?f=8&t=23

package
{
    import flash.display.*;
    import flash.events.*;
    
    import org.papervision3d.cameras.*;
    import org.papervision3d.core.render.filter.FogFilter;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.materials.special.FogMaterial;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.render.*;
    import org.papervision3d.scenes.*;
    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.view.stats.StatsView;

    [SWF(width=465, height=465, frameRate=60)]
    public class Main extends Sprite
    {
        public static const OBJ_MAX:int = 500; // オブジェクトの個数

        public function Main()
        {
               stage.quality = "low";
               
            camera = new Camera3D(60, 10, 2000, false, false);
            renderer = new BasicRenderEngine();
            rendererForFog = new BasicRenderEngine();
            scene = new Scene3D();
            sceneForFog = new Scene3D();
            viewport = new Viewport3D(465, 465);
            viewportForFog = new Viewport3D(465, 465);

            addChild(viewportForFog); //ビューポートを表示
            addChild(viewport); //ビューポートを表示
            addChild(new StatsView(renderer)); //スタッツ(FPSチェッカー)を表示

            // フォグマテリアルを作成　(白色の霧がかかるように設定)
            var fg:FogMaterial = new FogMaterial(0xFFFFFF);

            // フォグを適用(40段階で、最小距離2000、最大距離を6000とする)
            rendererForFog.filter = new FogFilter(fg, 50, 1500, 8000);

            // プリミティブオブジェクトのPlaneクラスで地面を作成
            var plane:Plane = new Plane(new ColorMaterial(0x000000), 10000, 10000, 20, 20);
            plane.rotationX = 90;
            sceneForFog.addChild(plane);

            // プリミティブオブジェクトのShpereクラスで球体を作成
            var sphere:Sphere = new Sphere(new ColorMaterial(0x003366), 500);
            scene.addChild(sphere);
            sphere.x = 1000;
            sphere.y = 500;

            // レンダリング
            addEventListener(Event.ENTER_FRAME, loop);
        }

        // 3Dのインスタンス
        private var camera:Camera3D; //カメラ 
        private var renderer:BasicRenderEngine // レンダラー
        private var rendererForFog:BasicRenderEngine // フォグ用のレンダラー
        private var scene:Scene3D // シーン
        private var sceneForFog:Scene3D // フォグ用のシーン
        private var viewport:Viewport3D // ビューポート
        private var viewportForFog:Viewport3D // ビューポート

        // エンターフレームイベント
        private function loop(e:Event):void
        {
            // マウスの位置に応じてカメラの位置が変わるように設定
            var rot:Number = mouseX / stage.stageWidth * 360;
            camera.x = 3000 * Math.sin(rot * Math.PI / 180);
            camera.z = 3000 * Math.cos(rot * Math.PI / 180);
            camera.y = mouseY / stage.stageHeight * 3000;

            camera.lookAt(DisplayObject3D.ZERO);

            // レンダリング
            renderer.renderScene(scene, camera, viewport);
            rendererForFog.renderScene(sceneForFog, camera, viewportForFog);
        }
    }
}