/**
 * Copyright 883108 ( http://wonderfl.net/user/883108 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6BfQ
 */

package{
	import flash.display.*;
	import flash.events.*;
	import flash.text.*;	
	
	public class MouseStalker2Document extends Sprite{
		private var _arrow:Arrow;
		private var _speed:Number = 5;
		public function MouseStalker2Document(){
			init();
		}
		
		private function init():void{
			var tex:TextField = new TextField  ;
			addChild(tex);
			tex.width = 450;
			tex.height = 400;
			tex.x = tex.y = 10;
			tex.multiline = true;
			tex.text = 'マウスの位置に矢印スプライトを向かせ、一定の速度で追随させます';
			// インスタンスを追加し、ENTER_FRAMEにハンドルを設定します。
			addChild(_arrow = new Arrow);
			stage.addEventListener(Event.ENTER_FRAME, enterFrameHandler);
		}
		
		private function enterFrameHandler($event:Event):void{
			// x,yの距離を求めます。
			var dx:Number = mouseX - _arrow.x;
			var dy:Number = mouseY - _arrow.y;
			// x,yともに距離が2ピクセル以内の場合は何もせず終了します。
			if(Math.abs(dx) < 2 && Math.abs(dy) < 2){
				return;
			}
			// Math.atan2を利用してスプライトとマウスの角度を求め、
			// スプライトをマウスの方向に向けた後、指定した距離分だけ近づけます。
			var angle:Number = Math.atan2(dy, dx);
			_arrow.rotation = angle * 180 / Math.PI;
			_arrow.x += Math.cos(angle) * _speed;
			_arrow.y += Math.sin(angle) * _speed;
		}
	}
}

import flash.display.Sprite;
class Arrow extends Sprite{
	function Arrow(){
		init();
	}
	
	private function init():void{
		graphics.beginFill(0xd90028);
		graphics.lineStyle(0);
		graphics.moveTo(20, 0);
		graphics.lineTo(0, 20);
		graphics.lineTo(0, 10);
		graphics.lineTo(-20, 10);
		graphics.lineTo(-20, -10);
		graphics.lineTo(0, -10);
		graphics.lineTo(0, -20);
		graphics.lineTo(20, 0);
		graphics.endFill();
	}
}
		