/**
 * Copyright Nao ( http://wonderfl.net/user/Nao )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6Ad9
 */

// forked from Nao's forked from: Particle Clock
// forked from demouth's Particle Clock
 /**
 * これを見て時計化したくなってしまった
 * http://level0.kayac.com/2009/08/loopclock.php
 */
// forked from demouth's 雑に一筆書き
// forked from egyu2's 一筆書き（鉛筆風）
package  
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.DisplayObject;
    import flash.display.PixelSnapping;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.ColorTransform;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.text.TextField;
    import flash.display.Sprite;
    
    public class Main extends Sprite
    {
        private var vs:Array = [];
        private var d:Drawer;
        private var offset:int = 20;
        private var fontSize:int = 30;
        private var drawScale:Number = 4;
        
        public function Main() 
        {
            if (stage) init()
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(event:Event = null):void
        {
            this.stage.align = StageAlign.TOP_LEFT;
            this.stage.scaleMode = StageScaleMode.NO_SCALE;
            
            //座標の計算
            for (var i:int = 0; i < 11; i++)
            {
                var t:TextField = new TextField();
                var write:String = (i == 10)? ":" : i.toString();
                t.htmlText = "<font size='"+this.fontSize.toString()+"'>" + write + "</font>";
                this.vs[i] = this.checkColor(t);
            }
            
            
            //描画処理の初期化
            for (var j:int = 0; j < 500; j++) 
            {
                var d:Drawer = new Drawer(this.createTimePointArray(), this.drawScale );
                d.ac = (Math.random() * 1) + 0.1;
                d.fr = (Math.random() * 0.6) + 0.05;
                d.zatsu = (Math.random() * 10) + 1;
                this.addChild(d);
                d.x = 10;
                d.y = 100;
                d.addEventListener(Event.COMPLETE , this.drawCompleteHandler);
                d.start();
            }
            
        }
        
        private function drawCompleteHandler(event:Event):void
        {
            event.target.v = this.createTimePointArray();
            event.target.ac = (Math.random() * 1) + 0.1;
            event.target.start();
        }
        
        /**
         * 現在時刻の座標の配列を返す。
         * @return
         */
        private function createTimePointArray():Vector.<Point>
        {
            var date:Date = new Date();
            var count:int = 0;
            var time:Number
            var v:Vector.<Point> = new Vector.<Point>();
            for (var i:int = 0; i < 2; i++) 
            {
                if (i == 0)
                {
                    time = date.hours;//時間を使用
                }
                else
                {
                    time = date.minutes;//分を使用
                    v = v.concat(this.shiftPoint(this.vs[10] as Vector.<Point> , count++ * this.offset , 0));//「：」を追加
                }
                if (time < 10)
                {
                    v = v.concat(this.shiftPoint(this.vs[0] as Vector.<Point> , count++ * this.offset , 0));
                    v = v.concat(this.shiftPoint(this.vs[time.toString().charAt(0)] as Vector.<Point> , count++ * this.offset , 0));
                }
                else
                {
                    v = v.concat(this.shiftPoint(this.vs[time.toString().charAt(0)] as Vector.<Point> , count++ * this.offset , 0));
                    v = v.concat(this.shiftPoint(this.vs[time.toString().charAt(1)] as Vector.<Point> , count++ * this.offset , 0));
                }
            }
            return v;
        }
        
        private function shiftPoint(v:Vector.<Point> , x:Number , y:Number):Vector.<Point>
        {
            var returnV:Vector.<Point> = new Vector.<Point>();
            for (var i:int = 0; i < v.length; i++) 
            {
                returnV.push(new Point(v[i].x + x , v[i].y + y));
            }
            return returnV;
        }
        
        /**
         * 描画するドットを決定
         */
        private function checkColor(displayObject:DisplayObject):Vector.<Point>
        {
            var bd:BitmapData = this.createBitmap(displayObject);
            var v:Vector.<Point> = new Vector.<Point>();
            var w:uint = bd.width;
            var h:uint = bd.height;
            var r:uint = 0;
            var g:uint = 0;
            var b:uint = 0;
            
            for (var i:int = 0; i < h; i++) 
            {
                for (var j:int = 0; j < w; j++) 
                {
                    var color:uint = bd.getPixel(j, i);
                    r = ( color >> 64 ) & 0xFF;
                    g = ( color >> 32 ) & 0xFF;
                    b = ( color ) & 0xFF;
                    if ( (r + g + b) < 64 )v.push(new Point(j, i));//閾値以下なら描画用の座標に格納
                }
            }
            v = this.sort(v);
            return v;
        }
        
        private function createBitmap(displayObject:DisplayObject):BitmapData
        {
            var bd:BitmapData = new BitmapData(displayObject.width , displayObject.height , false , 0xFFFFFF);
            bd.draw(displayObject);
            return bd;
        }
        
        private function sort(v:Vector.<Point>):Vector.<Point>
        {
            var length:int = v.length;
            var tmp:Vector.<Point> = new Vector.<Point>();
            var nowPoint:Point = new Point();
            for (var i:int = 0; i < length; i++) 
            {
                var num:int = this.check(nowPoint ,v);
                nowPoint = v[num];
                tmp.push(v.splice(num, 1)[0]);
            }
            return tmp;
        }
        
        private function check(p:Point ,v:Vector.<Point>):int
        {
            var near:uint;
            var nearDiff:int;
            var length:uint = v.length;
            
            var diffX:int = 0;
            var diffY:int = 0;
            var diff:int = 0;
            for (var i:int = 0; i < length; i++) 
            {
                diffX = v[i].x - p.x;
                diffY = v[i].y - p.y;
                diff = Math.sqrt((diffX * diffX) + (diffY * diffY));
                
                if (diff < nearDiff || (i == 0))
                {
                    nearDiff = diff;
                    near = i;
                }
            }
            return near;
        }
        
    }
    
}

import flash.display.Bitmap;
import flash.display.Sprite;
import flash.events.Event;
import flash.geom.Point;
class Drawer extends Sprite
{
    public var ac:Number = 0.3;
    public var fr:Number = 0.6;
    public var zatsu:Number = 10;//雑具合。高いと雑になる。
    public var v:Vector.<Point>;
    private var bitmap:Bitmap;
    private var brush:Point = new Point();
    private var w:Number;
    private var h:Number;
    private var num:int = 0;
    private var vX:Number = 0;
    private var vY:Number = 0;
    private var scale:Number = 1;
    
    public function Drawer(v:Vector.<Point> , scale:Number , bitmap:Bitmap = null) 
    {
        this.v = v;//座標
        this.scale = scale;//描画するサイズ
        this.bitmap = bitmap;
    }
    
    public function start():void
    {
        this.num = 0;
        var length:int = this.v.length;
        for (var i:int = 0; i < length; i++) 
        {
            this.v[i].x *= this.scale;
            this.v[i].y *= this.scale;
        }
        this.addEventListener(Event.ENTER_FRAME , enterFrameHandler);
    }
    
    private function draw():void
    {
        if (this.num < this.v.length) {
            this.graphics.clear();
            var p:Point = this.v[this.num];
            if (this.num == 0) this.brush.x = p.x;
            if (this.num == 0) this.brush.y = p.y;
            var oldP:Point = this.brush.clone();
            this.graphics.moveTo(this.brush.x , this.brush.y);
            this.vX += (p.x - this.brush.x) * this.ac;
            this.vY += (p.y - this.brush.y) * this.ac;
            this.vX *= this.fr;
            this.vY *= this.fr;
            this.brush.x += this.vX;
            this.brush.y += this.vY;
            var d:Number = int(Point.distance(oldP, this.brush) * 20);
            d = (d > 220)?220:d;
            this.graphics.lineStyle(0.1, d<<6|d<<12|d);
            this.graphics.lineTo(this.brush.x , this.brush.y);
            if(this.bitmap)this.bitmap.bitmapData.draw(this);
            var diffX:int = p.x - this.brush.x;
            var diffY:int = p.y - this.brush.y;
            var diff:Number = Math.sqrt((diffX * diffX) + (diffY * diffY));
            if(diff < this.zatsu)this.num++;
        } else {
            this.removeEventListener(Event.ENTER_FRAME , enterFrameHandler);
            this.dispatchEvent(new Event(Event.COMPLETE ));
        }
    }
    
    private function enterFrameHandler(event:Event):void
    {
        this.draw();
    }
    
}