/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6Ab9
 */

/*
TweenerをBetweenAS3に書き換える1

play()が必要なのと、
FromValuesとserial/parallelを設定できるのがポイント


■Parameters
Tweener Parameters are:
.addTween(target:Object, tweeningParameters:Object)

BetweenAS3 Parameters are:
.tween(Target, ToValues, FromValues, Time, Easing)


■参考
Tweenerの作例は↓ここより
http://www.tonpoo.com/tweener/methods/Tweener_addTween.html

BetweenAS3は↓ここを参考にしたけど、
http://www.be-interactive.org/?itemid=449
仕様変更されているので注意。
*/
package
{
	import flash.display.Sprite;
	import flash.text.TextField;
	import flash.events.MouseEvent;
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.tweens.ITween;
	import org.libspark.betweenas3.easing.*;
	import caurina.transitions.Tweener;
	
	public class Main extends Sprite
	{
		public function Main()
		{
			(addChild(new TextField()) as TextField).text = 'Click to start';
			stage.addEventListener(MouseEvent.MOUSE_UP, MOUSE_UP);
		}
		
		private function MOUSE_UP(e:MouseEvent):void
		{
			while (numChildren > 0) {
				removeChildAt(0);
			}
			
			// ◆ムービークリップを指定位置に0.5秒でスライドさせる
			var box1t:Box = addNewBox(400, 25, 0x00FF00);
			Tweener.addTween(box1t, {x:10, time:0.5});
			
			// ↓BetweenAS3化　tweenerのデフォルト値のイージングはExpo.easeOutにあたる
			var box1b:Box = addNewBox(400, 50, 0xFF0000);
			BetweenAS3.tween(box1b, {x:10}, null, 0.5, Expo.easeOut).play();
			
			
			
			// ◆ムービークリップを2秒でフェードイン
			var box2t:Box = addNewBox(300, 75, 0x00FF00);
			box2t.alpha = 0;
			Tweener.addTween(box2t, {alpha:1, time:2});
			
			// ↓BetweenAS3化
			var box2b:Box = addNewBox(300, 100, 0xFF0000);
			box2b.alpha = 0;
			BetweenAS3.tween(box2b, {alpha:1}, null, 2, Expo.easeOut).play();
			// ↓さらにBetweenAS3風に書き直すなら
			var box2b2:Box = addNewBox(300, 125, 0xFF0000);
			BetweenAS3.tween(box2b2, {alpha:1}, {alpha:0}, 2, Expo.easeOut).play();
			
			
			
			// ◆xとalphaの値を同時に変更
			var box3t:Box = addNewBox(200, 150, 0x00FF00);
			box3t.alpha = 0;
			Tweener.addTween(box3t, {x:10, alpha:1, time:0.5});
			
			// ↓BetweenAS3化
			var box3b:Box = addNewBox(200, 175, 0xFF0000);
			box3b.alpha = 0;
			BetweenAS3.tween(box3b, {x:10, alpha:1}, null, 0.5, Expo.easeOut).play();
			// ↓さらにBetweenAS3風に書き直すなら
			var box3b2:Box = addNewBox(200, 200, 0xFF0000);
			BetweenAS3.tween(box3b2, {x:10, alpha:1}, {alpha:0}, 0.5, Expo.easeOut).play();
			
			
			
			// ◆他のtransitionタイプを使ってtweening
			var box4t:Box = addNewBox(100, 250, 0x00FF00);
			Tweener.addTween(box4t, {y:200, time:0.7, transition:"linear"});
			
			// ↓BetweenAS3化
			var box4b:Box = addNewBox(200, 250, 0xFF0000);
			BetweenAS3.tween(box4b, {y:200}, null, 0.7, Linear.linear).play();
			// ↓Linear.linearはデフォルト値なので省略できる
			var box4b2:Box = addNewBox(300, 250, 0xFF0000);
			BetweenAS3.tween(box4b2, {y:200}, null, 0.7).play();
			
			
			
			// ◆アニメーションシークエンスを演出するために遅延を設定
			var box5t:Box = addNewBox(400, 350, 0x00FF00);
			Tweener.addTween(box5t, {x:20, time:0.5});
			Tweener.addTween(box5t, {x:0, time:0.5, delay: 0.5});
			
			// ↓BetweenAS3化
			var box5b:Box = addNewBox(400, 375, 0xFF0000);
			BetweenAS3.tween(box5b, {x:20}, null, 0.5, Expo.easeOut).play();
			BetweenAS3.delay(BetweenAS3.tween(box5b, {x:0}, {x:20}, 0.5, Expo.easeOut), 0.5).play();
			// ↓さらにBetweenAS3風に書き直すなら
			var box5b2:Box = addNewBox(400, 400, 0xFF0000);
			BetweenAS3.serial(
				BetweenAS3.tween(box5b2, {x:20}, null, 0.5, Expo.easeOut),
				BetweenAS3.tween(box5b2, {x:0}, null, 0.5, Expo.easeOut)
			).play();
			
		}
		
		private function addNewBox(x:Number, y:Number, c:int ):Box
		{
			var box:Box = new Box(c);
			box.x = x;
			box.y = y;
			addChild(box);
			return box;
		}
	}
}

import flash.display.Sprite;

internal class Box extends Sprite
{
	public function Box(c:int)
	{
		graphics.beginFill(c);
		graphics.drawRect(-10, -10, 20, 20);
		graphics.endFill();
	}
}