/**
 * Copyright Tamanegi_kenshi ( http://wonderfl.net/user/Tamanegi_kenshi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6Aa8
 */

//[メモ]
//papervision3Dのオブジェクトにマウスイベントを反応させるには～
//org.papervision3d.events.InteractiveScene3DEventをimportする
//viewPort3Dのinteractiveをtrueにする
//matrialのinteractiveをtrueにする
//オブジェクトにイベントを追加する
//addEventListener(InteractiveScene3DEvent.OBJECT_OVER, onOver)
//オブジェクト自身の動きはBooleanを使ってonEnter内に書いておく
//Tweenerなどを使うと楽にできるのかな？
//もっと正しいやり方があると思うけど…とりあえず動いたので(笑)

package {
    import flash.ui.ContextMenuBuiltInItems;
    import flash.display.Sprite;
    import flash.events.*;
    
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.materials.WireframeMaterial;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.events.InteractiveScene3DEvent;
    
    import caurina.transitions.Tweener;
    
    public class FlashTest extends Sprite {
        private var camera:Camera3D;
        private var scene:Scene3D;
        private var viewport:Viewport3D;
        private var renderer:BasicRenderEngine;
 
        private var cube:Cube;
        
        private var angleX:Number = 0;
        
        private var isRoll:Boolean = true;
        
        public function FlashTest() {
            init();            
        }//FlashTest
        
        private function init():void{
            camera = new Camera3D();
            camera.z =- 100;
              
            scene = new Scene3D();
            renderer = new BasicRenderEngine();
            viewport = new Viewport3D(465, 465);
            
            addChild(viewport);
            viewport.interactive=true;
            viewport.buttonMode=true;
           
            var material:WireframeMaterial = new WireframeMaterial(0x000000);
            var materials:MaterialsList = new MaterialsList({all:material});            
            material.interactive = true;
            
            cube = new Cube(materials, 10, 10, 10);
            scene.addChild(cube);
            
            cube.addEventListener(InteractiveScene3DEvent.OBJECT_OVER, onOver);
            cube.addEventListener(InteractiveScene3DEvent.OBJECT_OUT, onOut);        

           addEventListener(Event.ENTER_FRAME, onEnter);

        }//init
        
        private function onOver(event:InteractiveScene3DEvent):void{       
            isRoll = false;
        }//onOver
        
        private function onOut(event:InteractiveScene3DEvent):void{
           isRoll = true;
        }
        

//InteractiveScene3DEventをつかってから、オブジェクト自身をENTER_FRAMEしても動かなかった
//なので大元のonEnterにオブジェクトの動きを入れてみた
       
        private function onEnter(event:Event):void{
//カメラがオブジェクトの周りを回る
            angleX += (232 - mouseX) / 100;
            camera.x = Math.cos(angleX * Math.PI / 180) * 100;
            camera.z = Math.sin(angleX * Math.PI / 180) * 100;

//オブジェクトがカメラの方を向く
           var x1:Number = (0 - camera.x);
            var z1:Number = (0 - camera.z);
            var radian2:Number = Math.atan2(x1, z1);
            camera.rotationY = radian2 * 180 / Math.PI ;

//ロールアウト時のオブジェクトの動き          
          if(isRoll == false){
              cube.rotationX += 5;
              cube.rotationY += 5;
          }
          
          renderer.renderScene(scene, camera, viewport);
       }//onEnter
    }//class
}//package