/**
 * Copyright yuuganisakase ( http://wonderfl.net/user/yuuganisakase )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/69j8
 */

//
//かんとうか
//いろは道楽会　より
//http://www.ntt-i.net/IROHA/IROHA.html

//
//ladybird illustration from
//http://www.flickr.com/photos/etringita/271190790/
//


package
{
	import com.flashdynamix.motion.TweensyGroup;
	import com.flashdynamix.motion.effects.core.FilterEffect;
	import com.flashdynamix.motion.layers.BitmapLayer;
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.DisplayObject;
	import flash.display.GradientType;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.events.TimerEvent;
	import flash.filters.DropShadowFilter;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.net.URLRequest;
	import flash.system.LoaderContext;
	import flash.text.engine.*;
	import flash.utils.Timer;
	
	//0xe0d19D
	[SWF(width=465, height=465, frameRate=15, backgroundColor=0xffffff)]
	public class Iroha extends Sprite
	{
		private var tween:TweensyGroup = new TweensyGroup(true);
		private var layer:BitmapLayer = new BitmapLayer(Util.WID, Util.HEI);
		
		private var timer:Timer = new Timer(150);
		
		private var bitmap:Bitmap;
		private var tentouKanjiSprite:Sprite = new Sprite();
		private var tentouKanaSprite:Sprite = new Sprite();
		private var holder:Sprite = new Sprite();
		private var kanaArray:Array = new Array();
		private var kanaTemp:Array = new Array();
		
		
		private var fd:FontDescription = new FontDescription();
		private var ef:ElementFormat = new ElementFormat();
		private var te:TextElement;
		private var tb:TextBlock = new TextBlock();
		
		
		private var state:int = 1;
		private var repeatFlag:Boolean = false;
		
		private var tentouKanji:String = "てんとう虫はまあるいな\n" +
			"よろけ立ち頬を見つめ\n" +
			"声もせぬ、霧に触れ\n" +
			"草の裾へ寝ゆ陽柔らか\n" + 
			" ";
		
		private var tentouKana:String = "てんとうむしは まあるいな\n" +
			"よろけたち ほおをみつめ\n" +
			"こえもせぬ きりにふれ\n" +
			"くさのすそへねゆ ひやわらか\n"+
			" ";
		private var tentou:Array = ["てんとうむしは まあるいな\n",
			"よろけたち ほおをみつめ\n" ,
			"こえもせぬ きりにふれ\n" ,
			"くさのすそへねゆ ひやわらか"];
		
		private var irohaStr:Array = ["いろはにほへと ちりぬるを",
			"わかよたれそ つねならむ",
			"うゐのおくやま けふこえて",
			"あさきゆめみし ゑひもせす　ん"];	
		
		private var aiueo:Array = ["あいうえお\n",
			"かきくけこ\n",
			"さしすせそ\n",
			"たちつてと\n",
			"なにぬねの\n",
			"はひふへほ\n",
			"まみむめも\n",
			"や　ゆ　よ\n",
			"らりるれろ\n",
			"わゐ　ゑをん\n",
		];
		
		
		public function Iroha()
		{
			super();
			
			timer.addEventListener(TimerEvent.TIMER, onTimer);
			tween.smartRotate = false;
			
			if(stage){
				stage.addEventListener(MouseEvent.CLICK, onClick);
				stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
			}
			addChild(layer);
			layer.draw(holder);
			
			holder.addChild(tentouKanjiSprite);
			var mat:Matrix = new Matrix();
			mat.createGradientBox(Util.WID, Util.HEI,1.4);
			this.graphics.beginGradientFill(GradientType.LINEAR,[0xf0e1bD,0xeeddaa] ,[1,1],[170, 255],mat);
			this.graphics.drawRect(0,0,Util.WID, Util.HEI);
			layer.add(new FilterEffect(new DropShadowFilter(2,45,0,0.9,4,4,0.5) ));
			
			holder.addChild(tentouKanaSprite);
			makeTentouKanjiText(tentouKanji);	
			layer.clearOnRender = true;
			
			var loader :Loader = new Loader();
			loader.load(
				new URLRequest('http://assets.wonderfl.net/images/related_images/a/a1/a1f0/a1f0b6cac0aa762c949c7f9b636391c866f46706'),
				new LoaderContext(true));
			
			loader.contentLoaderInfo.addEventListener( Event.COMPLETE, function(e :Event) :void {            
				var bd :BitmapData = new BitmapData(300,300,true,0x00ffffff);
				bitmap = new Bitmap( bd );
				bd.draw( loader );
				addChildAt(bitmap,0);
				bitmap.alpha = 0;
				
			});
			
			
			if(Util.testFlag){
				testGoTo3();
			}
			
			/*var myFonts:Array = Font.enumerateFonts(true);
			for (var i:int = 0; i < myFonts.length; i++) {
			if (myFonts[i].fontType == "device") {
			trace("I am a device font and my name is", myFonts[i].fontName);
			}
			}*/
		}
		private function onTimer(e:TimerEvent):void
		{
			if(state == 2 && kanaTemp.length != 0)
			{
				var ind:int = Math.random() * kanaTemp.length >> 0;
				var tar:Kana = kanaTemp[ind];
				var pos:Point = searchPosition(tar.content, irohaStr);
				var newPos:Point = new Point(Util.firstPositionX-30-pos.x*Util.lineSpace, pos.y*25 + 70);
				
				kanaTemp.splice(ind,1);
				if(kanaTemp.length == 0)
				{
					createIE();
				}
				tar.irohaMove(newPos,tween);
			}
			
		}
		private function onMouseMove(e:MouseEvent):void
		{
			var po:Point = new Point(e.stageX, e.stageY);
			for(var i:int = 0; i < holder.numChildren; i++)
			{
				var tar:DisplayObject = holder.getChildAt(i);
				if( tar.hitTestPoint(po.x, po.y))
				{
					tar.dispatchEvent(e);
				}
			}
		}
		
		
		private function testGoTo3():void
		{
			makeTentouKanaText(tentouKana);
			removeKanji();
			testIrohaMove();
		}
		private function testIrohaMove():void
		{
			for each(var kana:Kana in kanaArray)
			{
				var pos:Point = searchPosition(kana.content, irohaStr);
				var newPos:Point = new Point(Util.firstPositionX-30-pos.x*Util.lineSpace, pos.y*25 + 50);
				kana.x = newPos.x;
				kana.y = newPos.y;
			}
			createIE();
		}
		private function onEnter(e:Event):void
		{
			
		}
		
		private function createIE():void
		{
			var ii:Kana = new Kana("ゐ",fd,tween);
			var ee:Kana = new Kana("ゑ",fd,tween);
			var ar:Array = [ii, ee];
			for each(var kana:Kana in ar)
			{
				
				var pos:Point = searchPosition(kana.content, irohaStr);
				var newPos:Point = new Point(Util.firstPositionX-30-pos.x*Util.lineSpace, pos.y*25 + 70);
				holder.addChild(kana);
				kanaArray.push(kana);
				if(Util.testFlag){
					tween.fromTo(kana,{x:10,y:-80, scaleX:"3,5", scaleY:"3,5", rotation:180},{x:newPos.x, y:newPos.y, rotation:0},1,null, 0.5,null,goToState3);
				}else{
					tween.fromTo(kana,{x:10,y:-80, scaleX:"3,5", scaleY:"3,5", rotation:180},{x:newPos.x, y:newPos.y, rotation:0},2.5,null, 3,null,goToState3);
				}
			}
		}
		private function goToState3():void
		{
			state = 3;
			timer.stop();
			var flag:Boolean = true;
			for each(var kana:Kana in kanaArray)
			{
				var pos:Point = searchPosition(kana.content, aiueo);
				var newPos:Point = new Point(Util.WID-25-pos.x*Util.lineSpace/1.3, (pos.y*2)*28 + 100);
				if(flag)
				{
					flag = false;
					kana.addEventListener("aiueoEnd",goToState4,false,0,true);
				}
				kana.aiueoMove(newPos, tween);
			}
		}
		private function goToState4(e:Event):void
		{
			state = 4;
			for each(var kana:Kana in kanaArray)
			{
				if(kana.content == "ゐ"){
					kana.addEventListener("turnEnd", onTurnEnd, false,0,true);
				}
				var pos:Point = searchPosition(kana.content, tentou);
				var newPos:Point = new Point(Util.firstPositionX - pos.x*Util.lineSpace, pos.y*25 + 70);
				kana.tentouMove(newPos, tween);
			}
		}
		private function onTurnEnd(e:Event):void
		{
			trace("on turn end");
			state = 1;
			if(bitmap != null){
				tween.to(bitmap, {alpha:0.9},2,null,0);
				bitmap.x = 70;
				bitmap.y = 300;
				bitmap.scaleX = bitmap.scaleY = 0.4;
			}
			repeatFlag = true;
		}
		
		private function searchPosition(str:String, target:Array):Point
		{
			for(var i:int = 0; i < target.length; i++)
			{
				var ind:int = (target[i] as String).indexOf(str);
				if(ind != -1)
				{
					var po:Point = new Point(i,ind);
					return po;
				}
			}
			return new Point(-2,-2);
		}
		private function onClick(e:MouseEvent):void
		{
			if(state == 1) goToState2();
		}
		private function goToState2():void
		{
			
				
			
			
			
			if(repeatFlag == true)
			{
				if(bitmap != null){
					tween.to(bitmap, {alpha:0},1, null,0,null,removeKanji);
				}
			}else{
				makeTentouKanaText(tentouKana);
				holder.addChild(tentouKanaSprite);
				tween.fromTo(tentouKanaSprite,{alpha:0},{alpha:1},1);
				tween.to(tentouKanjiSprite, {alpha:0.0},1,null,0,null,removeKanji);
			}
			for(var i:int = 0; i < kanaArray.length; i++)
			{
				kanaTemp.push(kanaArray[i]);
			}
			state = 2;
			timer.start();
			
		}
		private function removeKanji():void
		{
			if(holder.contains(tentouKanjiSprite))
			{
				holder.removeChild(tentouKanjiSprite);
				
			}
			
		}
		private function makeTentouKanjiText(str:String):void
		{
			fd.fontName = "みかちゃん,小塚ゴシック Pro M,HG教科書体";
			
			ef.fontDescription = fd;
			ef.color = 0x322D1A;;
			ef.fontSize = 24;
			ef.locale = "ja";
			var track:int = 2;
			ef.trackingLeft = track;
			ef.trackingRight = track;
			
			te = new TextElement(str,ef);
			
			tb.content = te;
			tb.textJustifier = new EastAsianJustifier("ja", LineJustification.UNJUSTIFIED);
			tb.baselineZero = TextBaseline.IDEOGRAPHIC_CENTER;
			tb.lineRotation = TextRotation.ROTATE_90;
			
			var previousLine:TextLine = null;
			var textLine:TextLine;
			var linePosition:Number = Util.WID-130;
			
			tentouKanjiSprite.filters 
			while(true)
			{
				textLine = tb.createTextLine(previousLine, 450);
				if(textLine == null)
				{
					break;
				}
				textLine.y = 55;
				textLine.x = linePosition;
				
				linePosition -= Util.lineSpace;
				tentouKanjiSprite.addChild(textLine);
				previousLine = textLine;
			}
		}
		private function makeTentouKanaText(str:String):void
		{
			var xx:int = Util.firstPositionX;
			var yy:int = Util.firstPositionY;
			for(var i:int = 0; i < str.length; i++)
			{
				
				var char:String = str.charAt(i);
				if(char == "\n"){
					xx -= Util.lineSpace;
					yy = Util.firstPositionY;
				}else{
					
					var kana:Kana = new Kana(char,fd,tween);
					kana.x = xx;
					kana.y = yy;
					
					holder.addChild(kana);
					kanaArray.push(kana);
					yy += 25;
				}
			}
			for(var i:int = 0; i < kanaArray.length; i++)
			{
				kanaTemp.push(kanaArray[i]);
			}
		}
	}
}
import com.flashdynamix.motion.TweensyGroup;
import com.flashdynamix.motion.TweensyTimeline;

import fl.motion.easing.Bounce;
import fl.motion.easing.Elastic;
import fl.motion.easing.Exponential;
import fl.motion.easing.Sine;

import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.filters.DropShadowFilter;
import flash.geom.Point;
import flash.text.engine.EastAsianJustifier;
import flash.text.engine.ElementFormat;
import flash.text.engine.FontDescription;
import flash.text.engine.LineJustification;
import flash.text.engine.TextBaseline;
import flash.text.engine.TextBlock;
import flash.text.engine.TextElement;
import flash.text.engine.TextLine;
import flash.text.engine.TextRotation;

class Kana extends Sprite
{
	private var fd:FontDescription = new FontDescription();
	private var ef:ElementFormat = new ElementFormat();
	private var te:TextElement;
	private var tb:TextBlock = new TextBlock();
	private var tl:TextLine;
	public var content:String;
	private var ringFlag:Boolean= false;
	private var tween:TweensyGroup;
	private var currentTween:TweensyTimeline = new TweensyTimeline();
	private var factorX:Number;
	private var factorY:Number;
	
	
	public function Kana(str:String,_fd:FontDescription,_tween:TweensyGroup)
	{
		super();
		content = str;
		tween = _tween;
		fd.fontName = "みかちゃん,小塚ゴシック Pro M,HG教科書体";
		
		ef.fontDescription = fd;
		ef.color = 0x322D1A;
		ef.alpha = 0.95;
		ef.fontSize = 24;
		ef.locale = "ja";
		var track:int = 3;
		ef.trackingLeft = track;
		ef.trackingRight = track;
		
		te = new TextElement(str,ef);
		
		tb.content = te;
		tb.textJustifier = new EastAsianJustifier("ja",LineJustification.UNJUSTIFIED);
		tb.lineRotation = TextRotation.ROTATE_90;
		tb.baselineZero = TextBaseline.IDEOGRAPHIC_CENTER;
		tl = tb.createTextLine(null,60);
		
		this.addChild(tl);
		this.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
		//tl.x = -tl.width/2;
		tl.y = -tl.height/2;
		
		var shadow:DropShadowFilter = new DropShadowFilter(1,45,0,0.9,4,4);
		//tl.filters = [shadow];
	}
	private function onMouseMove(e:MouseEvent):void
	{
		if(ringFlag == false){
			ring(1);
		}		
	}
	public function ring(power:Number = 1):void
	{
		ringFlag = true;
		var rad:Number = 90*power;
		if(Math.random()>0.5) rad *= -1;
		var ran2:Number = 1 + (Math.random()-0.5)*2;
		var ran3:Number = 1 + (Math.random()-0.5)*2;
		if(currentTween.playing){
			//currentTween.pause();
		}
		
		//this.z = 0;
		tween.fromTo(this.tl,{x:"-10,10", y:"-10,10"}, {},1.5,Elastic.easeOut,0,null);
		//tween.fromTo(this,{rotationX:rad, rotationY:rad, rotationZ:rad}, {rotationX:0,rotationY:0,rotationZ:0},2,Elastic.easeOut,0,null,endRing);
		tween.fromTo(this,{rotation:rad, scaleX:ran2, scaleY:ran3}, {rotation:0, scaleX:1, scaleY:1},2,Elastic.easeOut,0,null,endRing);
		
	}
	private function endRing():void
	{
		
		ringFlag = false;
		//if(currentTween.paused)		currentTween.resume();
	}
	public function tentouMove(po:Point, tween:TweensyGroup):void
	{
		if( this.content == "ゐ")
		{
			this.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
			
			currentTween = tween.to(this,{x:700, y:150, scaleX:9, scaleY:9, rotation:360}, 4,null,9,null,erase);
			
		}else if(this.content == "ゑ")
		{
			this.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
			currentTween = tween.to(this,{x:100, y:-220, scaleX:9, scaleY:9, rotation:360}, 4,null,9,null,erase);
		}else{
			currentTween = tween.to(this,{x:po.x, y:po.y}, 3,null,5.5);
		}	
	}
	private function erase():void
	{
		trace("erase");
		dispatchEvent(new Event("turnEnd") );
		this.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
		tween.to(this,{alpha:0}, 0.5);		
	}
	public function irohaMove(po:Point,tween:TweensyGroup):void
	{
		currentTween = tween.to(this,{x:po.x, y:po.y},3,null,2.5);
	}
	public function aiueoMove(po:Point, tween:TweensyGroup):void
	{		
		var random:int = 3.5;
		var ran:int = 2;//Math.random()*3 << 0;
		var ease:Function;
		if(ran == 0){
			ease = Sine.easeInOut
		}else if(ran == 1){
			ease = Exponential.easeOut;
		}else{
			ease = Elastic.easeInOut;
		}
		var dur:Number= 8;
		currentTween = tween.to(this,{x:po.x, y:po.y},dur, ease, random,null, aiueoEnd);
	}
	public function aiueoEnd():void
	{
		dispatchEvent(new Event("aiueoEnd") );
	}
}


class Util
{
	public static const WID:int = 465;
	public static const HEI:int = 465;
	public static const cNum:int = 40;
	public static const speed:Number = 6;
	public static const lineSpace:int = 60;
	public static const firstPositionX:int = Util.WID - 130;
	public static const firstPositionY:int = 70;
	public static const testFlag:Boolean = false;
}