/**
 * Copyright tonsmart5 ( http://wonderfl.net/user/tonsmart5 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/69da
 */

// forked from suitoki's forked from: Alternativa3D Tips 平面プリミティブの頂点にアクセスして、変形する2
package {
    import flash.media.Camera;
    import alternativ5.engine3d.materials.FillMaterial;
    import alternativ5.engine3d.primitives.Plane;
    import alternativ5.engine3d.controllers.WalkController
    import alternativ5.engine3d.controllers.ObjectController

    import alternativ5.utils.KeyboardUtils
    import alternativ5.engine3d.physics.*
    import alternativ5.types.Point3D;
    import alternativ5.types.Set;

    import flash.display.Sprite;
    import flash.events.KeyboardEvent;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.text.*;
    import flash.utils.*;
    import org.papervision3d.cameras.Camera3D;


    [SWF(width = 465, height = 465, frameRate = 60)]
    /**
     * Alternativa3D を簡単に扱うためのベーシックテンプレート
     * @author Yasu (clockmaker)
     */
    public class SimpleDemo extends Sprite {

        public function SimpleDemo():void {
            // テンプレートを作成します
            var template:BasicTemplate = new BasicTemplate();
            addChild(template);

            //視点を俯瞰に設定
            template.camera.coords=new Point3D(500,-2000,1000);

            //床を作る
            var plane:Plane=new Plane(10000,10000,50,50);
            template.scene.root.addChild(plane)
            plane.cloneMaterialToAllSurfaces(new FillMaterial(0x666666,0.5,BlendMode.NORMAL,1,0x0000000));

            //簡単な車を作成する
            var car:Car= new Car();
            // 3Dシーンのルートに追加します
            template.scene.root.addChild(car)

            //Controllerのインスタンスを作る
            var walkController:WalkController=new WalkController(this.stage,car)

            //キーボードのキー(Keyboard.KEY)でメソッドを実行する
            walkController.mouseEnabled=false
            
            this.stage.addEventListener(KeyboardEvent.KEY_DOWN,onKeyDown)
            this.stage.addEventListener(KeyboardEvent.KEY_UP,onKeyUp)

            var moveFlag:Boolean=false

            function onKeyDown(e:KeyboardEvent) {
                switch(e.keyCode) {
                    case KeyboardUtils.W:
                    case KeyboardUtils.UP:
                        moveFlag=true
                        walkController.moveForward(true)
                        break;
                    case KeyboardUtils.Z:
                    case KeyboardUtils.DOWN:
                        moveFlag=true
                        walkController.moveBack(true)
                        break;
                    case KeyboardUtils.A:
                    case KeyboardUtils.LEFT:
                        if (moveFlag) {
                            walkController.yawLeft(true)
                        }
                        break;
                    case KeyboardUtils.D:
                    case KeyboardUtils.RIGHT:
                        if (moveFlag) {
                            walkController.yawRight(true)
                        }
                        break;
                    case KeyboardUtils.SHIFT:
                        walkController.accelerate(true)
                        break;
                }


            }

            function onKeyUp(e:KeyboardEvent) {
                switch(e.keyCode) {
                    case KeyboardUtils.W:
                    case KeyboardUtils.UP:
                        moveFlag=false
                        walkController.moveForward(false)
                        break;
                    case KeyboardUtils.Z:
                    case KeyboardUtils.DOWN:
                        moveFlag=false
                        walkController.moveBack(false)
                        break;
                    case KeyboardUtils.A:
                    case KeyboardUtils.LEFT:
                        walkController.yawLeft(false)
                        break;
                    case KeyboardUtils.D:
                    case KeyboardUtils.RIGHT:
                        walkController.yawRight(false)
                        break;
                    case KeyboardUtils.SHIFT:
                        walkController.accelerate(false)
                        break;
                }
            }


    




            //移動スピードを設定する
            walkController.speed = 700;

            //初期位置を設定する
            walkController.coords=new Point3D(0,0,25);

            // Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
            // レンダリング前に実行したい処理を記述します。
            template.cameraContoller.lookAt(new Point3D());
            template.onPreRender = function():void {
                walkController.processInput()
            }
        }


    }
}





import alternativ5.engine3d.materials.FillMaterial;
import alternativ5.engine3d.primitives.Box;
import alternativ5.engine3d.primitives.Cone;
import alternativ5.engine3d.primitives.Plane;
import alternativ5.engine3d.core.Object3D;
import alternativ5.types.Point3D;
import alternativ5.types.Set;

import flash.display.BlendMode;


class Car extends Object3D{

    public function Car() {
            var body:Box=new Box(100,200,50,1,3,1);
            body.cloneMaterialToAllSurfaces(new FillMaterial(0x990000,1,BlendMode.NORMAL,-1,0x0000000));
            body.setMaterialToSurface(new FillMaterial(0xCC0000),'top');
            body.setMaterialToSurface(new FillMaterial(0x660000),'front');
            body.setMaterialToSurface(new FillMaterial(0x660000),'back');
            body.vertices['0_2_0'].coords=new Point3D(-50, 50, -25)
            body.vertices['0_2_1'].coords=new Point3D(-50, 50,    25)
            body.vertices['1_2_1'].coords=new Point3D( 50, 50,    25)
            body.vertices['1_2_0'].coords=new Point3D( 50, 50, -25)
            body.vertices['1_1_0'].coords=new Point3D( 50,-70, -25)
            body.vertices['1_1_1'].coords=new Point3D( 50,-70,    25)
            body.vertices['0_1_1'].coords=new Point3D(-50,-70,    25)
            body.vertices['0_1_0'].coords=new Point3D(-50,-70, -25)
            body.vertices['0_3_0'].coords=new Point3D(-50,100, -25)
            body.vertices['0_3_1'].coords=new Point3D(-50,100,    15)
            body.vertices['1_3_1'].coords=new Point3D( 50,100,    15)
            body.vertices['1_3_0'].coords=new Point3D( 50,100, -25)
            body.vertices['0_0_0'].coords=new Point3D(-50,-100,-25)
            body.vertices['1_0_1'].coords=new Point3D( 50,-100, 25)
            body.vertices['0_0_1'].coords=new Point3D(-50,-100, 25)
            body.vertices['1_0_0'].coords=new Point3D( 50,-100,-25)

            var window:Box=new Box(100,100,50,1,1,1);
            window.cloneMaterialToAllSurfaces(new FillMaterial(0x0099FF));
            window.setMaterialToSurface(new FillMaterial(0xCC0000),'top');
            window.vertices['0_1_0'].coords=new Point3D(-50,    50,-25)
            window.vertices['1_1_0'].coords=new Point3D( 50,    50,-25)
            window.vertices['1_0_0'].coords=new Point3D( 50, -70,-25)
            window.vertices['0_0_0'].coords=new Point3D(-50, -70,-25)

            window.vertices['0_1_1'].coords=new Point3D(-40,    20, 25)
            window.vertices['1_1_1'].coords=new Point3D( 40,    20, 25)
            window.vertices['1_0_1'].coords=new Point3D( 40, -50, 25)
            window.vertices['0_0_1'].coords=new Point3D(-40, -50, 25)

            var tire1:Cone=new Cone(20,20,20,1,12);
            var tire2:Cone=new Cone(20,20,20,1,12);
            var tire3:Cone=new Cone(20,20,20,1,12);
            var tire4:Cone=new Cone(20,20,20,1,12);
            tire1.cloneMaterialToAllSurfaces(new FillMaterial(0x333333,1,BlendMode.NORMAL,-1,0x0000000));
            tire2.cloneMaterialToAllSurfaces(new FillMaterial(0x333333,1,BlendMode.NORMAL,-1,0x0000000));
            tire3.cloneMaterialToAllSurfaces(new FillMaterial(0x333333,1,BlendMode.NORMAL,-1,0x0000000));
            tire4.cloneMaterialToAllSurfaces(new FillMaterial(0x333333,1,BlendMode.NORMAL,-1,0x0000000));

            //trace(body.vertices)

            window.z=50
            tire1.coords=new Point3D(-41,-60,-15)
            tire2.coords=new Point3D(-41, 60,-15)
            tire3.coords=new Point3D( 41,-60,-15)
            tire4.coords=new Point3D( 41, 60,-15)

            tire1.rotationY= 90 * Math.PI / 180;
            tire2.rotationY= 90 * Math.PI / 180;
            tire3.rotationY= 90 * Math.PI / 180;
            tire4.rotationY= 90 * Math.PI / 180;

            addChild(window)
            addChild(body)
            addChild(tire1)
            addChild(tire2)
            addChild(tire3)
            addChild(tire4)

    }
}



/**
 * BasicTemplate for Alternativa3D
 * Alternativa3Dを扱いやすくするためのテンプレートです
 * @author Yasu
 */
import alternativ5.engine3d.controllers.CameraController;
import alternativ5.engine3d.core.Camera3D;
import alternativ5.engine3d.core.Object3D;
import alternativ5.engine3d.core.Scene3D;
import alternativ5.engine3d.display.View;
import flash.display.Sprite;
import flash.display.StageAlign;
import flash.display.StageQuality;
import flash.display.StageScaleMode;
import flash.events.Event;
internal class BasicTemplate extends Sprite{
    /**
     * シーンインスタンスです。
     */
    public var scene:Scene3D;
    /**
     * ビューインスタンスです。
     */
    public var view:View;
    /**
     * カメラインスタンスです。
     */
    public var camera:Camera3D;
    /**
     * カメラコントローラーです。
     */
    public var cameraContoller:CameraController;
    
    private var _viewWidth:int;
    private var _viewHeight:int;
    private var _scaleToStage:Boolean;

    /**
     * 新しい BasicTemplate インスタンスを作成します。
     * @param    viewWidth
     * @param    viewHeight
     * @param    scaleToStage
     */
    public function BasicTemplate(viewWidth:int=640, viewHeight:int=480, scaleToStage:Boolean = true) {
        _viewWidth = viewWidth;
        _viewHeight = viewHeight;
        _scaleToStage = scaleToStage;
        
        // Creating scene
        scene = new Scene3D();
        scene.splitAnalysis = false; // not analysis for performance
        scene.root = new Object3D();
        
        // Adding camera
        camera = new Camera3D();
        camera.z = -1000;
        scene.root.addChild(camera);
        
        // camera contoller
        cameraContoller = new CameraController(this);
        cameraContoller.camera = camera;
        
        // set view
        view = new View();
        view.camera = camera;
        addChild(view);
        
        // stage
        if (stage) init();
        else addEventListener(Event.ADDED_TO_STAGE, init);
    }
    
    /**
     * 初期化されたときに実行されるイベントです。
     * 初期化時に実行したい処理をオーバーライドして記述します。
     */
    protected function atInit():void {}
    
    /**
     * 初期化されたときに実行されるイベントです。
     * 初期化時に実行したい処理を記述します。
     */
    private var _onInit:Function = function():void { };
    public function get onInit():Function { return _onInit; }
    public function set onInit(value:Function):void {
        _onInit = value;
    }
    
    /**
     * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
     * レンダリング前に実行したい処理をオーバーライドして記述します。
     */
    protected function atPreRender():void {}
    
    /**
     * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
     * レンダリング前に実行したい処理を記述します。
     */
    private var _onPreRender:Function = function():void{};
    public function get onPreRender():Function { return _onPreRender; }
    public function set onPreRender(value:Function):void {
        _onPreRender = value;
    }
    
    /**
     * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
     * レンダリング後に実行したい処理をオーバーライドして記述します。
     */
    protected function atPostRender():void {
    }
    
    /**
     * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
     * レンダリング後に実行したい処理を記述します。
     */
    protected var _onPostRender:Function = function():void{};
    public function get onPostRender():Function { return _onPostRender; }
    public function set onPostRender(value:Function):void {
        _onPostRender = value;
    }
    
    /**
     * レンダリングを開始します。
     */
    public function startRendering():void {
        addEventListener(Event.ENTER_FRAME, onRenderTick);
    }
    /**
     * レンダリングを停止します。
     */
    public function stopRendering():void {
        removeEventListener(Event.ENTER_FRAME, onRenderTick);
    }
    
    /**
     * シングルレンダリング(レンダリングを一回だけ)を実行します。
     */
    public function singleRender():void {
        onRenderTick();
    }
    
    /**
     * @private
     */
    private function init(e:Event = null):void {
        stage.scaleMode = StageScaleMode.NO_SCALE;
        stage.align = StageAlign.TOP_LEFT;
        stage.quality = StageQuality.HIGH;

        // resize
        stage.addEventListener(Event.RESIZE, onResize);
        onResize(null);
        
        // render
        startRendering();
        
        atInit();
        _onInit();
        
    }
    
    /**
     * @private
     */
    private function onRenderTick(e:Event = null):void {
        atPreRender();
        _onPreRender();
        scene.calculate();
        atPostRender();
        _onPostRender();
    }
    
    /**
     * @private
     */
    private function onResize(event:Event = null):void {
        if (_scaleToStage) {
            view.width = stage.stageWidth;
            view.height = stage.stageHeight;
        }else {
            view.width = _viewWidth;
            view.height = _viewHeight;
        }
    }
}
