/**
 * Copyright madflash ( http://wonderfl.net/user/madflash )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/69GE
 */

/*
    future:
        ColorVisualizer
        img -> size copy -> optimize -> output
        
    課題点：カラースコアを生成するためにベクタを24bitカラー分を初期化してから使うか、
    　　　　あるいは見つけた色からarrayに格納していくほうがいいかの検討。
    
    実装：ピクセルを単純ソート後の書き出し(並び替え)
    　　　ピクセルをパーセンテージでの書き出し(しきい値)
*/

package {
    import flash.display.BitmapData;
    import flash.utils.ByteArray;
    import flash.geom.Rectangle;
    import flash.system.LoaderContext;
    import flash.net.URLRequest;
    import flash.events.Event;
    import flash.display.Loader;
    import flash.display.Bitmap;
    import flash.display.Sprite;
    
    [SWF(width="465", height="465", backgroundColor="0xFFFFFF", frameRate="30")]
    public class ColorVisualizer extends Sprite
    {
        private var _img:*;
        private var _imgurl:String = "http://assets.wonderfl.net/images/related_images/7/70/70fa/70fabc621d0012772be8855fad093c0f6eb6aebam"; //url from wonderfl uploader
        private var _score:Vector.<uint>; //note: sort -> top down sort
        
        public function ColorVisualizer()
        {
            //Wonderfl.capture_delay(1);
         
            _init();
        }
        
        private function _init():void
        {
            _score = new Vector.<uint>();
            
            var loader:Loader = new Loader;
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, function(e:Event):void
                {
                _trigger(e);
                
                this.removeEventListener(Event.COMPLETE, arguments.callee);
                }
            );
            //get material status
            loader.load(new URLRequest(_imgurl), new LoaderContext(true)); //for crossdomain
            _img = loader;
            
                        
            // score initialize for vector
            for(var i:uint=0; i<=255; i++)
            {
                _score[i] = 0;
            }
        }
        
        private function _trigger(e:Event):void
        {
            addChild(_img);           
        }
        
        private function toColorScore(bmd:BitmapData, rect:Rectangle = null):void
        {
             
            if (!rect) rect = new Rectangle(0, 0, bmd.width, bmd.height);
            var pixels:ByteArray = bmd.getPixels(rect);
        }
        
        
        //ソートの実装(AS3標準ソートは遅い)

        /*
        private static function rgbToNum():uint
        {
            return 0;
        }
        */

    }
}