/**
 * Copyright miyaoka ( http://wonderfl.net/user/miyaoka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/69AV
 */

package  
{
	import flash.display.Graphics;
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	import flash.events.Event;
	
	[SWF(width="465", height="465", backgroundColor= 0xffffff, frameRate="60")]
	public class Lesson03
	extends Sprite
	{
		public function Lesson03() 
		{
			//イベントと関数を結びつける--------------------------------

			//マウスをクリックでmouseDownHandlerという関数を呼ぶ			
			stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
		}
		private function mouseDownHandler(e:MouseEvent):void 
		{
			//--------------------------------------------
			//ballというオブジェクトを生成して、マウス位置に配置する
			
			//生成
			var ball:Ball = new Ball();
			
			//マウス位置に移動
			ball.x = mouseX;
			ball.y = mouseY;
			
			//ballに毎フレームballEnterFrameHandlerという関数を登録する
			ball.addEventListener(Event.ENTER_FRAME, ballEnterFrameHandler);
			
			//オブジェクトを配置して表示させる
			addChild(ball);
		}
		private function ballEnterFrameHandler(e:Event):void 
		{
			//この関数を呼び出したオブジェクトを取り出す
			var ball:Ball = e.target as Ball;
			
			//y座標に1足して落下させる
			ball.y += 1;
			
			//一定以上下まで行ったら
			if (ball.y > 400)
			{
				//毎フレームのイベントを外す
				ball.removeEventListener(Event.ENTER_FRAME, ballEnterFrameHandler);
				
				//表示から外す
				removeChild(ball);
				
				//消去する
				ball = null;
			}
		}
		
	}
}


import flash.display.Graphics;
import flash.display.Sprite;
class Ball
extends Sprite
{
	public function Ball():void 
	{
		//--------------------------------------------
		//中心点に円を描く

		var g:Graphics = graphics;
		
		//ランダムな色を作る
		var color:uint = Math.random() * 0xFFFFFF;
		
		g.beginFill(color, 1.0);
		g.drawCircle(0, 0, 20);	
	}
}