/**
 * Copyright aobyrne ( http://wonderfl.net/user/aobyrne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/68gd
 */

// forked from Kay's [QuickBox2D] Soft Object #1
// forked from mash's QuickBox2D sample
package {
    import flash.display.*;
    import com.actionsnippet.qbox.*;
    import flash.geom.*;
    import flash.events.*;

    public class FlashTest extends MovieClip {
            public var circles:Array = new Array();
        public var radius:Number = 0.2;
        public var circleNum:int = 62;
        public var nColor:int = 0x66ccff;
        public function FlashTest() {
            // write as3 code here..
 
            stage.frameRate = 60;
 
            var sim:QuickBox2D = new QuickBox2D(this, { gravityX:0, gravityY:10,debug:true });
            sim.createStageWalls();
            var center:Point = new Point(5,5);
            var nRadius:Number = 4;
            var centerCircle:QuickObject = sim.addCircle({x:center.x, y:center.y, radius:3, restitution:0.2, lineAlpha:0, fillAlpha:0 });
            for (var i:int = 0; i < circleNum; i++) {
                    var nR:Number = Math.PI*2/circleNum*i;
                var circle:QuickObject = sim.addCircle({
                    x:center.x+nRadius*Math.cos(nR), 
                    y:center.y+nRadius*Math.sin(nR), 
                    radius:radius, 
                    lineAlpha:0, 
                    fillAlpha:0,
                    fixedRotation:true});
                circles.push(circle);
                if (i > 0) {
                    sim.addJoint({a:circles[i-1].body, b:circle.body, frequencyHz:0, restitution:0.2});
                }
            }
            sim.addJoint({a:circles[circleNum-1].body, b:circles[0].body, length:radius*2, frequencyHz:0});
            
            sim.start();
            sim.mouseDrag();
            
            addEventListener(Event.ENTER_FRAME, xFake);                       
        }
        private function xFake(e:Event):void {
                graphics.clear();
                graphics.lineStyle(10,nColor);
                graphics.beginFill(nColor);
                var sPos:Point = new Point();
                for (var i:int = 0; i < circleNum; i++) {
                    var circle:QuickObject = circles[i];
                    if (i == 0) {
                        sPos = new Point(circle.x*30, circle.y*30);
                        graphics.moveTo(sPos.x, sPos.y);
                    } else {
                        graphics.lineTo(circle.x*30,circle.y*30);
                    }
                }
                graphics.lineTo(sPos.x, sPos.y);
                graphics.endFill();
        } 
    }
}
