/**
 * Copyright IPFix ( http://wonderfl.net/user/IPFix )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/67z4
 */

package {
    import alternativ7.engine3d.core.Camera3D;
    import alternativ7.engine3d.containers.BSPContainer;
    import alternativ7.engine3d.core.Object3DContainer;
    import alternativ7.engine3d.core.View;
    import alternativ7.engine3d.materials.FillMaterial;
    import alternativ7.engine3d.primitives.Box;
    import alternativ7.engine3d.controllers.SimpleObjectController;
    import alternativ7.engine3d.core.Sorting;
    
    import gs.TweenLite;
    
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.MouseEvent;
    import flash.events.Event;
    
    import flash.filters.DropShadowFilter;
    
    [SWF(backgroundColor="#DDDDDD", width="465", height="465", frameRate="60")]
    public class Castle extends Sprite {
        
        private var rootContainer:Object3DContainer;
        private var castle:Object3DContainer;
        private var camera:Camera3D;
        private var controller:SimpleObjectController 
        
   
        public function Castle() {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            rootContainer = new BSPContainer();
            
            camera = new Camera3D();
            camera.view = new View(stage.stageWidth, stage.stageHeight);
            addChild(camera.view);
            addChild(camera.diagram);
            
            camera.rotationX = -120*Math.PI/180;
            camera.y = -1000;
            camera.z = 700;
            rootContainer.addChild(camera);
            
            castle = makeCastle();
            rootContainer.addChild(castle);
            
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onMove);
            stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(e:Event):void {
            camera.render();
        }

        
        private function onMove(e:MouseEvent):void {
            TweenLite.to(camera, 1, {z:600+(e.stageY/stage.stageHeight)*300});
            TweenLite.to( castle, 1, {rotationZ : (e.stageX/stage.stageWidth)*Math.PI});
            
        }
        
        private function makeCastle():Object3DContainer
        {
            var castle:BSPContainer = new BSPContainer();
            
            for(var i:int=-1; i<2;i++)
                for(var j:int=-1; j<2; j++){
                    if(i == 0 || j==0)
                        continue;
                    var tower:Object3DContainer = makeTower();
                    tower.x = i*400;
                    tower.y = j*400;
                    castle.addChild(tower);
                }
            
            for(i=-1; i<2;i++)
                for( j=-1; j<2; j++){
                    if(i != 0 && j!=0)
                        continue;
                    if(i == 0 && j==0)
                        continue;
                    var wall:Box = shadowBox(800,60,120,1,1,1);
                    wall.x = i*400;
                    wall.y = j*400;
                    wall.z = -95;
                    if(j == 0)
                        wall.rotationZ = Math.PI/2;
                    castle.addChild(wall);
                    
                }
    
            return castle;
        }
        
        private function shadowBox(width:Number = 100, length:Number = 100, height:Number = 100, widthSegments:uint = 1, lengthSegments:uint = 1, heightSegments:uint = 1):Box{
            var box:Box = new Box(width, length, height, widthSegments, lengthSegments,heightSegments,false,false, new FillMaterial(0x999999),
                                   new FillMaterial(0x777777),
                                   new FillMaterial(0x888888),
                                   new FillMaterial(0x666666),
                                   new FillMaterial(0x555555),
                                   new FillMaterial(0xAAAAAA)
                                   );
            box.sorting = Sorting.DYNAMIC_BSP;
            return box;
        }
        
        
        private function makeTower():Object3DContainer
        {
            var tower:BSPContainer = new BSPContainer();  
            
            var base:Box = shadowBox(140,140,300,1,1,1);
            
            var plateform:Box = shadowBox(200,200,50,1,1,1);            
            plateform.x = 0;
            plateform.y = 0;
            plateform.z = 175;
            
            //love lines :p
            for(var i:int=-1; i<2;i++)
                for(var j:int=-1; j<2; j++){
                    if(i == 0 && j==0)
                        continue;
                    var creneau:Box = shadowBox(40,40,40,1,1,1);
                    creneau.x = i*80;
                    creneau.y = j*80;
                    creneau.z = 220;
                    tower.addChild(creneau);
                }

            
            var door:Box = shadowBox(50,10,70);
            door.y = -76;
            door.z = -115;
            
            tower.addChild( base );
            tower.addChild( door );
            tower.addChild( plateform );
                        
            return tower;
        }


    }
}

