/**
 * Copyright yurij.shaulov ( http://wonderfl.net/user/yurij.shaulov )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/67y7
 */

package{

    import flash.display.*;

    import flash.events.*;

    import flash.text.*;    

    

    public class Main extends Sprite {

        public var _pcos:Number;

        public var _psin:Number;

        public var _endX:Number;

        public var _endY:Number;

        public var _bullets:Array = new Array();



        private var _arrow:Arrow;

        private var _speed:Number = 5;

        public function Main(){

            init();

        }

        

        private function init():void{

            addChild(_arrow = new Arrow);

            stage.addEventListener(Event.ENTER_FRAME, enterFrameHandler);

        }

        

        private function enterFrameHandler($event:Event):void{

            var dx:Number = mouseX - _arrow.x;

            var dy:Number = mouseY - _arrow.y;

            if(Math.abs(dx) < 2 && Math.abs(dy) < 2){

                return;

            }

            var angle:Number = Math.atan2(dy, dx);

            _arrow.rotation = angle * 180 / Math.PI;

            _arrow.x += Math.cos(angle) * _speed;

            _arrow.y += Math.sin(angle) * _speed;

            createBullet();

            updateBullets();

        }

        private function createBullet():void

        {

            var tempBullet:MovieClip = new Bullet();

             _pcos = Math.cos(_arrow.rotation * Math.PI / 180);

             _psin = Math.sin(_arrow.rotation * Math.PI / 180);

            var  _startX:Number = _arrow.x - 20 * _pcos;

            var  _startY:Number = _arrow.y - 20 * _psin;

            


             _endX = _arrow.x - 50 * _pcos + Math.random() * 20 - 20 * .5;

             _endY = _arrow.y - 50 * _psin + Math.random() * 20 - 20 * .5;

             

             

            

            tempBullet.vx = (_endX - _startX) / 2;

            tempBullet.vy = (_endY - _startY) / 2;

            

  
            tempBullet.x = _startX;

            tempBullet.y = _startY;

            

 
            tempBullet.startX = _startX;

            tempBullet.startY = _startY;

            

 
            _bullets.push(tempBullet);

            

       
            stage.addChild(tempBullet);

        }

        private function updateBullets():void

        {

            var i:int;

            var tempBullet:MovieClip;


            for (i = 0; i < _bullets.length; i++)

            {

                // save a reference to current bullet

                tempBullet = _bullets[i];

                

                // update bullet position

                tempBullet.x += tempBullet.vx;

                tempBullet.y += tempBullet.vy;

                

           
            }

        }

    }

}



import flash.display.Sprite;

class Arrow extends Sprite{

    function Arrow(){

        init();

    }

    

    private function init():void{

        graphics.beginFill(0xd90028);

        graphics.lineStyle(0);

        graphics.moveTo(20, 0);

        graphics.lineTo(0, 20);

        graphics.lineTo(0, 10);

        graphics.lineTo(-20, 10);

        graphics.lineTo(-20, -10);

        graphics.lineTo(0, -10);

        graphics.lineTo(0, -20);

        graphics.lineTo(20, 0);

        graphics.endFill();

    }

}



import flash.display.MovieClip

class Bullet extends MovieClip {

    public var maxDistance:Number;

    public var startX:Number;

    public var startY:Number;

            public var vx:Number;

        public var vy:Number;

    function Bullet(){

        init();

    }

    

    private function init():void{

        graphics.beginFill(0x00000c);

        graphics.drawCircle(0, 0, Math.random()*5);

        graphics.endFill();

    }

}

        