/**
 * Copyright codeonwort ( http://wonderfl.net/user/codeonwort )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/669k
 */

package {
    
    import flash.display.Sprite
    import flash.display.MovieClip
    import flash.events.Event
    import flash.events.MouseEvent
    
    [SWF(width=400, height=400, backgroundColor=0x000000)]
    
    // 화면을 누르면 분대처럼 정렬해서 누른 지점으로 이동한다
    // 화면을 더블 클릭하면 흩어진다
    // 유닛이 일정 속도로 움직여야겠으나 귀찮아서 대충 만들기 쉬운 걸로 했다
    public class FlashTest extends Sprite {
        
        private var unitContainer:Sprite
        
        public function FlashTest() {
            makeUnits(162) // 유닛 개수
            setMouseAction()
        }
        
        private function makeUnits(num:uint):void {
            unitContainer = addChild(new Sprite()) as Sprite
            var unit:MovieClip
            for(var i:int=0 ; i<num ; i++){
                unit = new MovieClip()
                unit.graphics.beginFill(0xff0000, 1)
                unit.graphics.drawCircle(0, 0, 5)
                unit.graphics.endFill()
                unit.x = unit.destX = Math.random() * stage.stageWidth
                unit.y = unit.destY = Math.random() * stage.stageHeight
                unitContainer.addChild(unit)
            }
            unitContainer.addEventListener("enterFrame", moveUnit)
        }
        
        private function setMouseAction():void {
            stage.addEventListener("mouseDown", setDestination)
            function setDestination(e:MouseEvent):void {  everybodyMove(e.stageX, e.stageY) }
            
            stage.doubleClickEnabled = true
            stage.addEventListener("doubleClick", scatterUnits)
            function scatterUnits(e:Event):void {
                var unit:MovieClip
                for(var i:int=0 ; i<unitContainer.numChildren ; i++){
                    unit = unitContainer.getChildAt(i) as MovieClip
                    unit.destX = Math.random() * stage.stageWidth
                    unit.destY = Math.random() * stage.stageHeight
                }
            }
        }
        
        private function moveUnit(e:Event):void {
            var unit:MovieClip
            for(var i:int=0 ; i<unitContainer.numChildren ; i++){
                unit = unitContainer.getChildAt(i) as MovieClip
                unit.x += 0.1 * (unit.destX - unit.x)
                unit.y += 0.1 * (unit.destY - unit.y)
            }
        }
        
        // 정렬 방식을 바꾸려면 이 함수를 수정한다
        private function everybodyMove(destX:Number, destY:Number):void {
            var numColumns:int = Math.sqrt(unitContainer.numChildren)
            var numRows:int = unitContainer.numChildren / numColumns
            var numMods:int = unitContainer.numChildren - numColumns*numRows
            var spaceX:Number = 10
            var spaceY:Number = 10
            var LT_x:Number = destX - numRows*spaceX/2
            var LT_y:Number = destY - numColumns*spaceY/2
            
            var unit:MovieClip, count:int=0
            for(var column:int=0 ; column<numColumns ; column++){
                for(var row:int=0 ; row<numRows ; row++){
                    unit = unitContainer.getChildAt(count) as MovieClip
                    unit.destX = LT_x + row*spaceX
                    unit.destY = LT_y + column*spaceY
                    count ++
                }
            }
            if(count < unitContainer.numChildren){
                for(var i:int=0 ; i<unitContainer.numChildren-numRows*numColumns ; i++){
                    unit = unitContainer.getChildAt(count) as MovieClip
                    unit.destX = LT_x + i*spaceX
                    unit.destY = LT_y + numColumns*spaceY
                    count ++
                }
            }
        } // everybodyMove 끝
        
    }
    
}