/**
 * Copyright gupon ( http://wonderfl.net/user/gupon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/65yT
 */

/*
 * 異常に重いですが正常です。
 * mouseX : 位相
 * mouseY : 曲率
 */
package{
	import flash.display.Loader;
	import flash.display.Shader;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filters.ShaderFilter;
	import flash.net.URLRequest;
	import flash.utils.ByteArray;
	
	import mx.utils.Base64Decoder;
	import mx.utils.Base64Encoder;
	
	public class YouTubeDroste extends Sprite{
		private const NUM_VIDEO:int = 5;
		private const VIDEO_ID:Array = ["pAwR6w2TgxY","3Za-V_lhwGg","F1jmhbw3JHw","Fv80DLlUwNQ","PuZ5tzr11Eo"];
		private var shader:Shader;
		private var filter:ShaderFilter;
		private var count:int = 0;
		private var container:Sprite;
		private var progress:Number = 0;
		
		public function YouTubeDroste(){
			if ( stage ) init();
			else addEventListener( Event.ADDED_TO_STAGE, init);
		}
		
		private function init( event:Event=null ):void{
			container = new Sprite();
			container.graphics.beginFill(0xFFFFFF);
			container.graphics.drawRect(0, 0, 800, 800);
			container.x = (stage.stageWidth - 800) / 2;
			container.y = (stage.stageHeight - 800 ) / 2;
			
			addChild(container);
			
			for(var i:int=0;i<NUM_VIDEO;i++){
				var loader:Loader = new Loader();
				loader.load(new URLRequest("http://www.youtube.com/apiplayer?version=3"));
				loader.contentLoaderInfo.addEventListener(Event.INIT, onLoaderInit);
				container.addChild(loader);
			}
			
			applyFilter();
			stage.addEventListener( MouseEvent.MOUSE_MOVE, changeFilter );
			addEventListener( Event.ENTER_FRAME, enterFrame );
		}
		
		private function enterFrame(event:Event):void{
			progress -= 10;
			shader.data.rotate.value = [-progress/120];
			shader.data.offsetX.value = [progress];
			filters = [filter];
		}
		
		private function changeFilter(event:MouseEvent=null):void{
			shader.data.phaseShift.value = [mouseX/2-600];
			shader.data.test.value = [ 500 + mouseY*10 ];
		}
		
		private function applyFilter():void{
			var s:String = "hVHBbtNAEH1eb2y3CmoO3KpKFl9AuSOspkVwoUiVELdiJRvVKLEjr1tQT/4QDmmAe+9cGpVj+QJ+"
							+ "AsStJ2bGmyYuBypZrzPz5s17m68egC8beGU+PM/GlSln3TydGDtNBwZ7RW7T98VxPrGYdc9MPizK"
							+ "ZROz6MyUNityeDQcGjsos2nF9SHBJDs3w3i/LGxl4oPRyAwqXHgK6B4fnlb9oiiH+AxtywEulPaw"
							+ "NbSO4FtaxVxN0o9v0vGpwf4LyEetLG9az2rIN1dDM0pPx1WbSToK3cE4mx7d0+rfQr7/a/VjYO8X"
							+ "a5EpdV4UE8y9O51kBi6XGk9vbn7MvdY+S8quNz1JrTk6yUbVuoK4WClc34ptH91pYfsmp1+i5ZtS"
							+ "9dtvcE3ltYT1fKhiNLKmert+Qd5sdYH/hOuVRZVWphXn5dbPf6kaUWVsy/XBt3pdswnRyn3wKcET"
							+ "jSQhDa2xq/EaPiFwiZ0OFppRIwV6UIQdQuoT7x08Qp9r6QuvB9TM6ylcMS/WjFInCAg7NKd+b9nX"
							+ "VAeC5CNAzdF2AiQ89wgD8sU8+heUsOfzHvFW+wn7FWz2avgOqY6dTsz7jY70RZd57IfuxnxXB83c"
							+ "D5p71G/exe37glduv8ZDp7++p9mv4zFfNfdk/oDqDu+HqLnurmrRI9wN+T0j1CHXEZKQ5uyPf2NF"
							+ "yDX146CZ94S3AR3xXdFNnJ7wFqIXYkFUPArxfYPzRHxnBj9y92R+KTmVy0kS2F7eoTpq8sXK3Q9J"
							+ "x7s353f2G1/SjyL2LbnqyPFYN3J37nI7vSZPgseb+M1+djz82cQ2/gI=";
			var d:Base64Decoder = new Base64Decoder();
			d.decode(s);
			
			var ba:ByteArray = d.drain();
			ba.inflate();
			
			shader = new Shader(ba);
			filter = new ShaderFilter(shader);
			filters = [filter];
		}
		
		private function onLoaderInit(event:Event):void{
			var player:Object = event.target;
			player = event.target.content;
			player.addEventListener("onReady", playerReady);
		}
		
		private function playerReady(event:Event):void{
			var player:Object = event.target;
			player.setSize(160, 120);
			player.x = count * 160;
			player.loadVideoById(VIDEO_ID[count]);
			count++;
		}
	}
}