/**
 * Copyright Takayuki.Yamazaki ( http://wonderfl.net/user/Takayuki.Yamazaki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/65D3
 */

// forked from actionscriptbible's Chapter 36 Example 4
package {
  import flash.display.*;
  import flash.events.MouseEvent;
  import flash.geom.Point;

  [SWF(backgroundColor="#000000")]
  public class ch36ex4 extends Sprite {
    protected var center:Point;
    protected var sourceBmp:BitmapData;
    protected var destBmp:BitmapData;
    protected var splitChannelsBitmap:Bitmap;
    public function ch36ex4() {
      //draw a white circle in the center
      center = new Point(stage.stageWidth/2, stage.stageHeight/2);
      var source:Shape = new Shape();
      source.x = center.x; source.y = center.y;
      addChild(source);
      source.graphics.beginFill(0xffffff, 1);
      source.graphics.drawCircle(0, 0, 100);
      
      //capture a bitmap of the white circle in sourceBmp
      sourceBmp = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0);
      destBmp = sourceBmp.clone();
      sourceBmp.draw(stage);
      
      //create a holder for destBmp
      splitChannelsBitmap = new Bitmap(destBmp);
      addChild(splitChannelsBitmap);

      stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
    }
    protected function onMouseMove(event:MouseEvent):void {
      //hold mouse button to show source graphic
      splitChannelsBitmap.visible = !event.buttonDown; 
      var dist:Number = Point.distance(new Point(stage.mouseX, stage.mouseY), center);
      dist /= 2;
      //copy the white circle, offseting RGB channels based on mouse location
      destBmp.copyChannel(sourceBmp, sourceBmp.rect, new Point(0, -dist),
        BitmapDataChannel.RED, BitmapDataChannel.RED);
      destBmp.copyChannel(sourceBmp, sourceBmp.rect, new Point(-dist, dist),
        BitmapDataChannel.GREEN, BitmapDataChannel.GREEN);
      destBmp.copyChannel(sourceBmp, sourceBmp.rect, new Point(dist, dist),
        BitmapDataChannel.BLUE, BitmapDataChannel.BLUE);
      event.updateAfterEvent();
    }
  }
}