/**
 * Copyright otherone ( http://wonderfl.net/user/otherone )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6584
 */

package 
{
    import flash.display.MovieClip;
    import flash.display.Loader;
    import flash.ui.ContextMenu;

    import caurina.transitions.*;
    import caurina.transitions.properties.FilterShortcuts;
    import caurina.transitions.properties.ColorShortcuts;
    import flash.net.URLRequest;
    import flash.net.navigateToURL;

    import flash.display.LoaderInfo;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.text.TextFormat;

    [SWF(backgroundColor = 0x000000, width = 500, height = 500, frameRate = 60)]
    /*
     http://img.simpleapi.net/
     でサムネールを生成してもらって
     メニューっぽいモノを作ってみました。
     サムネールがナウプリンティンになっていることがほとんどなので定期的に読み直すように作ったほうがよさそう
     模索中
     
     */

    public class Main extends MovieClip
    {
        //variables
        private var urlList:Array = [];
        private var listlen:int = 0;
        private var imgList:Array = [];
        private var cnt:int = 0;
        private var dNum:int = 80;//
        private var spd:Number = 0;
        private var direct:String = '';
        private var endNum:Number = 0;

        //text
        private var tf:TextField = new TextField();
        private var format:TextFormat = new TextFormat();

        //mc
        private var mainImg:MovieClip=new MovieClip();
        private var msk:MovieClip=new MovieClip();//マスク用

        //stage
        private var stw:uint = stage.stageWidth;
        private var sth:uint = stage.stageHeight;
        private var mX:Number;
        private var mY:Number;

        public function Main()
        {
            // constructor code
            this.contextMenu= new ContextMenu();
            this.contextMenu.hideBuiltInItems();

            //;
            ColorShortcuts.init();
            FilterShortcuts.init();
            //表示サイトのリスト;
            urlList = ["http://www.mztm.jp/","http://eiga.com/","http://www.yahoo.co.jp/","http://gigazine.net/","http://www.gizmodo.jp/","http://netatama.net/","http://blog.livedoor.jp/dqnplus/","http://wonderfl.net/","http://kakaku.com/","http://www.amazon.co.jp/"];
            listlen = urlList.length;

            //tf.multiline = tf.wordWrap = true;
            format.size = 14;
            format.align = 'center';
            tf.width = stw;
            tf.defaultTextFormat = format;
            tf.textColor = 0xffffff;
            tf.text = "お気に入りっぽいメニュー";//     

            var mskL:MovieClip=new MovieClip();
            var mskR:MovieClip=new MovieClip();
            drawBox(mskL,0x000000,dNum,sth);
            mskL.x = 0;
            msk.addChild(mskL);
            drawBox(mskR,0x000000,dNum,sth);
            mskR.x = stw - dNum;
            msk.addChild(mskR);
            addChild(mainImg);

            for (var i:int=0; i<listlen; i++)
            {
                imgLoad(urlList[i],i);
            }

        }




        private function imgLoad(urlstr:String,num:int):void
        {
            var ldr:Loader = new Loader();
            var info:LoaderInfo = ldr.contentLoaderInfo;
            imgList.push(ldr);

            //ldr.num = int(num);

            var url:String = "http://img.simpleapi.net/small/" + urlstr;
            var urlReq:URLRequest = new URLRequest(url);

            ldr.load(urlReq);
            info.addEventListener(Event.INIT,LoaderInfoInitFunc);

            function LoaderInfoInitFunc(event : Event):void
            {
                //trace("読み込んだコンテンツの初期化が行われた");
                cnt++;
                if (cnt == listlen)
                {
                    imgSet();
                }
            }
        }

        private function imgSet():void
        {
            for (var i:int=0; i<listlen; i++)
            {

                var imgmc:MovieClip =new MovieClip();
                var loadObj:Loader = imgList[i];
                imgmc.addChild(loadObj);
                imgmc.num = int(i);
                mainImg.addChild(imgmc);

                /*
                                //bitMap化するとwonderflで表示できない、、何故だろう
                                //Flash書き出しだとできるのに、、、
                                
                                var loadObj:Loader = imgList[i];
                                var ObjW:uint = loadObj.width;
                                var ObjH:uint = loadObj.height;
                                //
                                var imgmc:MovieClip =new MovieClip();
                                var bmp_data:BitmapData = new BitmapData(ObjW,ObjH);
                                bmp_data.draw(loadObj);
                                
                                imgmc.graphics.beginBitmapFill(bmp_data);
                                imgmc.graphics.drawRect(0, 0,ObjW,ObjH);
                                imgmc.graphics.endFill();
                                
                                mainImg.addChild(imgmc);
                                imgmc.buttonMode = true;
                                */
                imgmc.x = imgmc.width * i;

                //ボタン作る
                imgmc.addEventListener(MouseEvent.ROLL_OVER,fn_MouseEvent);
                imgmc.addEventListener(MouseEvent.ROLL_OUT,fn_MouseEvent);
                imgmc.addEventListener(MouseEvent.CLICK,fn_MouseEvent);

            }

            addChild(msk);
            msk.alpha = 0.2;
            mainImg.x=(stw/2)-(mainImg.width/2);
            mainImg.y=(sth/2)-(mainImg.height/2);


            tf.y = mainImg.y + mainImg.height + 10;
            trace("tf.y=",tf.y);
            addChild(tf);

            stage.addEventListener(MouseEvent.MOUSE_MOVE,function(event){
                        mX=stage.mouseX;
                        //mY=stage.mouseY;
                        
                        if(mX<=dNum)
                        {
                        spd=(dNum-mX)/2;
                        direct="L";
                        //trace("spd",spd);
                        }else if(mX>=stw-dNum)
                        {
                        spd=(mX-(stw-dNum-10))/2;
                        direct="R";
                        //trace("spd",spd);
                        }else
                        {
                        //spd=0
                        direct="";
                        }
                        
                        });
            stage.addEventListener(Event.ENTER_FRAME,function(event){
                        
                        if(direct=="L"){
                        endNum=dNum+20;
                        }else if(direct=="R"){
                        endNum=stw-mainImg.width-dNum-20;
                        }else{
                        }
                        
                        //trace(Math.round(mainImg.x))
                        mainImg.x += (endNum - mainImg.x) * (spd/1000)
                        });

        }

        private function fn_MouseEvent(e:MouseEvent):void
        {

            var _num:int = e.currentTarget.num;
            var url:URLRequest = new URLRequest(urlList[_num]);

            switch (e.type)
            {
                case MouseEvent.ROLL_OVER :
                    spd = 0;
                    direct = "";
                    tf.text = urlList[_num];
                    Tweener.addTween(e.target,{_Glow_alpha:1,_Glow_blurX:30,_Glow_blurY:30,_Glow_color:0xFFFFFF,_Glow_quality:4,_Glow_strength:3,_tintBrightness:0.2,time:0.5});

                    break;
                case MouseEvent.ROLL_OUT :
                    Tweener.addTween(e.target,{_Glow_alpha:0,_Glow_blurX:0,_Glow_blurY:0,_Glow_color:0xFFFFFF,_Glow_quality:0,_Glow_strength:0,_tintBrightness:0,time:0.1});
                    break;
                case MouseEvent.CLICK :

                    navigateToURL(url,"_blank");
                    break;
            }




        }


        private function drawBox(box:MovieClip,color:uint,width:uint,height:uint):void
        {
            box.graphics.beginFill(color, 1);
            box.graphics.drawRect(0, 0, width, height);
            box.graphics.endFill();
        }




    }

}