/**
 * Copyright medadotter ( http://wonderfl.net/user/medadotter )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/64Zk
 */

package  {
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    
    /**
     * @author DT
     * STG作る前の練習。
     */
    [SWF(backgroundColor="0x000000",width="465",height="465")]
    public class STGMain extends Sprite {
        private var bullets:Vector.<Bullet> = new Vector.<Bullet>();
        private var numBullets:uint = 50;
        private var beginX:Number = stage.stageWidth / 2;
        private var beginY:Number = stage.stageHeight / 2;
        
        public function STGMain() {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            var blur:BlurFilter = new BlurFilter();
            for (var i:int = 0; i < numBullets; i++) {
                var bullet:Bullet = makeBullet();
                addChild(bullet);
                bullets.push(bullet);
                bullet.filters = [blur];
            }
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(event:Event):void {
            for (var i:int = bullets.length - 1; i >= 0 ; i--) {
                bullets[i].velocity.y += 0.2;
                bullets[i].update();
                if (!bullets[i].onArea()) refreshBullet(bullets[i]);
            }
        }
        
        private function removeBullet(i:int):void {
            removeChild(bullets[i]);
            bullets.splice(i, 1);
        }
        
        private function refreshBullet(bullet:Bullet):Bullet {
            var color:uint = Math.random() * 0xffffff;
            var radius:Number = Math.random() * 10 + 5;
            bullet.color = color;
            bullet.radius = radius;
            bullet.x = beginX;
            bullet.y = beginY;
            bullet.velocity.x = Math.random() * 6 - 3;
            bullet.velocity.y = -Math.random() * 10;
            return bullet;
        }
        
        private function makeBullet():Bullet {
            return refreshBullet(new Bullet());
        }
        
    }

}

import flash.display.Sprite;
import flash.geom.Point;

class Bullet extends Sprite {
        private var _position:Point = new Point();
        private var _velocity:Point = new Point();
        private var _radius:Number;
        private var _color:uint;
        
        public function Bullet(radius:Number = 40, color:uint = 0xff0000,x:Number = 0,y:Number=0) {
            this.radius = radius;
            this.color = color;
            this.x = x;
            this.y = y;
            draw();
        }
        
        public function update():void {
            x += velocity.x;
            y += velocity.y;
        }
        
        public function onArea():Boolean {
            if (x + radius >= 0 && x - radius <= stage.stageWidth && 
                y + radius >= 0 && y - radius <= stage.stageHeight) return true;
            return false;
        }
        
        private function draw():void {
            graphics.clear();
            graphics.beginFill(color);
            graphics.drawCircle(0, 0, radius);
            graphics.endFill();
        }
        
        override public function set x(value:Number):void {
            position.x = value;
            super.x = position.x;
        }
        
        override public function set y(value:Number):void {
            position.y = value;
            super.y = position.y;
        }
        
        public function get position():Point {
            return _position;
        }
        
        public function set position(value:Point):void {
            _position = value;
        }
        
        public function get velocity():Point {
            return _velocity;
        }
        
        public function set velocity(value:Point):void {
            _velocity = value;
        }
        
        public function get radius():Number {
            return _radius;
        }
        
        public function set radius(value:Number):void {
            _radius = value;
            draw();
        }
        
        public function get color():uint {
            return _color;
        }
        
        public function set color(value:uint):void {
            _color = value;
            draw();
        }
        
    }