/**
 * Copyright nyamogera ( http://wonderfl.net/user/nyamogera )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/64Cd
 */

// forked from mogera's 朝わん１日目
package {

    //    初めての朝わん。
    //    案外進まなかったのでここで終わり
        
    //    とりあえず、ここまで。続きはまたこんど。
    import flash.display.Sprite;
    import flash.events.MouseEvent;  
    import flash.display.Shape;   
    
    public class FlashTest extends Sprite {
         [SWF(width="465", height="465", backgroundColor="0xffffff", framerate="20")]
         
        private var _tmpLine:Line;        //    一時保管ライン
        
        private var _tmpBuffer:Shape;     //    描画ライン一時保存用
        private var _backBuffer:Shape;    //    描画ライン（もう動かさないよう）
        
        private var _lines:Vector.<Line>; //    保管ライン
        
        private var _lineStartAndLast:Line;//    最初と最後をつなぐ
        
        private var _debug:DebugTest;
        
        private var _trace:DebugTest;
        private var _traceStr:String;
        
        private var _isCreatePolygon:Boolean;
        
        private var _createPolygonButton:TestButton;
        
        public function FlashTest() {
            
            // write as3 code here..           
            var background:Sprite = createBackGround() 
            //addChild( new AsaWon( 1, 0x000000));
            
            //    トレース用
            _trace= new DebugTest( "trace");
            _trace.x = 350;
            addChild( _trace);
 
            //    デバッグ用（残らない）
            _debug = new DebugTest( "mouse");
            _debug.x = 300;
            addChild( _debug );
             
             _lines = new Vector.<Line>;    //    保管用のライン 
             
             _lineStartAndLast = new Line();          
             
             addChild( _tmpBuffer = new Shape() );     //  保存用のバッファと
             addChild(  _backBuffer = new Shape() );   //  表示用のバッファ
             
             addChild( _createPolygonButton = new TestButton("Create!"));
             _createPolygonButton.enabled = false;
             
             _createPolygonButton.addEventListener( MouseEvent.CLICK, createPolygonHandler);
             
             var resetButton:TestButton;
             addChild( resetButton = new TestButton("Reset!"));
             resetButton.addEventListener( MouseEvent.CLICK, resetHandler );
             resetButton.y = 20;
             
            //    イベント取り付ける
            background.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
            background.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
            background.addEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler);
            
        }
        
        private function resetHandler(event:MouseEvent) : void
        {
            //    ここでリセットする
        }
        
        private function createPolygonHandler(event:MouseEvent) : void
        {
            //    ここからポリゴン作る！
            _isCreatePolygon = false;
        }

        //    トレースを追加する
        private function addTrace(str:String) : void
        {
            _traceStr = _traceStr + "\n" + str;
            _trace.add("trace", _traceStr );
        }
        
        //    マウスが移動したとき
        private function mouseMoveHandler(event:MouseEvent) : void
        {
            _debug.add("mouse", "mouse move ->" + _tmpLine);
            _debug.add("pos x:", event.stageX.toString() + ", y:"+ event.stageY.toString() );
            
            if( ! _isCreatePolygon ) return ;    //    作成フラグがないのでリターンする
            if( ! _tmpLine ) return ;    //    保存用ラインが無いのでリターン
            _tmpLine.p1.x = mouseX;
            _tmpLine.p1.y = mouseY;
            
            _tmpBuffer.graphics.clear();
            _tmpLine.draw(_tmpBuffer, 0xff0000);
            
            _lineStartAndLast.p1.x = mouseX;
            _lineStartAndLast.p1.y = mouseY;
            _lineStartAndLast.p0.x = _lines[0].p0.x;
            _lineStartAndLast.p0.y = _lines[0].p0.y;
            
            //    最初と最後をつなぐ用の描画
            _lineStartAndLast.draw(_tmpBuffer, 0x00ff00);
            
            //addTrace("mou move")
        }
        
        //    マウスが押されたとき
        private function mouseDownHandler(event:MouseEvent) : void
        {
            _debug.add("mouse", "mouse down");
            _debug.add("pos put x:", event.stageX.toString() + ", y:"+ event.stageY.toString() );
            
            if( !_isCreatePolygon)
            {
                _tmpLine = new Line();
                _tmpLine.p0.x = mouseX;
                _tmpLine.p0.y = mouseY;
            
                addTrace("mou down")
            }
            
            _isCreatePolygon = true;
            
        }
        
        //    マウスがUP！
        private function mouseUpHandler(event:MouseEvent) : void
        {
            _tmpLine.p1.x = mouseX;
            _tmpLine.p1.y = mouseY;
 
            _tmpBuffer.graphics.clear();    //    バッファクリア
            
            _lineStartAndLast.p1.x = mouseX;
            _lineStartAndLast.p1.y = mouseY;
            
            //    最初と最後をつなぐ用の描画
            _lineStartAndLast.draw(_tmpBuffer, 0x00ff00);
            
            _tmpLine.draw(_backBuffer, 0x000000);    //    バッファに書き込む
            _lines.push(_tmpLine);                    //    ラインを保管する
            
            if( _lines.length >= 3 ) _createPolygonButton.enabled = true;
            
            addTrace("line" + _lines.length + 
                    " line1:x=" + _tmpLine.p0.x + ",y=" + _tmpLine.p0.y +
                    " line2:x=" + _tmpLine.p1.x + ",y=" + _tmpLine.p1.y);
                    
            _tmpLine = new Line();
            _tmpLine.p0.x = mouseX;
            _tmpLine.p0.y = mouseY;        

            addTrace("mou up2")
        }
        
        //    背景表示用
        private function createBackGround(color:uint=0xffffff):Sprite
	{
            
	    var sprite:Sprite = new Sprite();
	    addChild( sprite );
	    var shape:Shape = new Shape();
            shape.graphics.beginFill(color, 1);
	    shape.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
			
	    sprite.addChild(shape);
		
            return sprite;	
	}

        private function crossCheck() : void
        {
            var length:int = _lines.length;
            for(var i:int = 0; i < length -1; i ++ ) 
            {
                for( var j:int = i; j < length; j++)
                {
                    if( Line.intersection(_lines[i], _lines[j]))
                    {
                        addTrace( i.toString() + "x" + j.toString() + " is cross");
                    }
                    else
                    {
                        addTrace( i.toString() + "x" + j.toString() + " is not cross");
                    }
                    
                }
            }
        }
    }
}

internal class TestButton extends Sprite
{
    private var _enabled:Boolean;
    private var _textField:TextField = new TextField();
    
    public function TestButton(str:String) : void
    {
        _textField.text = str;
        _textField.height = _textField.textHeight + 4;
        _textField.width = _textField.textWidth + 4;
        _textField.background = true;
        _textField.backgroundColor = 0x000000;
        _textField.textColor = 0xffffff;
        
        addChild(_textField);
    }
    
    public function set enabled(val:Boolean) : void
    {
        if( val )
        {
            _textField.backgroundColor = 0x333333;
        }
        else
        {
            _textField.backgroundColor = 0x0888888;
        }
        mouseEnabled = val;
        mouseChildren = false;
        
        _enabled = val;
    }
    
    public function get enabled() : Boolean { return _enabled; }
}

//    ポリゴン作成クラス
internal class CreatePolygon
{
    private var _frame:Vector.<Point>;
    private var _tmpLines:Vector.<Line>;
    
    private var _polygon:Vector.<Polygon>;
    
    private var _isCreated:Boolean;
    public function get isCreated() : Boolean { return isCreated; } 
    
    //    todo
    public function addFramePos(p:Point) : void
    {
        _frame.push(p);
    }
    
    //    todo
    public function CreatePolygon() 
    {
        _frame = new Vector.< Point >();
        _tmpLines = new Vector.<Line>();
        _polygon = new Vector.<Polygon>;
    }
    
    //    todo
    public function reset() : void
    {
        
    }
}


//    ライン
import flash.display.Graphics;
import flash.geom.Point;
import flash.display.Shape;

internal class Line
{
	public var p0:Point = new Point();
	public var p1:Point = new Point();

        public function draw( shape:Shape, color:uint ) : void
        {
            var g:Graphics = shape.graphics;
            g.lineStyle(1,color,1.0);
            g.moveTo(p0.x,p0.y);
            g.lineTo(p1.x,p1.y);
        }
        //    ここで勉強中
        //    http://www5d.biglobe.ne.jp/~tomoya03/shtml/algorithm/Intersection.htm
        public static function intersection(line0:Line, line1:Line) : Boolean
        {
            if(intersectFunc(line0, line1) && intersectFunc(line1, line0))
            {
                return true;
            }
        
            return false;
        }
        private static function intersectFunc(line0:Line, line1:Line) : Boolean
        {
            if( 
            ((line0.p0.x - line0.p1.x) * (line1.p0.y - line0.p0.y) + 
            (line0.p0.y - line0.p1.y) * (line0.p0.x - line1.p0.x)) * 
            ((line0.p0.x - line0.p1.x) * (line1.p1.y - line0.p0.y) + 
            (line0.p0.y - line0.p1.y) * (line0.p0.x - line1.p1.x)) < 0)
            {
                return true;
            }
            return false;
        }
        
        public function isDot() : Boolean
        {
            return (( p0.x == p1.x) && (p0.y == p1.y));
        }
}
 
internal class Polygon
{
    public var p0:Point;
    public var p1:Point;
    public var p2:Point;

    public function draw(shape:Shape, color:uint) : void
    {
        var g:Graphics = shape.graphics;
        g.lineStyle(1,color,1.0);
        g.moveTo(p0.x,p0.y);
        g.lineTo(p1.x,p1.y);      
        g.lineTo(p2.x,p2.y);   
        g.lineTo(p0.x,p0.y);   
    }
}

//     （U＾ω＾） <わん
import flash.text.TextField;
import flash.display.Sprite;
internal class AsaWon extends Sprite
{
    private var textField:TextField;
    
    function AsaWon(day:int, color:uint) 
    {
       textField = new TextField();
       textField.text = "朝 （U＾ω＾） <わん " + day + "日め";
       textField.textColor = color;
       textField.width = textField.textWidth + 4;
       textField.height = textField.textHeight + 4;
       
       addChild( textField );
    }
        
        
}

//    デバッグ用のコード
//    http://wonderfl.net/code/c4bf78ae758a71c3a7bdcdc26fcf79383b2c2f7a/edit
import flash.display.Sprite;
import flash.events.MouseEvent;
import flash.text.TextField;
import flash.utils.Dictionary;

class DebugTest extends Sprite
{
    private var barField:TextField;
    private var openField:TextField;
    private var debugField:TextField;
    private var dictionary:Dictionary;
		
    public function DebugTest(title:String) 
    {
	dictionary = new Dictionary(true);
	
	barField = new TextField();
	openField = new TextField();
	debugField = new TextField();
			
	barField.text = title;
	openField.text = "▲";	//	上三角
		
	barField.background = true;
	barField.backgroundColor = 0x00000;
	barField.textColor = 0xffffff;
	barField.x = 20;
	barField.height = 20;
	barField.addEventListener( MouseEvent.MOUSE_DOWN, startMove);
	barField.addEventListener( MouseEvent.MOUSE_UP, endMove);
	barField.border = true;
	barField.selectable= false;
	
	openField.background = true;
	openField.backgroundColor = 0x00000;
	openField.textColor = 0xffffff;
	openField.height = 20;
	openField.width = 20;
	openField.selectable= false;
	openField.border = true;
        openField.mouseEnabled = true;
	openField.addEventListener( MouseEvent.CLICK, switchVisible);

	debugField.border = true;
	debugField.background = true;		
	debugField.y = 20;
			
	addChild( barField );
	addChild( openField );
	addChild( debugField );
			
	update();
    }
		
    //	すいっち
   private function switchVisible(e:MouseEvent):void 
   {
        debugField.visible = !debugField.visible;

        if ( debugField.visible ) 
        {
	    openField.text = "▲"
	}
        else
	{
	    openField.text = "▼"
       	}
	    
    }
		
    //	
    private function endMove(e:MouseEvent):void 
    {
        stopDrag();
    }

	
    //	
    private function startMove(e:MouseEvent):void 
    {
        startDrag();
    }
    
    //	更新
    private function update():void
    {
        var w:Number = Math.max( barField.textWidth + 20, debugField.textWidth  ) + 4 ;
        barField.width = w - 20;
        debugField.width = w;
    		
        debugField.height = debugField.textHeight + 4;
    }
    	
    public function add(key:String, str:String) : void
    {
        dictionary[key] = str;
        debugField.text = "";
    	
        for ( var s:String in dictionary )
	{
	    debugField.appendText( s + "：" + dictionary[s] + "\n" );
	}
			
        update();
    }
		
    public function remove(key:String) : void
    {
        dictionary[key] = null;
        delete dictionary[key];
    	
        update();
    }
 }
 
