/**
 * Copyright cpu_t ( http://wonderfl.net/user/cpu_t )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/646E
 */

package 
{
	import flash.display.Sprite;
	import flash.events.Event;
	
	import net.hires.debug.Stats;
	public class FlashTest extends Sprite
	{
		public function FlashTest()
		{
			stage.addChild(new Stats());
			this.graphics.beginFill(0);
			this.graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight);
			
			fingerPos={x:0,y:0,vx:0,vy:0};
			power=0;
			
			addEventListener(Event.ENTER_FRAME,enterFrameHandler);
		}
		
		private var head:FireNode;
		private var tail:FireNode;
		
		private const loopNum:int=3;
		
		private var fingerPos:Object;
		private var power:Number;
		
		private function enterFrameHandler(e:Event):void
		{
			var fnode:FireNode;
			// new node
			for(var i:int=0;i<loopNum;i++)
			{
				fingerPos.vx*=0.75;
				fingerPos.vy*=0.75;
				fingerPos.vx+=(mouseX-fingerPos.x)*0.2*(i+1)/loopNum;
				fingerPos.vy+=(mouseY-fingerPos.y)*0.2*(i+1)/loopNum;
				fingerPos.x+=fingerPos.vx;
				fingerPos.y+=fingerPos.vy;
				
				power+=Math.sqrt(fingerPos.vx*fingerPos.vx+fingerPos.vy*fingerPos.vy)*1.6*i/loopNum;
				power*=0.85;
				if(power>100)power=100;
				fnode=new FireNode(power);
				addChild(fnode);
				fnode.x=fingerPos.x-fingerPos.vx*i/loopNum+(Math.random()-0.5)*30;
				fnode.y=fingerPos.y-fingerPos.vy*i/loopNum+(Math.random()-0.5)*30;
				fnode.vx=fingerPos.vx*0.3;
				fnode.vy=fingerPos.vy*0.3;
				if(head==null)
				{
					head=tail=fnode;
				}
				else
				{
					fnode.prev=tail;
					tail=tail.next=fnode;
				}
			}
			
			// update
			fnode=head;
			while(fnode!=null)
			{
				fnode.update();
				if(fnode.isDead)
				{
					removeChild(fnode);
					if(fnode.prev==null)
					{
						head=fnode.next;
					}
					else
					{
						fnode.prev.next=fnode.next;
					}
					if(fnode.next==null)
					{
						tail=fnode.prev;
					}
					else
					{
						fnode.next.prev=fnode.prev;
					}
				}
				fnode=fnode.next;
			}
		}
	}
}

import flash.display.BlendMode;
import flash.display.Sprite;
import flash.filters.BlurFilter;

class FireNode extends Sprite
{
	private static var filetr:BlurFilter=new BlurFilter(16,16);
	
	public function FireNode(size:Number=30)
	{
		this.blendMode=BlendMode.ADD;
		this.filters=[filetr];
		this.graphics.beginFill(0x401000);
		this.graphics.drawCircle(0,0,size);
		
		vx=vy=0;
		isDead=false;
	}
	
	public var next:FireNode;
	public var prev:FireNode;
	
	public var vx:Number;
	public var vy:Number;
	
	public var isDead:Boolean;
	
	public function update():void
	{
		if(this.width<10)
		{
			isDead=true;
			return;
		}
		this.scaleX=this.scaleY*=0.95;
		
		vx*=0.95;
		vy*=0.95;
		//vx+=(Math.random()-0.5)*2.0;
		//vy+=(Math.random()-0.5)*2.0;
		this.x+=vx;
		this.y+=vy;
	}
}