/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/63q2
 */

// forked from tepe's forked from: forked from: forked from: flash on 2014-5-19
// forked from tepe's forked from: forked from: flash on 2014-5-19
// forked from tepe's forked from: flash on 2014-5-19
//XMLツリーの視覚化
package{
    import flash.display.*;
    import flash.ui.*;
    import flash.text.*;
    import flash.events.*;
    import flash.net.*;
    public class Main extends Sprite{
        
        public function Main(){
                    
            var ui:TreeUI = new TreeUI();
            var wp2:WindowPanel = new WindowPanel(ui);
            ui.x = 100;
            
            var ld:TubeLoader = new TubeLoader();
            ld.addEventListener(Event.COMPLETE,function(e:Event):void{
                var xml:XML = XML(ld._xml);
                ui.node = setXML(xml);;
                
            });
            ld.requestWords("MMD");
            addChild(ui);

        }

        
        public function setXML(xml:XML):TreeNode{
            var list:XMLList = xml.children();
            var node:TreeNode = setXMLList(list);
            var str:String = xml.localName();
            var att:XMLList = xml.attributes();
            for(var i:int=0;i<att.length();i++){
                //str += " "+att[i].localName();
                str += "\n ・"+att[i].localName();
                str += " = "+att[i].toXMLString();
            }
            node.name = str;
            return node;
        }
        private function setXMLList(list:XMLList):TreeNode{
            var node:TreeNode = new TreeNode();
            //node.name = list.localName();
            for(var i:int=0;i<list.length();i++){
                var node2:TreeNode = setXMLList(list[i].elements());
                //node2.name = list[i].localName();
                var str:String = list[i].localName();
                var att:XMLList = list[i].attributes();
                for(var j:int=0;j<att.length();j++){//属性
                    str += "\n ・"+att[j].localName();
                    str += " = "+att[j].toXMLString();
                }                
                att = list[i].text();
                if(0<att.length()) str+=" :";
                for(j=0;j<att.length();j++){//属性
                    str += " "+att[j].toXMLString();
                }
                node2.name = str;
                node.addNode(node2);
                
            }
            
            return node;
        }


        
    }

}

import flash.display.*;
import flash.events.*;
import flash.text.*;
class WindowPanel extends Sprite{
    private var _title:String = "";
    private var _mx:Number = 20;
    private var _my:Number = 10;
    private var _target:DisplayObject;
    private var _tf:TextField;
    public function WindowPanel(o:DisplayObject=null){
        if(o!=null)target=o;
        draw();
        addEventListener(MouseEvent.MOUSE_MOVE,onMove);
        addEventListener(MouseEvent.MOUSE_OUT,onOut);
        addEventListener(MouseEvent.MOUSE_DOWN,onDrag);
        addEventListener(MouseEvent.MOUSE_UP,onDrop);
    }
    public function set target(o:DisplayObject):void{
        _target = o;
        addChild(o);
        x = o.x;
        y = o.y;
        o.x=0;
        o.y=0;
        
        draw();
    }
    
    public function set title(t:String):void{
        _title = t;
        draw();
    }


    //タイトル表示
    private function initTF():void{
        _tf = new TextField();
        _tf.text = _title;
        _tf.y = -_my;
        _tf.selectable = false;
        _tf.width = _tf.textWidth+5;
        _tf.height = _tf.textHeight+5;
        addChild(_tf);
    }

    //ウィンドウ更新
    public function draw(c:uint=0x000000,a:Number=0.2):void{
        initTF();
        var w:Number,h:Number;
        if(_target==null){w=this.width;h=this.height;}
        else{ 
            w=_target.width;h=_target.height;
            this.x += _target.x;
            this.y += _target.y;
            _target.x = 0;
            _target.y = 0;
        }
        
        this.graphics.clear();
        this.graphics.lineStyle(0,0x0,a);
        this.graphics.beginFill(c,a);
        this.graphics.drawRect(-_mx,-_my,w+_mx*2,h+_my*2);
        this.graphics.endFill();
    }
    
    private function onOut(e:MouseEvent):void{
        Mouse.cursor = MouseCursor.AUTO;
    }

    private function onMove(e:MouseEvent):void{
        if(e.target == this)Mouse.cursor = MouseCursor.HAND;
        else Mouse.cursor = MouseCursor.AUTO;
    }

        
    private function onDrag(e:MouseEvent):void{
        if(e.target == this){
            this.startDrag();
        }
        draw();
        e.currentTarget.parent.setChildIndex(e.currentTarget,e.currentTarget.parent.numChildren-1); //並べ替え
    }
    private function onDrop(e:MouseEvent):void{
        this.stopDrag();
        draw();
    }
}



import flash.events.*;
import flash.text.*;
import flash.display.*;
import flash.geom.*;
import flash.ui.*;

    class TreeUI extends WindowPanel{
        
        
        private var rootTree:TreeNode = new TreeNode();
        private var treeUI:Sprite = new Sprite();
        private var pen:Pen = new Pen(treeUI.graphics,0x444444);
        public function TreeUI(){
            this.target = treeUI;
            rootTree.name="/"
            rootTree.closed = false;
            render();
        }
        
        public function set node(tree:TreeNode):void{
            rootTree = tree;
            render();
            
        }

        
        //描画処理
        public function render():void {
            treeUI.graphics.clear();
            while (treeUI.numChildren > 0) treeUI.removeChildAt(0);
            renderCell(rootTree, 0, 0);//ノード描画
            draw();
        }
        
        private function renderCell(tree:TreeNode, x:Number, y:Number):Number {
            var sy:Number = y;
            var tui:TreeNodeUI = new TreeNodeUI(tree, x, y,this);
            var h:Number = tui.height;
            treeUI.addChild(tui);
            
            y += h+5;
            if (!tree.closed) {//子リストの描画
                var n:Number = 10;
                var vx:Number = x + 7;
                var vy:Number = y;
                
                for each(var child:TreeNode in tree.list) {
                    //pen.moveTo(vx, y+10);
                    pen.moveTo(vx, y+n);
                    pen.lineTo(vx + 10, y + n);//横線
                    //vy = y+10;
                    vy = y+n;
                    y = renderCell(child, x + 20, y);//子リスト
                }
                if(0<tree.list.length){
                    pen.moveTo(vx, sy+15);
                    pen.lineTo(vx, vy);//縦線
                }
            }
            return y;
        }
    }
    



import com.bit101.components.PushButton;

class TreeNodeUI extends Sprite{
    public var node:TreeNode;
    public var treeUI:TreeUI;
    private var _minBtn:PushButton;
    public var tf:TextField;
    
    public function TreeNodeUI(_node:TreeNode,x:Number,y:Number,main:TreeUI) {
        node = _node;
        treeUI = main;
        
        
        tf = new TextField();
        tf.autoSize = "left";
        tf.text = node.name;
        tf.backgroundColor = 0xffffff;
        tf.addEventListener(MouseEvent.MOUSE_OVER,function():void{
            tf.border=true;
            tf.background = true;
        });
        tf.addEventListener(MouseEvent.MOUSE_OUT,function():void{
            tf.border=false;
            tf.background = false;
            tf.selectable=false;
        });
        tf.addEventListener(MouseEvent.MOUSE_DOWN,function(e:MouseEvent):void{
            
        });
        tf.addEventListener(MouseEvent.MOUSE_UP,function():void{
            tf.selectable=true;
        });

        //tf.background =true;
        //tf.border=true;
        tf.selectable=false;

        addChild(tf);
        if(0<node.length){
            _minBtn = createMinBtn(); 
            addChild(_minBtn);
            tf.x = _minBtn.width+2;
        }
        
        this.x = x;
        this.y = y;
    }
    

    
    //最小化ボタン
    private function createMinBtn():PushButton {
        var result:PushButton = new PushButton(null, 0, 3, "+", minimize);
        result.width = result.height = 14; result.draw();
        result.addEventListener(MouseEvent.CLICK,minimize);
        result.label = (node.closed) ? "+" : "-"; 
        return result;
    }
    
    private function minimize(event:MouseEvent = null):void {
        node.closed = !node.closed;
        treeUI.render();
        if (_minBtn) { 
            _minBtn.label = (node.closed) ? "-" : "+"; 
        }
    }
    
}

class TreeNode {
    
    public static var ID:int = 0;
    public var parent:TreeNode;//親
    public var closed:Boolean = true;//展開状態
    public var name:String = "node" + (ID++);//表示名
    private var _children:Vector.<TreeNode>;//子リスト
    
    public function TreeNode(str:String=null){
        if(str!=null)name=str;
        _children= new Vector.<TreeNode>;
    }

    public function get length():int{
        return _children.length;
    }

    
    public function get list():Vector.<TreeNode>{
        //createChild();
        return _children;
    }
    
    //名前を指定してノード取得
    public function getNode(n:String=null):TreeNode{
        for(var i:int=0;i<_children.length;i++){
            if(_children[i].name==n)return _children[i];
        }
        return null;
    }


    //ノードを追加
    public function addNode(t:TreeNode):void{
        _children.push(t);
    }
    //ノード生成
    public function createNode(str:String):void{
        var node:TreeNode = new TreeNode(str);
        _children.push(node);
    }
    //パスを指定して生成する
    public function createPath(path:String):void{
        var ar:Array = path.split("/");
        var node:TreeNode = this;
        for(var i:int=0;i<ar.length;i++){
            
            //指定されたツリーが存在しなければ生成。存在すればそのまま
            if(node.getNode(ar[i])==null)node.createNode(ar[i]);
            node = node.getNode(ar[i]);
        }

    }



}

class Pen{
    
        private var g:Graphics;
        private var sx:Number;
        private var sy:Number;
        private var color:uint;
        public function Pen(g:Graphics,c:uint=0x000000){
            this.g = g;
            this.color = c;
        }
        public function moveTo(x:Number, y:Number):void {
            g.moveTo(x, y);
            sx = x;
            sy = y;
        }
        
        public function lineTo(x:Number, y:Number):void {
            g.lineStyle(0,color);
            g.lineTo(x, y);
            sx = x;
            sy = y;
        }
    }
    
    
    
    
import flash.text.*;
import flash.display.*;
import flash.net.*;
import flash.events.*;
import flash.utils.*;
import flash.system.*;
class TubeLoader extends Sprite{

        //動画ID取得
        //投稿者取得
        //動画タイトル取得
        //再生時間取得
        
        //キーワード検索
        //投稿者検索
        
        private var loader:URLLoader;
        public var idList:Array;
        public var titleList:Array;
        public var authorList:Array;
        public var durationList:Array;
        public var entryList:Array;
        private var _words:String = "";//前回の検索ワード
        private var cnt:int=0;//リクエスト回数
        private var _results:int = 20;
        
        public function TubeLoader() {
            idList = new Array();
            titleList = new Array();
            authorList = new Array();
            durationList = new Array();
            entryList = new Array();
        }
        
        public function clear():void{
            idList = new Array();
            titleList = new Array();
            authorList = new Array();
            durationList = new Array();
            entryList = new Array();
            cnt=0;
        }
        
        public function set results(n:int):void{
            _results = n;
            clear();
        }
        //キーワード検索
        public function requestWords(key:String):void{            
            //var str:String = "http://gdata.youtube.com/feeds/api/videos/-/";
            var str:String = "http://gdata.youtube.com/feeds/api/videos?"
            if(_words != key){ 
                _words = key;
                clear();
            }
            str += "q="+escapeMultiByte(_words);//検索ワード
            //str += escapeMultiByte(_words)+"?";//検索ワード
            str += "&max-results="+_results.toString();//件数
            str += "&start-index="+(cnt*_results+1).toString();//インデックス
            str += "&v=2";
            //var loader:URLLoader = new URLLoader();
            
            loader = new URLLoader();
            loader.addEventListener(Event.COMPLETE,onComplete);
            var url:URLRequest = new URLRequest(str);
            loader.load(url);
            cnt++;
        }
        
        
        public function getImage(id:String,num:int=1):Sprite{
            var loader:Loader;
            loader = new Loader();
            //const req:String = "http://www.ozworks.dip.jp/img/01/1426006.png";
            const str1:String = "http://i.ytimg.com/vi/";
            const str3:String = "/default.jpg";
            const str4:String = "/0.jpg";
            var req2:String;
            switch(num){
                case 0:
                    req2 = str1+id+str4;
                    break;
                case 1:
                    req2 = str1+id+"/default.jpg";
                    break;
                
            }

            
            loader.load(new URLRequest(req2));//youtubeプレイヤー読み込み
            var s:Sprite = new Sprite();
            s.addChild(loader);
            return s;
        }
        

        
        public var _xml:String;
        private function onComplete(e:Event):void{
            loader.removeEventListener(Event.COMPLETE,onComplete);
            var res:XML = new XML(e.target.data);
            _xml = e.target.data;
            var list:XMLList = res.children();
            //var str:String = "";
            var cnt:int=0;
            
            for(var i:int=0;i<list.length();i++){
                if(list[i].localName()!="entry")continue;
                var obj:Object = new Object();
                var list3:XMLList = list[i].elements();
                for(var j:int=0;j<list3.length();j++){
                    if(list3[j].localName()=="title"){ //タイトル抽出
                        //str += list3[j].text()+"\n";
                        var title:String = new String();
                        title += list3[j].text();
                        titleList.push(title);
                        //obj[list3[j].localName]=title;
                    }
                    else if(list3[j].localName()=="id"){ //ID抽出
                        var str3:String = list3[j].text();
                        var n:int = str3.indexOf("video:")+6;
                        //var n:int = str3.indexOf("videos/")+7;
                        var id:String = str3.substring(n);
                        //str += id+"\n";
                        idList.push(id);
                        //obj[list3[j].localName]=id;
                    }
                    else if(list3[j].localName()=="author"){//投稿者名
                        var str4:String;
                        var list2:XMLList = list3[j].elements();
                        str4 = list2[0].text();
                        authorList.push(str4);
                        //obj[list3[j].localName]=str4;
                    }    
                    else if(list3[j].localName()=="group"){//再生時間
                        var str5:String = list3[j].toXMLString();
                        var n2:int = str5.indexOf('duration="')+10;
                        var n3:int = str5.indexOf('"',n2);
                        var n4:int = parseInt(str5.substring(n2,n3));
                        durationList.push(n4);
                        //obj[list3[j].localName]=n4;
                    }//*/
                    else if(list3[j].localName()=="uploaded"){//再生時間
                        //obj[list3[j].localName]=list3[j].toXMLString();
                    }
                    
                    obj[ list3[j].localName() ] = list3[j].toXMLString();
                }//for
                entryList.push(obj);

                //str += list3.elements("id").toXMLString()+"\n\n";
                //str += i.toString()+" "+list[i].localName()+"\n";
                //str += list[i].toXMLString()+"\n\n";
                //str += "\n";
                //_xml = res.toXMLString();
            }//for
            
            //コンプリートイベント発行
            var event:Event = new Event(Event.COMPLETE);
            this.dispatchEvent(event);
        }
    }
//}

 

