/**
 * Copyright hrtsgt ( http://wonderfl.net/user/hrtsgt )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/63d8
 */

package{
    import flash.display.*;
    import flash.events.*;
    import flash.net.*;
    import flash.geom.*;
    import flash.filters.*;
    import flash.system.LoaderContext;
    [SWF(width=465, height=465, backgroundColor=0x0, frameRate=60)]
    
    public class S091214 extends Sprite{
        private const URL:String = "http://t.args.in/lab/lib/monalisa.jpg";
        private var _blocks:Array;
        private var _source:BitmapData;
        private var _canvas:BitmapData;
        private var p:Point = new Point(0, 0);
        private static const W:uint = 10;
        private static const H:uint = 10;
    
        public function S091214(){
            if( stage ) init();
            else addEventListener( Event.ADDED_TO_STAGE, init);//
            Wonderfl.capture_delay(60);
        }
        
        private function init( e:Event=null ):void
        {
            removeEventListener( Event.ADDED_TO_STAGE, init);//
            var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener( Event.COMPLETE, onComplete);//
            loader.load( new URLRequest(URL), new LoaderContext(true) );
        }
        
        private function onComplete( e:Event ):void
        {
            e.target.removeEventListener( Event.COMPLETE, onComplete);//
            var bmpd:BitmapData = e.target.content.bitmapData;
            var m:Matrix = new Matrix();
            m.scale( 1/W, 1/H);
            _source = new BitmapData( bmpd.width/W, bmpd.height/H, false, 0x0);
            _source.draw( bmpd, m);
            _source.applyFilter( _source, _source.rect, p, new ColorMatrixFilter([ 0.3, 0.6, 0.1, 0, 0, 0.3, 0.6, 0.1, 0, 0, 0.3, 0.6, 0.1, 0, 0, 0, 0, 0, 1, 0]));
            _canvas = new BitmapData( _source.width*W, _source.height*H, false, 0x0);
            addChild( new Bitmap(_canvas) );
            setup();//
            addEventListener( Event.ENTER_FRAME, update);
        }
        
        private function update( e:Event ):void
        {
            plot();
            plot();
            plot();
            plot();
            plot();
        }

        private function plot():void
        {
            var m:Matrix = new Matrix();
            m.translate( p.x*W, p.y*H);
            _canvas.draw( _blocks[ brightness(p) ], m);
            if( ++p.x > _source.width ){
                p.x = 0;
                if( ++p.y > _source.height ){
                    removeEventListener( Event.ENTER_FRAME, update);//
                    return;
                }
            } 
        }

        private function brightness( _p:Point ):uint
        {
            var c:uint = _source.getPixel( _p.x, _p.y) & 0xFF;
            return (c/(51.2) | 0);
        }
        
        private function setup():void
        {
            _blocks = [];
            _blocks[0] = block( [0x1a1a1a, 0x595959, 0x3c3c3c, 0x333333, 0x000000, 0x000000, 0x3c3c3c, 0x080808] );
            _blocks[1] = block( [0x4d4d4d, 0x8d8d8d, 0x717171, 0x585858, 0x2e2e2e, 0x1c1c1c, 0x7a7a7a, 0x2e2e2e] );
            _blocks[2] = block( [0x808080, 0xd1d1d1, 0xb3b3b3, 0x9b9b9b, 0x595959, 0x3e3e3e, 0xa6a6a6, 0x595959] );
            _blocks[3] = block( [0xb3b3b3, 0xececec, 0xd9d9d9, 0xc7c7c7, 0x8f8f8f, 0x727272, 0xd9d9d9, 0x7d7d7d] );
            _blocks[4] = block( [0xe6e6e6, 0xf9f9f9, 0xf3f3f3, 0xe2e2e2, 0xc4c4c4, 0xa7a7a7, 0xffffff, 0xb8b8b8] );
        }
        
        private function block( _ary:Array ):BitmapData
        {
            var s:Shape = new Shape();
            var g:Graphics = s.graphics;
            g.beginFill(_ary[0]);
            g.drawRect( 0, 0, 10, 10);
            g.beginFill(_ary[1]);
            g.drawRect( 0, 0, 1, 1);
            g.beginFill(_ary[2]);
            g.drawRect( 1, 0, 8, 1);
            g.drawRect( 0, 1, 1, 8);
            g.beginFill(_ary[3]);
            g.drawRect( 9, 0, 1, 1);
            g.drawRect( 0, 9, 1, 1);
            g.beginFill(_ary[4]);
            g.drawRect( 9, 1, 1, 8);
            g.drawRect( 1, 9, 8, 1);
            g.beginFill(_ary[5]);
            g.drawRect( 9, 9, 1, 1);
            g.beginFill(_ary[6]);
            g.drawRect( 4, 2, 2, 1);
            g.drawRect( 3, 3, 1, 1);
            g.drawRect( 6, 3, 1, 1);
            g.drawRect( 2, 4, 1, 2);
            g.beginFill(_ary[7]);
            g.drawRect( 7, 4, 1, 2);
            g.drawRect( 3, 6, 1, 1);
            g.drawRect( 6, 6, 1, 1);
            g.drawRect( 4, 7, 2, 1);
            var bmpd:BitmapData = new BitmapData( W, H, false, 0xFFFFFF);
            bmpd.draw( s );
            return bmpd;
        }
    
    }
}