/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6362
 */

package {
    import flash.ui.Keyboard;
    import flash.events.KeyboardEvent;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
           vecRect = new Vector.<xRect>(0,false); 
           vecRect.push(new xRect(0,0,16,16)); 
           vecRect.push(new xRect(0,16,32,16)); 
           vecRect.push(new xRect(32,16,16,16)); 
           vecRect.push(new xRect(48,16,32,16)); 
           vecRect.push(new xRect(32,32,16,16)); 
           vecRect.push(new xRect(48,32,16,32)); 
           vecRect.push(new xRect(0,32,32,32)); 
          
           stage.addEventListener(KeyboardEvent.KEY_DOWN, onKdown);
           stage.addEventListener(KeyboardEvent.KEY_UP, onKup);
           stage.addEventListener(Event.ENTER_FRAME, onEnter); 
        }//ctor
        
        public function onKdown(e:KeyboardEvent):void { vecKey[e.keyCode]=true; }
        public function onKup(e:KeyboardEvent):void { vecKey[e.keyCode]=false; }
        public function isKeyDown(k:int):Boolean { return vecKey[k]; }
        
        public var vecKey:Vector.<Boolean> = new Vector.<Boolean>(512,false);
                
        
        public var cx:Number = 235;
        public var cy:Number = 235;
        
        public var gx:Number = 0;
        public var gy:Number = 0;
        
        public var worldw:Number=256;
        public var worldh:Number=256;
        
        public var camx:Number = 0;
        public var camy:Number = 0;
        
        public var vecRect:Vector.<xRect>;
        
        
        public function getZone(ax:Number, ay:Number):xRect
        {
            var a:xRect; var i:int; var num:int;
            num = vecRect.length;
            for(i=0;i<num;i+=1)
            { a = vecRect[i];  
              if (ax < a.cx){ continue; }
              if (ay < a.cy){ continue; }
              if (ax > a.cx+a.cw){ continue; }
              if (ay > a.cy+a.ch){ continue; }
              return a;
            }//nexti              
            return null;
        }//getrect
        
        public var prevRect:xRect =null;
        
                
        public function onEnter(e:Event):void
        {
            graphics.clear();
            graphics.lineStyle(1, 0);
            
            var a:xRect; var i:int; var num:int;
            num = vecRect.length;
            for(i=0;i<num;i+=1)
            { a = vecRect[i];   graphics.drawRect(a.cx,a.cy,a.cw,a.ch); }  
            
            graphics.drawRect(0-camx,0-camy,worldw, worldh);
            graphics.drawCircle(cx-camx,cy-camy,16);
            
            camx =cx-235;
            camy =cy-235;
            
            var ax:Number;
            var ay:Number;
            ax = (cx/16)+gx;
            ay = (cy/16)+gy;
            
            graphics.drawCircle(ax,ay,4);
            
            graphics.lineStyle(2,0xFF);
            a = getZone(ax,ay);
            if (a!=null)
            { graphics.drawRect(a.cx,a.cy,a.cw,a.ch); }
      
              
            if (a!=null && a!=prevRect)
            {
              // var ox:Number; var oy:Number;
              // ax = a.cx*16; ay =a.cy*16;
              // ox=cx+ax; oy= cy-ay;
               
               prevRect=a;
//               cx=128;
//               cy=128;

               if (cx<0) { cx+= a.cw*16; }
               else if (cx >worldw){ cx-=worldw; }
               if (cy<0) { cy+= a.ch*16; }
               else if (cy >worldh){ cy-=worldh; }

               worldw = a.cw * 16;
               worldh = a.ch * 16; 
              camx =cx-235;
              camy =cy-235;
               gx=a.cx;
               gy=a.cy; 
               
            }//endif     
      
      
            var ms:Number; ms =8;
            if (isKeyDown(Keyboard.UP)) { cy-=ms; }
            if (isKeyDown(Keyboard.DOWN)) { cy+=ms; }
            if (isKeyDown(Keyboard.LEFT)) { cx-=ms; }
            if (isKeyDown(Keyboard.RIGHT)) { cx+=ms; }
                        
                        
                        
                        
        }//onenter
        
    }//classend
}

internal class xRect
{
  public function xRect(ax:Number,ay:Number,aw:Number,ah:Number)
  { cx=ax; cy=ay; cw=aw; ch=ah;  }  
  public var cx:Number = 0;
  public var cy:Number = 0;   
  public var cw:Number = 0;
  public var ch:Number = 0;
}//xrect