/**
 * Copyright oreore ( http://wonderfl.net/user/oreore )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/62Ix
 */

package  
{
	//flash
	import caurina.transitions.properties.DisplayShortcuts;
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filters.BlurFilter;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	//import ore.graphic.Ball;
	import org.papervision3d.materials.BitmapFileMaterial;
	import org.papervision3d.materials.BitmapMaterial;

	//papervision3D
	import org.papervision3d.materials.ColorMaterial;
	import org.papervision3d.materials.special.CompositeMaterial;
	import org.papervision3d.objects.primitives.Plane;
	import org.papervision3d.cameras.Camera3D;
	import org.papervision3d.scenes.Scene3D;
	import org.papervision3d.render.BasicRenderEngine;
	import org.papervision3d.materials.WireframeMaterial;
	import org.papervision3d.view.BasicView;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.cameras.CameraType;
	import org.papervision3d.events.*;
	import org.papervision3d.core.clipping.FrustumClipping;
	
	//Tweensy
	import com.flashdynamix.utils.SWFProfiler;
	import com.flashdynamix.motion.Tweensy;
	import com.flashdynamix.motion.TweensyGroup;
	import com.flashdynamix.motion.TweensySequence;
	import com.flashdynamix.motion.TweensyTimeline;
	import com.flashdynamix.motion.guides.Bezier2D;
	import com.flashdynamix.motion.guides.Orbit2D;
	import fl.motion.easing.*;
	
	//Tweener
	import caurina.transitions.Tweener;
	
	public class Main extends Sprite
	{
		private var viewPort:BasicView;
		private var plane:Plane;
		private var world:DisplayObject3D;
		private var floor:Plane;
		private var mouse:Sprite;
		private var cameraMaxY:Number;
		private var cameraMaxX:Number;
		private var rot:Number = 180;
		private var camereOffset:Number;
		private var tObj:DisplayObject3D;
		
		public function Main() 
		{
			stage.align = StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			SWFProfiler.init(this);
			init();
		}
		
		private function init():void
		{
			/************************************************************************
			* 1.viewPortを作成
			************************************************************************/
			//カメラをフリーモードにする
			viewPort = new BasicView(stage.stageWidth, stage.stageHeight, true, true, "Free" );
			viewPort.renderer.clipping = new FrustumClipping(FrustumClipping.NEAR);
			addChild(viewPort);
			
			/************************************************************************
			* 2.cameraの設定
			************************************************************************/
			viewPort.camera.y = 500;
			viewPort.camera.target = DisplayObject3D.ZERO;
			
			
			/************************************************************************
			* 3.シーンの中にworldを追加　すでにあるのかも？
			************************************************************************/
			world = new DisplayObject3D();
			viewPort.scene.addChild(world);
			
			/************************************************************************
			* 4.レンダリング
			************************************************************************/
			viewPort.startRendering();
			
			/************************************************************************
			* 5.オブジェクトの作成
			************************************************************************/
			for (var i:int = 0; i < 20; i++) 
			{
				//板を作成
				var planeMate:CompositeMaterial = new CompositeMaterial();
				planeMate.addMaterial(new WireframeMaterial(0x825534));
				planeMate.addMaterial(new ColorMaterial(Math.random()*0x4576a7));
				//planeMate.addMaterial(new BitmapFileMaterial("a.jpg",true));
				planeMate.doubleSided = true;
				planeMate.interactive = true;
				plane = new Plane(planeMate, 200, 300, 1, 1);
				plane.x = Math.random() * 2000 - 1000;
				plane.y = Math.random() * 2000 - 1000;
				plane.z = Math.random() * 2000 - 1000;
				//plane.rotationX = Math.random() * 360;
				plane.rotationY = Math.random() * 360;
				//plane.rotationZ = Math.random() * 360;
				world.addChild(plane);
				
				plane.addEventListener(InteractiveScene3DEvent.OBJECT_CLICK, onClick);
				plane.addEventListener(InteractiveScene3DEvent.OBJECT_OVER, onMouseOver);
				plane.addEventListener(InteractiveScene3DEvent.OBJECT_OUT, onMouseOut);
			}
			
			//床を作成
			var floorMate:CompositeMaterial = new CompositeMaterial();
			floorMate.addMaterial(new WireframeMaterial(0x696969,50));
			floorMate.addMaterial(new ColorMaterial(0xdcdcdc, 0.5));
			floorMate.doubleSided = true;
			floor = new Plane(floorMate, 1000, 1000, 12, 12);
			floor.rotationX = 90;
			world.addChild(floor);
			
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
			
			var ball:Sprite = new Sprite();
			addChild(ball);
			ball.addEventListener(MouseEvent.CLICK, onCameraReset);
			
			
			/************************************************************************
			* マウス
			***********************************************************************/
			mouse = new Sprite();
			mouse.x = stage.stageWidth / 2;
			mouse.y = stage.stageHeight / 2;
			addChild(mouse);
			cameraMaxY = 100 / (stage.stageHeight / 2);
			cameraMaxX= 100 / (stage.stageWidth / 2);
		}
		
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		// buttonModeの切り替え
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		private function onMouseOut(e:InteractiveScene3DEvent):void 
		{
			viewPort.buttonMode = false;
		}
		
		private function onMouseOver(e:InteractiveScene3DEvent):void 
		{
			viewPort.buttonMode = true;
		}
		
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//　worldの回転
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

		
		private function onCameraReset(e:MouseEvent):void 
		{
			Tweensy.to(
				viewPort.camera,
				{
					x:0,
					y:500,
					z: -1000,
					rotationX:0,
					rotationY:0,
					rotationZ:0
				},
				3,
				Elastic.easeOut
			);
			
		}
		
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		// レンダリング
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		private function onEnterFrame(e:Event):void 
		{
			var vx:Number = (mouseX - mouse.x) * 0.1;
			var vy:Number = (mouseY - mouse.y) * 0.1;
			mouse.x += vx;
			mouse.y += vy;
			var nn:Number = (mouseX - (stage.stageWidth / 2)) * cameraMaxX+180;
			rot += (nn - rot) * 0.1;
			//trace(rot);
			//rot++;
			//viewPort.singleRender();
			//world.yaw(1);
			//viewPort.camera.rotationY += 1;
			viewPort.camera.x = 500 * (Math.sin(Math.PI*rot / 180));
            viewPort.camera.z = 500 * (Math.cos(Math.PI * rot / 180));
			viewPort.camera.y += vy;
		}
		
		private function onClick(e:InteractiveScene3DEvent):void 
		{
			removeEventListener(Event.ENTER_FRAME, onEnterFrame2);
			removeEventListener(Event.ENTER_FRAME, onEnterFrame);
			
			mouse.x = stage.stageWidth / 2;
			mouse.y = stage.stageHeight / 2;
			
			viewPort.camera.target = null;
			var _emptyObj3D:DisplayObject3D = new DisplayObject3D();
			camereOffset = viewPort.camera.focus * viewPort.camera.zoom;
			_emptyObj3D.copyTransform(e.displayObject3D);
			_emptyObj3D.moveBackward(camereOffset);

			var timeLine:TweensyTimeline = new TweensyTimeline();
			timeLine = Tweensy.to(
				world, 
				{
						rotationX:0,
						rotationY:0,
						rotationZ:0
				},
				3
			);
			timeLine.onComplete = oreFunc;
			timeLine.onCompleteParams = [e.displayObject3D]
			
			Tweensy.to(
				viewPort.camera,
					{
						x:_emptyObj3D.x,
						y:_emptyObj3D.y,
						z:_emptyObj3D.z,
						rotationX:_emptyObj3D.rotationX,
						rotationY:_emptyObj3D.rotationY,
						rotationZ:_emptyObj3D.rotationZ
						},
					3
			);
			
		}
		
		private function oreFunc(t:DisplayObject3D):void
		{
			viewPort.camera.target = t;
			addEventListener(Event.ENTER_FRAME, onEnterFrame2);
			trace("aaaa");
			//rot = 180;
			rot = 180+t.rotationY;
			tObj = t;
		}
		
		private function onEnterFrame2(e:Event):void 
		{
			var vx:Number = (mouseX - mouse.x) * 0.1;
			var vy:Number = (mouseY - mouse.y) * 0.1;
			mouse.x += vx;
			mouse.y += vy;
			var nn:Number = (mouseX - (stage.stageWidth / 2)) * cameraMaxX+180+tObj.rotationY;
			rot += (nn - rot) * 0.1;
			//world.rotationX = tObj.rotationX;
			//world.rotationY = tObj.rotationY;
			//world.rotationZ = tObj.rotationZ;
			viewPort.camera.x = tObj.x+ camereOffset * (Math.sin(Math.PI*rot / 180));
            viewPort.camera.z = tObj.z + camereOffset * (Math.cos(Math.PI * rot / 180));
			viewPort.camera.y += vy;
		}
		
	}
	
}