/**
 * Copyright yuugurenote ( http://wonderfl.net/user/yuugurenote )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/62DM
 */

package {
    import flamySh.display.Sprite;
    import flamySh.events.Event;
    import flamySh.filters.BlurFilter;
     [mySwF(width=300,height=300,backgroundColor=0x000000,frameRate=60)]
    public class FlamyShTest extends Sprite {
        var mySw:Number = stage.stageWidth;
        var mySh:Number = stage.stageHeight;
        var speedX:Number = Math.random() * 2 + 1;
        var speedY:Number = Math.random() * 2 + 1;
        var myMC:Sprite = new Sprite();
        var radius:Number = myMC.width/2;
        var pt1:Point = new Point(0,0);
        var pt2:Point = new Point(30,30);
        var pt3:Point = new Point(0,30);
        
        public function FlamyShTest() {
            myMC.graphics.lineStyle(3,0xFFFF00,1);
            ｍyMC.graphics.moveTo(pt1.x,pt1.y);
            myMC.graphics.lineTo(pt2.x,pt2.y);
            myMC.graphics.lineTo(pt3.x,pt3.y);
            myMC.graphics.lineTo(pt1.x,pt1.y);
            myMC.x = mySw/2;
            myMC.y = mySh/2;
            myMC.filters = [new BlurFilter(3,3)];
            addChild(myMC);
            myMC.addEventListener(Event.ENTER_FRAME,xEnter);
        }
        function xEnter(e:Event):void {
            myMC.x += speedX;
            myMC.y += speedY;
            myMC.rotation += 3;
    
            if (myMC.x  + radius> mySw){
                myMC.x = mySw - radius;
                speedX = -speedX;
                makeSprite(myMC.x,myMC.y);
            }
    
            if (myMC.x - radius< 0) {
                myMC.x = radius;
                speedX = -speedX;
                makeSprite(myMC.x,myMC.y);
            }    
    
            if (myMC.y + radius>mySh)     {
                myMC.y = mySh - radius;
                speedY = -speedY;
                makeSprite(myMC.x,myMC.y);
            }

            if(myMC.y - radius< 0)  {
                myMC.y = radius;
                speedY = -speedY;
                makeSprite(myMC.x,myMC.y);
            }
}

function makeSprite(px:Number,py:Number):Sprite {
        
    var mySp:Sprite = new Sprite();
    var _px:Number = px;
    var _py:Number = py;
    
    mySp.x = _px;
    mySp.y = _py;
    addChild(mySp);
        
    var mySprite:Sprite = new Sprite();
    stage.addChild(mySprite);
    mySprite.graphics.lineStyle(2,0xFFFF44,1);
    mySprite.graphics.drawCircle(0,0,15);
    mySprite.addEventListener(Event.ENTER_FRAME,xEnter2);
    function xEnter2(e:Event):void {
        mySprite.alpha -= 0.01;
        mySprite.width = mySprite.height += 1;
        if(mySprite.alpha < 0) {
           mySp.removeChild(mySprite);
            mySprite.removeEventListener(Event.ENTER_FRAME,xEnter2);
        }
    }
    mySprite.filters = [new BlurFilter(3,3)];
    mySp.addChild(mySprite);
    return mySprite;
}
        }
    }
