/**
 * Copyright demouth ( http://wonderfl.net/user/demouth )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/624k
 */

/**
 * 自分の割りに短く書く事が出来た。
 * 座標の移動はこんな感じでいいのかな
 */
// forked from nutsu's FShape path draw
package{
    import frocessing.shape.*;
    import flash.display.*;
    import flash.events.*;
    /**
     * 誰かの為の、SVG path要素を順次描画する簡単？な方法 
     */
    [SWF(width=465,height=465,backgroundColor=0,frameRate=30)]
    public class TestShapePathDraw extends Sprite
    {
        private var SVGs:Array = []; //FShape
        private var sp:FShape = new FShape();
        private var commands_tmp:Array = [];
        private var count:int;
        private var ci:int =0;
        private var d:int = 1;
        
        public function TestShapePathDraw() 
        {
            sp.styleEnabled = false;
            for (var i:int = 0; i < 10; i++) this.SVGs.push(FShapeSVG.parsePath( getXmlData(i) ));
            
            this.createShape();
            addEventListener( Event.ENTER_FRAME, enterframe );
        }
        
        private function createShape():void
        {
            //初期化
            commands_tmp = [];
            sp.vertices.splice( 0, sp.vertices.length );
            this.count = 0;
            //時間を求める
            var date:Date = new Date();
            var timeStr:String
                = ((date.hours < 10)?"0":"") + date.hours.toString()
                + ((date.minutes < 10)?"0":"") + date.minutes.toString()
                + ((date.seconds < 10)?"0":"") + date.seconds.toString();
            //Shapeを作る
            for (var i:int = 0; i < timeStr.length; i++) 
            {
                var shape:FShape = this.SVGs[int(timeStr.charAt(i))];
                this.count += shape.commands.length;
                commands_tmp = commands_tmp.concat(shape.commands.slice( 0, shape.commands.length ));
                
                var vertices_tmp:Array = shape.vertices.slice( 0, shape.vertices.length );
                var shiftX:Number = (i > 1)?((i > 3)?110:90):70;
                vertices_tmp = vertices_tmp.map(shift(i*50 + shiftX, 200));
                for (var j:int = 0; j < vertices_tmp.length; j++)
                    this.sp.vertices.push(vertices_tmp[j]);
            }
        }
        
        private function enterframe(e:Event):void 
        {
            if( d>0 ){
                sp.commands.push( commands_tmp[ci] );
                ci++;
                if ( ci >= count )
                    d = -1;
            }else {
                sp.commands.pop();
                ci--;
                if ( ci <= 0 )
                    d = 1;
            }
            graphics.clear();
            graphics.lineStyle( 0, 0x999999 );
            if (ci > 4)
            {
                graphics.drawCircle(175, 220 , 2);
                graphics.drawCircle(175, 240 , 2);
                graphics.drawCircle(295, 220 , 2);
                graphics.drawCircle(295, 240 , 2);
            }
            sp.drawGraphics( graphics );
            if (ci == 0) this.createShape();
        }
        
        private function shift(x:Number , y:Number):Function {
            return function (vertice:Object, index:int, arr:Array):Object {
                return (index % 2) ? vertice + y : vertice + x;
            }
        }
        
        private function getXmlData(number:int):XML {
            var svg:String = "<path d=\"";
            if(number == 0)svg += "M0,31.121C0,10.16,8.16,0,19.36,0c11.36,0,18.32,10.72,18.32,30.321c0,20.8-7.28,31.521-19.2,31.521";
            if(number == 0)svg += "C7.6,61.841,0,51.121,0,31.121z M30.96,30.641c0-14.96-3.6-25.281-12-25.281C11.84,5.36,6.8,14.88,6.8,30.641";
            if(number == 0)svg += "s4.4,25.761,11.92,25.761C27.601,56.401,30.96,44.881,30.96,30.641z";
            if(number == 1)svg += "M11.6,59.921V6.24h-0.16L1.6,11.92L0,6.96L12.4,0h5.68v59.921H11.6z";
            if(number == 2)svg += "M35.441,60.961H0v-4.08l5.84-6.16c14.24-14.4,21.44-23.121,21.44-32.881c0-6.4-2.8-12.32-11.44-12.32";
            if(number == 2)svg += "c-4.8,0-9.12,2.64-12,4.96L1.6,5.84C5.28,2.56,10.72,0,17.121,0c12.08,0,16.88,8.8,16.88,17.041c0,11.28-7.92,20.88-20.32,33.361";
            if(number == 2)svg += "l-4.72,4.96v0.16h26.48V60.961z";
            if(number == 3)svg += "M21.44,28.561c7.04,1.2,13.04,6.88,13.04,15.521c0,9.52-6.88,17.84-20.32,17.84c-6,0-11.44-1.92-14.16-3.84l2-5.12";
            if(number == 3)svg += "c2.16,1.44,6.96,3.6,12.24,3.6c10.08,0,13.36-7.041,13.36-12.561c0-8.8-7.44-12.8-15.28-12.8H8.4v-4.96h3.92";
            if(number == 3)svg += "c5.76,0,13.2-3.6,13.2-11.12c0-5.2-3.12-9.681-10.32-9.681c-4.4,0-8.56,2.16-10.96,3.92l-2-4.88C5.12,2.24,10.72,0,16.48,0";
            if(number == 3)svg += "c10.96,0,15.84,6.96,15.84,14.16c0,6.16-3.92,11.681-10.88,14.161V28.561z";
            if(number == 4)svg += "M32.48,59.921h-6.32v-16.8H0v-4.24L25.601,0h6.88v38.001h8.161v5.12H32.48V59.921z M6.72,38.001h19.44V16.72";
            if(number == 4)svg += "c0-3.28,0.16-6.48,0.32-9.6h-0.32c-1.84,3.68-3.28,6.24-4.8,8.96L6.72,37.841V38.001z";
            if(number == 5)svg += "M33.601,0v5.52H12.08L9.6,22.48c1.28-0.16,2.56-0.32,4.64-0.32c10.64,0,20.161,6.32,20.161,18.4";
            if(number == 5)svg += "c0,11.84-8.8,20.32-20.641,20.32c-6,0-11.04-1.76-13.76-3.52l1.92-5.2c2.24,1.52,6.64,3.36,11.84,3.36";
            if(number == 5)svg += "c7.52,0,14-5.521,13.92-14.161c0-8.24-5.28-14-16.48-14c-3.2,0-5.68,0.24-7.68,0.56L7.28,0H33.601z";
            if(number == 6)svg += "M6.96,29.121c2.72-4,7.6-7.36,14-7.36c10.16,0,16.96,7.601,16.96,19.121c0,10.96-6.72,20.96-18.4,20.96S0,52.161,0,36.641";
            if(number == 6)svg += "C0,20.561,7.52,3.76,26.96,0.56c2.24-0.32,4.24-0.56,5.6-0.56l0.08,5.52C16,5.52,8.08,17.601,6.72,29.121H6.96z M31.201,41.361";
            if(number == 6)svg += "c0-9.2-4.96-14.56-12.16-14.56c-7.041,0-12.4,6.88-12.4,11.36c0.08,10.96,4.72,18.48,13.04,18.48";
            if(number == 6)svg += "C26.641,56.641,31.201,50.401,31.201,41.361z";
            if(number == 7)svg += "M0,0h35.121v4.24L10.08,59.921h-6.8L28.321,5.68V5.52H0V0z";
            if(number == 8)svg += "M11.601,29.121C5.12,26,2.24,20.72,2.24,15.6C2.24,6.32,9.521,0,19.201,0c10.88,0,16.08,7.36,16.08,14.56";
            if(number == 8)svg += "c0,5.12-2.72,10.721-9.84,14.161v0.32c7.36,3.12,11.92,8.48,11.92,15.681c0,10.16-8.32,17.12-18.88,17.12";
            if(number == 8)svg += "C7.041,61.841,0,54.561,0,45.921c0-7.76,4.64-13.36,11.601-16.48V29.121z M30.561,45.441c0-7.52-5.041-11.36-12.96-13.92";
            if(number == 8)svg += "c-7.04,2.32-10.8,7.44-10.8,13.36c0,6.8,4.56,12,11.76,12C26.241,56.881,30.561,51.681,30.561,45.441z M8.561,14.96";
            if(number == 8)svg += "c-0.08,6.4,4.48,9.92,11.12,11.92c5.2-2,9.12-6.08,9.12-11.76c0-5.04-2.8-10.24-9.84-10.24C12,4.88,8.561,9.76,8.561,14.96z";
            if(number == 9)svg += "M30.32,32.561c-3.28,4.16-7.92,6.64-13.76,6.64c-10.24,0-16.56-8-16.56-18.16C0,10.08,7.2,0,18.96,0";
            if(number == 9)svg += "c11.2,0,18.32,9.76,18.32,25.041c0,19.92-10.08,33.761-25.44,36.161c-2.8,0.48-5.36,0.64-7.121,0.56v-5.52";
            if(number == 9)svg += "c1.68,0.16,3.6-0.08,6.16-0.4c10.081-1.44,17.681-9.6,19.681-23.281H30.32z M6.72,20.641c0,8.08,4.56,13.52,11.44,13.52";
            if(number == 9)svg += "c6.48,0,12.4-4.96,12.4-9.76c0-11.52-4.24-19.28-12.16-19.28C11.44,5.12,6.72,11.68,6.72,20.641z";
            svg += "\" />";
            return new XML(svg);
        }
        
    }
    
}