/**
 * Copyright _shimizu ( http://wonderfl.net/user/_shimizu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/61vM
 */

package {
	import flash.filters.BlurFilter;
	import flash.filters.DisplacementMapFilter;
	import flash.geom.ColorTransform;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.events.Event;
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.BitmapDataChannel;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.display.BlendMode;
    
    [SWF(width=465,height=465,backgroundColor=0)]
    public class BitmapDataSample extends Sprite {
    		private var bmpdata:BitmapData;
    		private var sprite:Sprite;
    		private var matrix:Matrix;
    		private var colortrans:ColorTransform;
    		private var bmpcolortrans:ColorTransform;
    		private var filter:DisplacementMapFilter;
    
    
        public function BitmapDataSample() {
        		colortrans = new ColorTransform();
        		bmpcolortrans = new ColorTransform( 0.99, 0.99, 0.999);
        		bmpdata = new BitmapData(465, 465, false, 0);
        		addChild( new Bitmap(bmpdata));
            
            sprite = newFig(0, 0, 40, 0xFFFFFF);
            
            matrix = new Matrix();
            
            addEventListener( Event.ENTER_FRAME, enterframe);
            stage.addEventListener( MouseEvent.CLICK, reset);
            
            
        }
        public function enterframe(e:Event):void{
        		matrix.identity();
        		var s:Number = Math.random() * 2;
        		matrix.scale(s, s);
        		matrix.rotate( Math.PI * Math.random());
        		matrix.translate(mouseX, mouseY);
        		colortrans.greenMultiplier = mouseX / 465;
        		colortrans.blueMultiplier = mouseY / 465;
        		colortrans.alphaMultiplier = Math.random();
        		bmpdata.colorTransform( bmpdata.rect, bmpcolortrans);


        		
        		var mapBitmap:BitmapData = new BitmapData(465, 465, false, 0);
        		var mapPoint:Point = mapBitmap.rect.topLeft;
        		var componentX:uint = BitmapDataChannel.RED;
        		var componentY:uint = BitmapDataChannel.GREEN;
        		var scaleX:Number = 256;
        		var scaleY:Number = 256;
        		var r:uint = 128 + 2;
        		var g:uint = 128 + 1;
        		var b:uint = 128;
        		var col:uint = r << 16 | g << 8 | b;
        		mapBitmap.fillRect( mapBitmap.rect, col);
        		filter = new DisplacementMapFilter( mapBitmap, mapPoint, componentX,  componentY, scaleX, scaleY);
        		bmpdata.applyFilter( bmpdata, bmpdata.rect, bmpdata.rect.topLeft, filter);
        		bmpdata.draw( sprite, matrix, colortrans, BlendMode.SCREEN);
        		
        }
        public function reset(e:MouseEvent):void{
        		bmpdata.fillRect( bmpdata.rect, 0x000000);
        }
        
        public function newFig(cx:Number, cy:Number, size:Number, col:uint):Sprite{
        		var shape:Sprite = new Sprite();
        		shape.graphics.lineStyle(0, 0x000000, 0.3);
        		shape.graphics.beginFill( col );
        		shape.graphics.drawCircle(cx, cy, size*0.5);
        		shape.graphics.drawCircle(cx, cy, size*0.4);
        		var w:Number = size * 0.6;
        		var h:Number = size * 0.15;
        		shape.graphics.drawRect( cx - w/2, cy - h/2, w, h);
        		shape.graphics.endFill();
        		return shape;     
        }
    }
}