/**
 * Copyright siouxcitizen ( http://wonderfl.net/user/siouxcitizen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/61OM
 */

// forked from siouxcitizen's 前回ソースからステージ選択機能を追加してみました
//前回ソースからの微修正いろいろ、ポーズボタン追加など行いました
//たぶん正常に動いているはず。。。　ソースの整理整頓はそのうちいつかきっと。。。
//報酬機能は次回に実装予定です
package {
    import flash.display.*;
    import flash.events.*;
    import flash.text.*;
    import flash.filters.GlowFilter;
    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.objects.primitives.Cube;
    import org.papervision3d.objects.primitives.Cylinder;
    import org.papervision3d.objects.primitives.Cone;
    import org.papervision3d.objects.primitives.Sphere;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.special.ParticleField;
    import org.papervision3d.objects.parsers.DAE;
    import org.papervision3d.materials.WireframeMaterial;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.materials.special.Letter3DMaterial;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.materials.special.ParticleMaterial;
    import org.papervision3d.typography.Text3D;
    import org.papervision3d.typography.fonts.HelveticaBold;
    import org.papervision3d.core.geom.renderables.Particle;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.events.InteractiveScene3DEvent;
    import flash.events.TimerEvent;  
    import flash.utils.Timer;  
    [SWF(width="500", height="500", backgroundColor="#0055FF")]
    public class Spring extends Sprite {
        private var goLandScrnBtn : SimpleButton; //ランド画面への遷移ボタン 
        private var goTitleScrnBtn : SimpleButton; //タイトル画面への遷移ボタン
        private var goBattleScrnBtn : SimpleButton; //バトル画面への遷移ボタン
        private var goLandScrnFromBattleScrnBtn : SimpleButton; //バトル画面からランド画面への遷移ボタン
        private var battleScrnStartBtn : SimpleButton; //バトル画面のスタート(ポーズ)機能ボタン
        private var hanasuBtn : SimpleButton; //「はなす」ボタン
        private var stageSelectionBtn : SimpleButton; //「ステージ選択」ボタン
        private var forwardBtn : SimpleButton; //前進ボタン
        private var leftRotBtn : SimpleButton; //左回転ボタン
        private var rightRotBtn : SimpleButton; //右回転ボタン
        private var backwardBtn : SimpleButton; //後退ボタン
        private var bDashBtn : SimpleButton;//Bダッシュボタン
        private var forwardState : Boolean = false; //操作矢印「前進」制御用
        private var backwardState : Boolean = false; //操作矢印「後退」制御用
        private var bDashState : Boolean = false; //操作矢印「Bダッシュ」制御用
        private var leftRotState : Boolean = false; //操作矢印「左回転」制御用
        private var rightRotState : Boolean = false; //操作矢印「右回転」制御用
        //ふきだし用
        private var fukidashiState : Boolean = false; //ふきだし制御用
        private var fukiContena : Sprite = new Sprite(); //ふきだし入れ物
        private var fuki : Shape = new Shape(); //描画
        private var onfuki : Shape = new Shape(); //中の形
        private var stage1Btn : SimpleButton; //ステージ1への遷移ボタン
        private var stage2Btn : SimpleButton; //ステージ2への遷移ボタン
        private var stage3Btn : SimpleButton; //ステージ3への遷移ボタン
        private var stage4Btn : SimpleButton; //ステージ4への遷移ボタン
        private var stage5Btn : SimpleButton; //ステージ5への遷移ボタン
        private var stage6Btn : SimpleButton; //ステージ6への遷移ボタン
        private var stage7Btn : SimpleButton; //ステージ7への遷移ボタン
        private var stage8Btn : SimpleButton; //ステージ8への遷移ボタン
        private var stage9Btn : SimpleButton; //ステージ9への遷移ボタン
        private var stage10Btn : SimpleButton; //ステージ10への遷移ボタン
        private var stage11Btn : SimpleButton; //ステージ11への遷移ボタン
        private var stage12Btn : SimpleButton; //ステージ12への遷移ボタン
        private var stage13Btn : SimpleButton; //ステージ13への遷移ボタン
        private var stage14Btn : SimpleButton; //ステージ14への遷移ボタン
        private var stage15Btn : SimpleButton; //ステージ15への遷移ボタン
        private var screenId : int = 0;  //0:クエスト画面 1:ランド画面 2:バトル画面 
        private const TITLE_SCREEN_ID : int = 0;  //クエスト画面ID
        private const LAND_SCREEN_ID : int = 1;  //ランド画面ID
        private const BATTLE_SCREEN_ID : int = 2;  //バトル画面ID
        private var txtField:Object=new Object(); //テキストフィールド用
        private var txtFormat:Object=new Object();//テキストフォーマット用
        //3D表示用
        private var Objs : Object = new Object(); //3Dオブジェクト保持用
        private var container : Sprite;
        private var viewport : Viewport3D;
        private var scene : Scene3D;
        private var camera : Camera3D;
        private var material : ColorMaterial;
        private var planeObj : Plane; 
        private var crystalBoxCube : Cube; //透明キューブ　飾り用クリスタル役
        private var moonSphere : Sphere; //月スフェア
        private var renderer : BasicRenderEngine;
        private var materialList : MaterialsList = new MaterialsList();
        private var cameraPitch: int = 90; //カメラのX軸回転の値　
        private var cameraYaw : int = 270; //カメラのY軸回転の値　
        private var cameraDistStat: int = 1; //カメラ設置場所の距離種類　0～2
        private var title3DText : Text3D //タイトル3D文字
        private var letterformat : Letter3DMaterial; //タイトル3D文字フォーマット
        private var tempPlaneName : String;
        private var wireFramMate : WireframeMaterial;
        private var planeStage : Plane; //バトル画面土台となるPlaneオブジェクト
        private var PLANE_STAGE_SIZE : int = 4000; //バトル画面土台となるPlaneオブジェクト1辺の長さ
        private var daeNomaneko : DAE; //操作「のまねこ」用DAE
        private var daeVillagerNomaneko : DAE; //のま村村町「のまねこ」用DAE
        //バトル画面用要素
        private var attackPow : int = 1; //人型操作オブジェクトの攻撃力
        private var enemy : Enemy;
        private var enemyArray : Array = new Array(); //敵用配列
        private var bulletArray : Array = new Array(); //弾丸用配列
        private const BULLET_NUM : int = 5; //最大弾丸表示数
        private var gameOver : Boolean = false;
        private var stageClear : Boolean = false;
        private var stageNo : int = 1;
        private var battleScrnPoseState : Boolean = false; //trueでポーズ状　態falseでポーズ解除状態　「スタート」ボタンで変更
        private var battleScrnFirstTime : Boolean = true; //
        public function Spring() {
            //情報表示用テキストフィールドを初期化
            txtFieldInit();
            //ふきだし表示用機能を初期化
            initFukidashiDispObj();
            //3D空間を初期化
            init3DSpace();
            //タイトル画面ボタンを初期化
            initTitleScrnBtn();
            //ランド画面ボタンを初期化
            initLandScrnBtn();
            //バトル画面ボタンを初期化
            initBattleScrnBtn();
        }
        //テキストフィールドの初期化処理
        private function txtFieldInit():void{
            //テキストフィールド(ラベル)の生成
            txtField["titleScrnInfo"]=Util.makeTxtField(10,10,10,10);//タイトル画面表示用のテキストを設定
            txtField["landScrnInfo"]=Util.makeTxtField(10,10,300,40);//ランド画面表示用のテキストを設定
            txtField["battleScrnInfo"]=Util.makeTxtField(10,10,300,40);//レッド画面表示用のテキストを設定
            txtField["fukidashi"]=Util.makeTxtField(10,10,450,150);//ふきだし用のテキストを設定
            txtField["stageInfo"]=Util.makeTxtField(340,10,100,170);//ステージ選択ふきだし用のテキストを設定
            //テキストフォーマットの生成
            txtFormat["titleScrnInfo"]=Util.makeTextFormat(15,0x000000);
            txtFormat["landScrnInfo"]=Util.makeTextFormat(15,0x000000);
            txtFormat["battleScrnInfo"]=Util.makeTextFormat(15,0x000000);
            txtFormat["fukidashi"]=Util.makeTextFormat(15,0x000000);
            txtFormat["stageInfo"]=Util.makeTextFormat(13,0xFFFFFF);
        }
        //ふきだし表示用オブジェクトの初期化処理
        private function initFukidashiDispObj():void{
            //ふきだし入れ物
            fukiContena.x = 20;
            fukiContena.y = 20;
            //ふきだし描画
            fuki.graphics.beginFill(0x333333, 1.0);
            fuki.graphics.drawRoundRect(0, 0, 450+10, 150 + 10 * 2, 10, 10);
            fuki.graphics.endFill();
            //ふきだし中の形
            onfuki.graphics.beginFill(0xeeeeee, 1.0);
            onfuki.graphics.drawRoundRect(0, 0, 450, 150 + 10 , 10, 10);
            onfuki.x = onfuki.y = 10 / 2;
            //ステージ選択ふきだし用ボタンを初期化
            stage1Btn = new CustomButton("ステージ1",1);
            stage1Btn.x = 10;
            stage1Btn.y = 15;
            stage1Btn.addEventListener(MouseEvent.MOUSE_UP,goBattleScrnBtnDown);
            stage1Btn.addEventListener(MouseEvent.MOUSE_OVER,overStageSelectionBtn);
            stage2Btn = new CustomButton("ステージ2",2);
            stage2Btn.x = 120;
            stage2Btn.y = 15;
            stage2Btn.addEventListener(MouseEvent.MOUSE_UP,goBattleScrnBtnDown);
            stage2Btn.addEventListener(MouseEvent.MOUSE_OVER,overStageSelectionBtn);
            stage3Btn = new CustomButton("ステージ3",3);
            stage3Btn.x = 230;
            stage3Btn.y = 15;
            stage3Btn.addEventListener(MouseEvent.MOUSE_UP,goBattleScrnBtnDown);
            stage3Btn.addEventListener(MouseEvent.MOUSE_OVER,overStageSelectionBtn);
            stage4Btn = new CustomButton("ステージ4",4);
            stage4Btn.x = 10;
            stage4Btn.y = 45;
            stage4Btn.addEventListener(MouseEvent.MOUSE_UP,goBattleScrnBtnDown);
            stage4Btn.addEventListener(MouseEvent.MOUSE_OVER,overStageSelectionBtn);
            stage5Btn = new CustomButton("ステージ5",5);
            stage5Btn.x = 120;
            stage5Btn.y = 45;
            stage5Btn.addEventListener(MouseEvent.MOUSE_UP,goBattleScrnBtnDown);
            stage5Btn.addEventListener(MouseEvent.MOUSE_OVER,overStageSelectionBtn);
            stage6Btn = new CustomButton("ステージ6",6);
            stage6Btn.x = 230;
            stage6Btn.y = 45;
            stage6Btn.addEventListener(MouseEvent.MOUSE_UP,goBattleScrnBtnDown);
            stage6Btn.addEventListener(MouseEvent.MOUSE_OVER,overStageSelectionBtn);
            stage7Btn = new CustomButton("ステージ7",7);
            stage7Btn.x = 10;
            stage7Btn.y = 75;
            stage7Btn.addEventListener(MouseEvent.MOUSE_UP,goBattleScrnBtnDown);
            stage7Btn.addEventListener(MouseEvent.MOUSE_OVER,overStageSelectionBtn);
            stage8Btn = new CustomButton("ステージ8",8);
            stage8Btn.x = 120;
            stage8Btn.y = 75;
            stage8Btn.addEventListener(MouseEvent.MOUSE_UP,goBattleScrnBtnDown);
            stage8Btn.addEventListener(MouseEvent.MOUSE_OVER,overStageSelectionBtn);
            stage9Btn = new CustomButton("ステージ9",9);
            stage9Btn.x = 230;
            stage9Btn.y = 75;
            stage9Btn.addEventListener(MouseEvent.MOUSE_UP,goBattleScrnBtnDown);
            stage9Btn.addEventListener(MouseEvent.MOUSE_OVER,overStageSelectionBtn);
            stage10Btn = new CustomButton("ステージ10",10);
            stage10Btn.x = 10;
            stage10Btn.y = 105;
            stage10Btn.addEventListener(MouseEvent.MOUSE_UP,goBattleScrnBtnDown);
            stage10Btn.addEventListener(MouseEvent.MOUSE_OVER,overStageSelectionBtn);
            stage11Btn = new CustomButton("ステージ11",11);
            stage11Btn.x = 120;
            stage11Btn.y = 105;
            stage11Btn.addEventListener(MouseEvent.MOUSE_UP,goBattleScrnBtnDown);
            stage11Btn.addEventListener(MouseEvent.MOUSE_OVER,overStageSelectionBtn);
            stage12Btn = new CustomButton("ステージ12",12);
            stage12Btn.x = 230;
            stage12Btn.y = 105;
            stage12Btn.addEventListener(MouseEvent.MOUSE_UP,goBattleScrnBtnDown);
            stage12Btn.addEventListener(MouseEvent.MOUSE_OVER,overStageSelectionBtn);
            stage13Btn = new CustomButton("ステージ13",13);
            stage13Btn.x = 10;
            stage13Btn.y = 135;
            stage13Btn.addEventListener(MouseEvent.MOUSE_UP,goBattleScrnBtnDown);
            stage13Btn.addEventListener(MouseEvent.MOUSE_OVER,overStageSelectionBtn);
            stage14Btn = new CustomButton("ステージ14",14);
            stage14Btn.x = 120;
            stage14Btn.y = 135;
            stage14Btn.addEventListener(MouseEvent.MOUSE_UP,goBattleScrnBtnDown);
            stage14Btn.addEventListener(MouseEvent.MOUSE_OVER,overStageSelectionBtn);
            stage15Btn = new CustomButton("ステージ15",15);
            stage15Btn.x = 230;
            stage15Btn.y = 135;
            stage15Btn.addEventListener(MouseEvent.MOUSE_UP,goBattleScrnBtnDown);
            stage15Btn.addEventListener(MouseEvent.MOUSE_OVER,overStageSelectionBtn);
        }
        //テキストフィールドの編集
        private function editLabel(key:String,text:String):void {
            txtField[key].text=text;
            txtField[key].setTextFormat(txtFormat[key]);        
        }
        //タイトル画面情報テキストを設定
        public function addTitleScrnTxt():void {
            addChild(txtField["titleScrnInfo"]); //タイトル画面のテキストを表示(今回は使用せず)
            editLabel("titleScrnInfo", "");
        }
        //タイトル画面情報テキストの設定解除
        public function removeTitleScrnTxt():void {
            editLabel("titleScrnInfo", "");
            removeChild(txtField["titleScrnInfo"]); //タイトル画面のテキストを非表示(今回は使用せず)
        }
        //ランド画面情報テキストを設定
        private function addLandScrnTxt():void {
            addChild(txtField["landScrnInfo"]);
            var landScrnInfoTxt : String = "A,W,S,D,F,Rボタンで視点変更します" + "\n";
            editLabel("landScrnInfo",landScrnInfoTxt);
        }
        //ランド画面情報テキストの設定解除
        private function removeLandScrnTxt():void {
            editLabel("landScrnInfo", "");
            removeChild(txtField["landScrnInfo"]);
        }
        //バトル画面情報テキストを設定
        private function addBattleScrnTxt():void {
            addChild(txtField["battleScrnInfo"]);
            var battleScrnInfoTxt : String = "バトル画面です" + "\n";
            editLabel("battleScrnInfo",battleScrnInfoTxt);
        }
        //バトル画面情報テキストの設定解除
        private function removeBattleScrnTxt():void {
            editLabel("battleScrnInfo", "");
            removeChild(txtField["battleScrnInfo"]);
        }
//■■■タイトル画面ボタン初期化スタート■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
        //タイトル画面ボタンを初期化する
        public function initTitleScrnBtn():void {
            goLandScrnBtn = new CustomButton("のま村");
            goLandScrnBtn.x = 400;
            goLandScrnBtn.y = 280;
            goLandScrnBtn.addEventListener(MouseEvent.MOUSE_DOWN,goLandScrnBtnDown);
            addChild(goLandScrnBtn);
        }
        //タイトル画面ボタンを非表示にする
        public function hideTitleScrnBtn():void {
            goLandScrnBtn.visible = false;
        }
        //タイトル画面ボタンを表示する
        public function dispTitleScrnBtn():void {
            goLandScrnBtn.visible = true;
        }
//■■■タイトル画面ボタン初期化エンド■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
//■■■ランド画面ボタン初期化スタート■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
        //ランド画面ボタンを初期化する
        public function initLandScrnBtn():void {
            //「ステージ選択」ボタン設定
            stageSelectionBtn = new CustomButton("ステージ選択");
            stageSelectionBtn.x = 400;
            stageSelectionBtn.y = 250;
            stageSelectionBtn.addEventListener(MouseEvent.MOUSE_DOWN,onStageSelectionBtnDown);
            addChild(stageSelectionBtn);
            //「はなす」ボタン設定
            hanasuBtn = new CustomButton("はなす");
            hanasuBtn.x = 400;
            hanasuBtn.y = 310;
            hanasuBtn.addEventListener(MouseEvent.MOUSE_DOWN,onHanasuBtnDown);
            addChild(hanasuBtn);
            //「タイトル画面」ボタン設定
            goTitleScrnBtn = new CustomButton("タイトル画面");
            goTitleScrnBtn.x = 400;
            goTitleScrnBtn.y = 370;
            goTitleScrnBtn.addEventListener(MouseEvent.MOUSE_DOWN,goTitleScrnBtnDown);
            addChild(goTitleScrnBtn);

            forwardBtn = new CustomButton("前進");
            forwardBtn.x = 200;
            forwardBtn.y = 410;
            leftRotBtn = new CustomButton("左回転");
            leftRotBtn.x = 90;
            leftRotBtn.y = 440;
            bDashBtn = new CustomButton("Bダッシュ");
            bDashBtn.x = 200;
            bDashBtn.y = 440;
            rightRotBtn = new CustomButton("右回転");
            rightRotBtn.x = 310;
            rightRotBtn.y = 440;
            backwardBtn = new CustomButton("後退");
            backwardBtn.x = 200;
            backwardBtn.y = 470;
            forwardBtn.addEventListener(MouseEvent.MOUSE_DOWN,onForwardBtnDown);
            forwardBtn.addEventListener(MouseEvent.MOUSE_UP,onForwardBtnUp);
            forwardBtn.addEventListener(MouseEvent.MOUSE_OUT,onForwardBtnOut);
            leftRotBtn.addEventListener(MouseEvent.MOUSE_DOWN,onLeftRotBtnDown);
            leftRotBtn.addEventListener(MouseEvent.MOUSE_UP,onLeftRotBtnUp);
            leftRotBtn.addEventListener(MouseEvent.MOUSE_OUT,onLeftRotBtnOut);
            bDashBtn.addEventListener(MouseEvent.MOUSE_DOWN,onBDashBtnDown);
            bDashBtn.addEventListener(MouseEvent.MOUSE_UP,onBDashBtnUp);
            bDashBtn.addEventListener(MouseEvent.MOUSE_OUT,onBDashBtnOut);
            rightRotBtn.addEventListener(MouseEvent.MOUSE_DOWN,onRightRotBtnDown);
            rightRotBtn.addEventListener(MouseEvent.MOUSE_UP,onRightRotBtnUp);
            rightRotBtn.addEventListener(MouseEvent.MOUSE_OUT,onRightRotBtnOut);
            backwardBtn.addEventListener(MouseEvent.MOUSE_DOWN,onBackwardBtnDown);
            backwardBtn.addEventListener(MouseEvent.MOUSE_UP,onBackwardBtnUp);
            backwardBtn.addEventListener(MouseEvent.MOUSE_OUT,onBackwardBtnOut);
            addChild(forwardBtn);
            addChild(leftRotBtn);
            addChild(bDashBtn);
            addChild(rightRotBtn);
            addChild(backwardBtn);

            //ランド画面に遷移するまでボタンを非表示
            hideLandScrnBtn();
        }
        //ランド画面ボタンを非表示
        private function hideLandScrnBtn():void {
            goTitleScrnBtn.visible = false;
            stageSelectionBtn.visible = false;
            hanasuBtn.visible = false;
            forwardBtn.visible = false;
            leftRotBtn.visible = false;
            rightRotBtn.visible = false;
            backwardBtn.visible = false;
            bDashBtn.visible = false;
        }
        //ランド画面ボタンを再表示
        private function dispLandScrnBtn():void {
            goTitleScrnBtn.visible = true;
            stageSelectionBtn.visible = true;
            hanasuBtn.visible = true;
            forwardBtn.visible = true;
            leftRotBtn.visible = true;
            rightRotBtn.visible = true;
            backwardBtn.visible = true;
            bDashBtn.visible = true;
        }
//■■■ランド画面ボタン初期化エンド■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
//■■■バトル画面ボタン初期化スタート■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
        //バトル画面ボタンを初期化する
        public function initBattleScrnBtn():void {
            //「ランド画面」ボタン設定
            goLandScrnFromBattleScrnBtn = new CustomButton("のま村");
            goLandScrnFromBattleScrnBtn.x = 400;
            goLandScrnFromBattleScrnBtn.y = 280;
            goLandScrnFromBattleScrnBtn.addEventListener(MouseEvent.MOUSE_DOWN,goLandScrnFromBattleScrnBtnDown);
            addChild(goLandScrnFromBattleScrnBtn);

            battleScrnStartBtn = new CustomButton("スタート");
            battleScrnStartBtn.x = 400;
            battleScrnStartBtn.y = 340;
            battleScrnStartBtn.addEventListener(MouseEvent.MOUSE_DOWN,battleScrnStartBtnDown);
            addChild(battleScrnStartBtn);

            //バトル画面に遷移するまでボタンを非表示
            hideBattleScrnBtn();
        }
        //バトル画面ボタンを非表示
        private function hideBattleScrnBtn():void {
            goLandScrnFromBattleScrnBtn.visible = false;
            battleScrnStartBtn.visible = false;
            forwardBtn.visible = false;
            leftRotBtn.visible = false;
            rightRotBtn.visible = false;
            backwardBtn.visible = false;
            bDashBtn.visible = false;
        }
        //バトル画面ボタンを再表示
        private function dispBattleScrnBtn():void {
            goLandScrnFromBattleScrnBtn.visible = true;
            battleScrnStartBtn.visible = true;
            forwardBtn.visible = true;
            leftRotBtn.visible = true;
            rightRotBtn.visible = true;
            backwardBtn.visible = true;
            bDashBtn.visible = true;
        }
//■■■バトル画面ボタン初期化エンド■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
//■■■3D空間を初期化スタート■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
        //3D空間を初期化
        private function init3DSpace():void {
            //ビューポート生成
            viewport = new Viewport3D(500, 500, false, true);
            viewport.opaqueBackground = 0x0055FF;
            addChild(viewport);
            //シーン生成
            scene = new Scene3D();
            //レンダリングエンジン生成
            renderer = new BasicRenderEngine();

             //カメラ設定
            camera = new Camera3D();
            camera.y = 200;
            camera.target = DisplayObject3D.ZERO;

            //タイトル文字の設定　引数は色コード・透過度
            letterformat = new Letter3DMaterial(0xFF9999 , 0.9);
            letterformat.doubleSided = true
            title3DText = new Text3D("3D Practice 06" , new HelveticaBold() , letterformat);
            title3DText.y += 400;
            title3DText.scale = 1;
            Objs["title3DText"] = title3DText;
            scene.addChild(Objs["title3DText"], "title3DText");

            //最初のクエスト画面用に3Dオブジェクト初期化
            var tempBlueColorMaterial : ColorMaterial = new ColorMaterial(0x0000EE, 0.5);
            tempBlueColorMaterial.doubleSided = true;
            var tempRedColorMaterial : ColorMaterial = new ColorMaterial(0xEE0000, 0.5);
            tempRedColorMaterial.doubleSided = true;
            var tempGreenColorMaterial : ColorMaterial = new ColorMaterial(0x00EE00, 0.5);
            tempGreenColorMaterial.doubleSided = true;
            materialList.addMaterial(tempRedColorMaterial, "front");
            materialList.addMaterial(tempBlueColorMaterial, "back");
            materialList.addMaterial(tempGreenColorMaterial, "right");
            materialList.addMaterial(tempBlueColorMaterial, "left");
            materialList.addMaterial(tempRedColorMaterial, "top");
            materialList.addMaterial(tempGreenColorMaterial, "bottom");
            //飾り用3Dクリスタル表示
            crystalBoxCube = new Cube(materialList, 350, 350, 350);
            Objs["crystalBoxCube"] = crystalBoxCube;
            scene.addChild(Objs["crystalBoxCube"], "crystalBoxCube");

            //ランド画面土台Planeオブジェクト設定
            for (var xIndex:int = 0; xIndex < 10; xIndex++){
	        for (var zIndex:int = 0; zIndex < 10; zIndex++){
                    //3DPlaneオブジェクトの設定
                    material = new ColorMaterial( 0x00FF00, 1 );
	            material.doubleSided = true;
	            material.smooth = true;
	            material.interactive = true;  
                    planeObj= new Plane(material, 290, 290, 1, 1); 
	            planeObj.name = "planeX" + xIndex + "_Z" + zIndex;
	            planeObj.x = (300 * xIndex);
	            planeObj.z = 300 * zIndex;
	            planeObj.rotationX += 90;
	            planeObj.name = "green";
	            //Planeオブジェクトに名前を割り振り
	            //7行3列の場合の名前例："planeX7_Z3"
	            tempPlaneName = "planeX" + xIndex + "_Z" + zIndex;
	            Objs[tempPlaneName] = planeObj;
            	}
            }

            //バトル画面土台Plane用ワイヤーフレームマテリアル設定
            wireFramMate = new WireframeMaterial(0x0000FF);
            //バトル画面土台Plane設定
            planeStage= new Plane(wireFramMate, PLANE_STAGE_SIZE, PLANE_STAGE_SIZE, 4, 4);
            planeStage.rotationX = 90;

            //DAEファイルより3D「のまねこ」を読み込み生成
            daeNomaneko = new DAE();
            daeNomaneko.load("http://oretaikan.atukan.com/ActionScript/DaeTest/DaeTest10/nomaNeko.dae");
            daeNomaneko.scale = 50;
            Objs["daeNomaneko"] = daeNomaneko;
            daeVillagerNomaneko = new DAE();
            daeVillagerNomaneko.load("http://oretaikan.atukan.com/ActionScript/DaeTest/DaeTest10/nomaNeko.dae");
            daeVillagerNomaneko.scale = 50;
            Objs["daeVillagerNomaneko"] = daeVillagerNomaneko;

            //マウスイベント処理用リスナを設定
            stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
        }
//■■■3D空間を初期化エンド■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
//■■■イベント処理スタート■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
        //イベント処理
        private function onEnterFrame(e:Event):void{
            if (screenId == TITLE_SCREEN_ID) {
                title3DText.rotationX -= 10;
		crystalBoxCube.rotationX = viewport.mouseY; //飾り用クリスタルの座標をマウス座標から設定
		crystalBoxCube.rotationY = viewport.mouseX; //飾り用クリスタルの座標をマウス座標から設定
                setCameraForTitleScrn(); //カメラ視点設定
                renderer.renderScene(scene, camera, viewport);
            } else if (screenId == LAND_SCREEN_ID) {
                calcNomanekoPos(); //操作用3D「のまねこ」座標を設定
                setCameraForLandScrn(); //カメラ視点設定
                renderer.renderScene(scene, camera, viewport);
            } else if (screenId == BATTLE_SCREEN_ID) {
                if(battleScrnPoseState) {return;}
                calcNomanekoPos(); //操作用3D「のまねこ」座標を設定
                calcEnemy(); //敵Cubeの座標を設定
                calcBullet();
                setCameraForLandScrn(); //カメラ視点設定
                renderer.renderScene(scene, camera, viewport);

                //バトル画面遷移時に最初一回だけ処理を通した後ポーズ状態にする
                if(!battleScrnPoseState && battleScrnFirstTime) {
                    //処理の間隔が早すぎてカメラ計算がおかしなるのでタイマーで適当に調整
                    var timer:Timer = new Timer(50, 1); 
                    timer.addEventListener(TimerEvent.TIMER, timerEnd);
                    timer.start();
                } 
            }
        }
        private function timerEnd(e:TimerEvent):void {
                battleScrnPoseState = true; battleScrnFirstTime = false;
        }

        //ランド画面の操作用3D「のまねこ」座標を設定
        private function calcNomanekoPos():void{
            if (forwardState == true) {//前進
                daeNomaneko.moveForward(-30);
                if(fukidashiState == true) {removeFukidashi();}//ふきだしを非表示
            } else if (backwardState == true) {//後退
                daeNomaneko.moveForward(30);
                if(fukidashiState == true) {removeFukidashi();}//ふきだしを非表示
            } else if (leftRotState == true) {//左回転
                daeNomaneko.rotationY -= 10;
            } else if (rightRotState == true) {//右回転
                daeNomaneko.rotationY += 10;
            } else if (bDashState == true) {//Bダッシュ
                daeNomaneko.moveForward(-60);
                if(fukidashiState == true) {removeFukidashi();}//ふきだしを非表示
            }
        }
        //敵Cubeの処理
        private function calcEnemy():void{
            //enemy.move(daeNomaneko.x,daeNomaneko.z);
            //enemyArray配列内から敵データをとりだして処理を行う
            var enemy : Enemy;
            for (var i : int = 0; i < enemyArray.length; i++) {
                enemy = enemyArray[i];
                enemy.move(daeNomaneko.x,daeNomaneko.z); //敵Cubeに3D「のまねこ」座標を渡して敵Cubeの移動先を計算
                if (enemy.body.hitTestObject(daeNomaneko)) {
                    //editLabel("gameover","GAME OVER");
                    gameOver = true;
                    scene.removeChildByName("daeNomaneko"); //操作オブジェクト3D「のまねこ」を削除
                }
            }
        }
        //タイトル画面用カメラ視点設定
        private function setCameraForTitleScrn():void{
            var cameraDist : int = -1000; //デフォルトの距離、ステータスは1
            camera.x=cameraDist*Math.cos((90-crystalBoxCube.rotationY)*Math.PI/180)+crystalBoxCube.x;  
            camera.z=cameraDist*Math.sin((90-crystalBoxCube.rotationY)*Math.PI/180)+crystalBoxCube.z;
            camera.target.x=crystalBoxCube.x;
            camera.target.y=crystalBoxCube.y;
            camera.target.z=crystalBoxCube.z;
            cameraPitch = 90; //カメラのX軸回転の値　
            cameraYaw = 270; //カメラのY軸回転の値
            camera.orbit(cameraPitch, cameraYaw, true, crystalBoxCube);
        }
        //ランド画面用カメラ視点設定
        private function setCameraForLandScrn():void{
            var cameraDist : int = -1000; //デフォルトの距離、ステータスは1
            if (cameraDistStat == 0) {
                cameraDist = -500;
            } else if (cameraDistStat == 1) {
                cameraDist = -1000;
            } else if (cameraDistStat == 2) {
                cameraDist = -1500;
            }
            camera.x=cameraDist*Math.cos((90-daeNomaneko.rotationY)*Math.PI/180)+daeNomaneko.x;  
            camera.z=cameraDist*Math.sin((90-daeNomaneko.rotationY)*Math.PI/180)+daeNomaneko.z;
            camera.target.x=daeNomaneko.x;
            camera.target.y=daeNomaneko.y;
            camera.target.z=daeNomaneko.z;
            camera.orbit(cameraPitch, cameraYaw, true, daeNomaneko);
        }
        //キーボードイベント処理(押下時処理)
        private function onKeyDown(event:KeyboardEvent):void{
            if (screenId == TITLE_SCREEN_ID) {return;} //タイトル画面の場合は何も処理を行わない
            if (screenId == BATTLE_SCREEN_ID) {//バトル画面時処理
                if (gameOver) {return;} //ゲームオーバー時は何も処理を行わない
                if (battleScrnPoseState) {return;} //ポーズ状態では何も処理を行わない
                if ((event.keyCode == 81) || (event.keyCode == 90)) { //QまたはZボタン押下時「口角砲？」で攻撃
                    attack();
                }
            }

            //Aボタン　操作オブジェクトを中心にカメラを左回り回転(Y軸回転)
            //4度づつ左回り回転
            if (event.keyCode == 65) {
                cameraYaw = cameraYaw - 4;
                if(cameraYaw < 0) {cameraYaw = 360;}
            //Dボタン　操作オブジェクトを中心にカメラを右回り回転(Y軸回転)    
            //4度づつ右回り回転
            } else if (event.keyCode == 68) {
                cameraYaw = cameraYaw + 4;
                if(cameraYaw > 360) {cameraYaw = 0;}
            //Wボタン　操作オブジェクトを中心にカメラを上下移動(X軸回転)
            } else if (event.keyCode == 87) {        
                if(cameraPitch > 50) {cameraPitch = cameraPitch - 10;}
            //Sボタン　操作オブジェクトを中心にカメラを上下移動(X軸回転)
            } else if (event.keyCode == 83) {           
                if(cameraPitch < 100) {cameraPitch = cameraPitch + 10;}
            //Fボタン　カメラと操作オブジェクトの距離を変更
            } else if (event.keyCode == 70) {
                cameraDistStat -= 1;
                if(cameraDistStat < 0) {cameraDistStat = 2;}
            //Rボタン　カメラの初期化　カメラの距離と高さを初期状態に設定＆操作矢印の真後ろに設定
            } else if (event.keyCode == 82) {
                cameraDistStat = 1;
                cameraPitch = 80; //カメラのX軸回転の値　
                cameraYaw = 90 - daeNomaneko.rotationY;
            }
        }
        //QまたはZボタン押下時に攻撃用の弾丸を発射
        private function attack():void{
            //Shpereによる攻撃用の弾丸を生成
            //画面内に最大5発の弾丸を表示
            if (bulletArray.length < BULLET_NUM) {
                var bullet : Bullet = new Bullet(
                                daeNomaneko.rotationY + 180,
                                daeNomaneko.x,
                                daeNomaneko.z);
                bulletArray.push(bullet);
                scene.addChild(bullet.body);
            }            
        }
        //発射された弾丸の処理
        private function calcBullet():void{
            //bulleArray配列内から弾丸をとりだして処理を行う
            var bullet : Bullet;
            for (var i : int = 0; i < bulletArray.length; i++) {
                bullet = bulletArray[i];
                bullet.move(); //弾丸の移動処理
                //土台となるPlaneオブジェクトの範囲より外に出た弾丸は削除
                //Planeオブジェクトのサイズを元に範囲指定
                if (bullet.boundaryCheck(PLANE_STAGE_SIZE/2)) {
                    scene.removeChild(bullet.body);
                    bulletArray.splice(i,1);
                    i--;
                    continue;
                }
                //弾丸と攻撃対象敵Cubeの当たり判定を行う
                //弾丸と衝突した攻撃対象敵Cubeは削除
                var enemy : Enemy;
                for (var j : int = 0; j < enemyArray.length; j++) {
                    enemy = enemyArray[j];
                    //弾丸が敵Cubeと衝突時、弾丸を削除　
                    //攻撃力にあわせて敵Cubeの体力も減らす(isCollisionメソッド内で処理)
                    if (enemy.isCollision(
                        bullet.getLeftPosX(),bullet.getRightPosX(),bullet.getFrontPosZ(),bullet.getBackPosZ(),attackPow)) {
                        scene.removeChild(bullet.body);
                        bulletArray.splice(i,1);
                        i--;
                        //collisionSE.play(); //衝突時効果音を鳴らす
                        //敵Cube体力がなくなったときは敵Ｃｕｂｅ削除
                        if (!enemy.isAlive()) {
                            scene.removeChild(enemy.body);
                            enemyArray.splice(j,1);
                            j--;
                            //敵Cube全て削除時はステージクリア
                            if (enemyArray.length < 1) {
                                //editLabel("stageclear","STAGE"+stageNo+" CLEAR");
                                stageClear = true;
                                break;                           
                            }                            
                        }
                    }
                }
            }
        }
        //弾丸用配列の初期化
        private function initBulleyArray():void{
            var bullet : Bullet;
            for (var i : int = 0; i < bulletArray.length; i++) {
                bullet = bulletArray[i];
                scene.removeChild(bullet.body);
                bulletArray.splice(i,1);
                i--;
           }          
        }
        //敵配列の初期化
        private function initEnemyArray():void{
            var enemy : Enemy;
            for (var i : int = 0; i < enemyArray.length; i++) {
                enemy = enemyArray[i];
                scene.removeChild(enemy.body);
                enemyArray.splice(i,1);
                i--;
           }          
        }
        //ふきだしを非表示
        private function removeFukidashi():void {
            removeChild(fukiContena);
            fukidashiState = false;
        }
//■■■イベント処理エンド■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
//■■■ボタン処理スタート■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
//■■■画面遷移ボタン処理スタート■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
//■■■タイトル画面←→ランド画面　遷移処理スタート■■■■■■■■■■■■■■■■■■
        //タイトル画面からランド画面に遷移
        private function goLandScrnBtnDown(evt:MouseEvent):void {
            hideTitleScrnBtn(); //タイトル画面ボタンを非表示
            dispLandScrnBtn(); //ランド画面ボタンを表示

            //3Dオブジェクト表示・非表示処理
            removeTitleScrn3DObjs();
            addLandScrn3DObjs();

            addLandScrnTxt(); //ランド画面情報テキストを設定

            //スクリーンID設定
            screenId = LAND_SCREEN_ID;

            //ランド画面用のカメラ初期設定
            cameraDistStat = 1;
            cameraPitch = 80;
        }
        //ランド画面からタイトル画面に遷移
        private function goTitleScrnBtnDown(evt:MouseEvent):void {
            if(fukidashiState == true) {removeFukidashi();}//ふきだしを非表示
            hideLandScrnBtn(); //ランド画面ボタンを非表示
            dispTitleScrnBtn(); //タイトル画面ボタンを表示

            //3Dオブジェクト表示・非表示処理
            removeLandScrn3DObjs();
            addTitleScrn3DObjs();

            removeLandScrnTxt(); //ランド画面情報テキストを設定解除

            //スクリーンID設定
            screenId = TITLE_SCREEN_ID;
        }
        //タイトル画面に3Dオブジェクトをセット
        private function addTitleScrn3DObjs():void {
            scene.addChild(Objs["title3DText"], "title3DText");
            scene.addChild(Objs["crystalBoxCube"], "crystalBoxCube");
        }
        //タイトル画面の3Dオブジェクトをリリース
        private function removeTitleScrn3DObjs():void {
            scene.removeChildByName("title3DText");
            scene.removeChildByName("crystalBoxCube");
        }
        //ランド画面に3Dオブジェクトをセット
        private function addLandScrn3DObjs():void {
            for (var xIndex:int = 0; xIndex < 10; xIndex++){
	        for (var zIndex:int = 0; zIndex < 10; zIndex++){
                    //3DPlaneオブジェクトを取り出す
	            //Planeオブジェクト取り出し用の名前を作成  7行3列の場合の名前例："planeX7_Z3" 
                    tempPlaneName = "planeX" + xIndex + "_Z" + zIndex;
  	            scene.addChild(Objs[tempPlaneName], tempPlaneName);
            	}
            }
            //操作「のまねこ」を初期化
            daeNomaneko = Objs["daeNomaneko"];
            daeNomaneko.y = 180;
            daeNomaneko.x = 1350; 
            daeNomaneko.z = 1350;
            daeNomaneko.rotationY = 180;
            scene.addChild(daeNomaneko, "daeNomaneko");
            //村民「のまねこ」(北)を初期化
            daeVillagerNomaneko = Objs["daeVillagerNomaneko"];
            daeVillagerNomaneko.y = 180;
            daeVillagerNomaneko.x = 1350; 
            daeVillagerNomaneko.z = 2700;
            daeVillagerNomaneko.rotationY = 0;
            scene.addChild(daeVillagerNomaneko, "daeVillagerNomaneko");
        }
        //ランド画面から3Dオブジェクトをリリース
        private function removeLandScrn3DObjs():void {
            //ランドマップ配列1行分の処理
            for (var xIndex:int = 0; xIndex < 10; xIndex++){
                //配列1行分の10列のデータを処理
	        for (var zIndex:int = 0; zIndex < 10; zIndex++){
                    //3DPlaneオブジェクトをリリース
                    tempPlaneName = "planeX" + xIndex + "_Z" + zIndex;
                    scene.removeChildByName(tempPlaneName);
            	}
            }
            scene.removeChildByName("daeNomaneko");
            scene.removeChildByName("daeVillagerNomaneko");
        }
//■■■タイトル画面←→ランド画面　遷移処理エンド■■■■■■■■■■■■■■■■■■
//■■■ランド画面←→バトル画面　遷移処理スタート■■■■■■■■■■■■■■■■■■
        //ランド画面からバトル画面に遷移
        private function goBattleScrnBtnDown(evt:MouseEvent):void {
            if(fukidashiState == true) {removeFukidashi();}//ふきだしを非表示

            var target : CustomButton;
            target = CustomButton(evt.currentTarget);
            stageNo = target.getBtnNo();

            hideLandScrnBtn(); //ランド画面ボタンを非表示
            dispBattleScrnBtn(); //バトル画面ボタンを表示

            //3Dオブジェクト表示・非表示処理
            removeLandScrn3DObjs();
            addBattleScrn3DObjs();

            removeLandScrnTxt(); //ランド画面情報テキストを設定解除
            addBattleScrnTxt(); //バトル画面情報テキストを設定

            //スクリーンID設定
            screenId = BATTLE_SCREEN_ID;

            //カメラ初期設定
            cameraDistStat = 1;
            cameraPitch = 80;
            cameraYaw = 270; //カメラのY軸回転の値

            battleScrnPoseState = false;
            battleScrnFirstTime = true;
        }

        //バトル画面からランド画面に遷移
        private function goLandScrnFromBattleScrnBtnDown(evt:MouseEvent):void {
            if(fukidashiState == true) {removeFukidashi();}//ふきだしを非表示
            hideBattleScrnBtn(); //バトル画面ボタンを非表示
            dispLandScrnBtn(); //ランド画面ボタンを表示

            //3Dオブジェクト表示・非表示処理
            removeBattleScrn3DObjs();
            addLandScrn3DObjs();

            removeBattleScrnTxt(); //バトル画面情報テキストを設定解除
            addLandScrnTxt(); //ランド画面情報テキストを設定

            //スクリーンID設定
            screenId = LAND_SCREEN_ID;

            //カメラ初期設定
            cameraDistStat = 1;
            cameraPitch = 80;
            cameraYaw = 270; //カメラのY軸回転の値
        }
        //バトル画面に3Dオブジェクトをセット
        private function addBattleScrn3DObjs():void {
            viewport.opaqueBackground = 0x111111; //背景を黒に変更
            //バトル画面土台Planeオブジェクト表示
            scene.addChild(planeStage);

            daeNomaneko = Objs["daeNomaneko"];
            //操作「のまねこ」を初期化
            daeNomaneko.y = 180;
            daeNomaneko.x = 0; 
            daeNomaneko.z = -2000;
            daeNomaneko.rotationY = 180;
            scene.addChild(daeNomaneko, "daeNomaneko");

            gameOver = false; //ゲームオーバー状態を初期化
            stageClear = false; //ゲームクリアー状態を初期化
            //体力３＆速度4(デフォルト)で敵Cubeを1体生成
            if (stageNo == 1) {
                enemy =  new Enemy(new MaterialsList({all:new ColorMaterial(0x0000FF)}),0,230,2000,3);
                enemyArray.push(enemy);
                scene.addChild(enemy.body);
            } else if (stageNo == 2) {
                //体力３＆速度4(デフォルト)で敵Cubeを2体生成
                //1体目生成
                enemy = new Enemy(new MaterialsList({all:new ColorMaterial(0x0000FF)}),0,230,1800,3);
                enemyArray.push(enemy)
                scene.addChild(enemy.body)
                //2体目生成
                enemy = new Enemy(new MaterialsList({all:new ColorMaterial(0x0000FF)}),-1800,230,1800,3);
                enemyArray.push(enemy)
                scene.addChild(enemy.body)
            } else if (stageNo == 3) {
                //体力３＆速度4(デフォルト)で敵Cubeを3体生成
                //1体目生成
                enemy = new Enemy(new MaterialsList({all:new ColorMaterial(0x0000FF)}),1800,230,1800,3);
                enemyArray.push(enemy)
                scene.addChild(enemy.body)
                //2体目生成
                enemy = new Enemy(new MaterialsList({all:new ColorMaterial(0x0000FF)}),-1800,230,1800,3);
                enemyArray.push(enemy)
                scene.addChild(enemy.body)
                //3体目生成
                enemy = new Enemy(new MaterialsList({all:new ColorMaterial(0x0000FF)}),0,230,1800,3);
                enemyArray.push(enemy)
                scene.addChild(enemy.body)
            } else if (stageNo == 4) {
                //体力３＆速度８で敵Cubeを1体生成
                enemy = new Enemy(new MaterialsList({all:new ColorMaterial(0x0000FF)}),0,230,1800,3,8);
                enemyArray.push(enemy)
                scene.addChild(enemy.body)
            } else if (stageNo == 5) {
                //体力３＆速度８で敵Cubeを2体生成
                //1体目生成
                enemy = new Enemy(new MaterialsList({all:new ColorMaterial(0x0000FF)}),0,230,1800,3,8);
                enemyArray.push(enemy)
                scene.addChild(enemy.body)
                //2体目生成
                enemy = new Enemy(new MaterialsList({all:new ColorMaterial(0x0000FF)}),-1800,230,1800,3,8);
                enemyArray.push(enemy)
                scene.addChild(enemy.body)
            } else if (stageNo == 6) {
                //体力３＆速度８で敵Cubeを3体生成
                //1体目生成
                enemy = new Enemy(new MaterialsList({all:new ColorMaterial(0x0000FF)}),1800,230,1800,3,8);
                enemyArray.push(enemy)
                scene.addChild(enemy.body)
                //2体目生成
                enemy = new Enemy(new MaterialsList({all:new ColorMaterial(0x0000FF)}),-1800,230,1800,3,8);
                enemyArray.push(enemy)
                scene.addChild(enemy.body)
                //3体目生成
                enemy = new Enemy(new MaterialsList({all:new ColorMaterial(0x0000FF)}),0,230,1800,3,8);
                enemyArray.push(enemy)
                scene.addChild(enemy.body)
            } else if (stageNo == 7) {
                //体力６＆速度１２で敵Cubeを1体生成
                enemy = new Enemy(new MaterialsList({all:new ColorMaterial(0x0000FF)}),0,230,1800,6,12);
                enemyArray.push(enemy)
                scene.addChild(enemy.body)
            } else if (stageNo == 8) {
                //体力６＆速度１２で敵Cubeを2体生成
                //1体目生成
                enemy = new Enemy(new MaterialsList({all:new ColorMaterial(0x0000FF)}),0,230,1800,6,12);
                enemyArray.push(enemy)
                scene.addChild(enemy.body)
                //2体目生成
                enemy = new Enemy(new MaterialsList({all:new ColorMaterial(0x0000FF)}),-1800,230,1800,6,12);
                enemyArray.push(enemy)
                scene.addChild(enemy.body)
            } else if (stageNo == 9) {
                //体力６＆速度１２で敵Cubeを3体生成
                //1体目生成
                enemy = new Enemy(new MaterialsList({all:new ColorMaterial(0x0000FF)}),1800,230,1800,6,12);
                enemyArray.push(enemy)
                scene.addChild(enemy.body)
                //2体目生成
                enemy = new Enemy(new MaterialsList({all:new ColorMaterial(0x0000FF)}),-1800,230,1800,6,12);
                enemyArray.push(enemy)
                scene.addChild(enemy.body)
                //3体目生成
                enemy = new Enemy(new MaterialsList({all:new ColorMaterial(0x0000FF)}),0,230,1800,6,12);
                enemyArray.push(enemy)
                scene.addChild(enemy.body)
            } else if (stageNo == 10) {
                //体力９＆速度１６で敵Cubeを1体生成
                enemy = new Enemy(new MaterialsList({all:new ColorMaterial(0x0000FF)}),0,230,1800,9,16);
                enemyArray.push(enemy)
                scene.addChild(enemy.body)
            } else if (stageNo == 11) {
                //体力９＆速度１６で敵Cubeを2体生成
                //1体目生成
                enemy = new Enemy(new MaterialsList({all:new ColorMaterial(0x0000FF)}),0,230,1800,9,16);
                enemyArray.push(enemy)
                scene.addChild(enemy.body)
                //2体目生成
                enemy = new Enemy(new MaterialsList({all:new ColorMaterial(0x0000FF)}),-1800,230,1800,9,16);
                enemyArray.push(enemy)
                scene.addChild(enemy.body)
            } else if (stageNo == 12) {
                //体力９＆速度１６で敵Cubeを3体生成
                //1体目生成
                enemy = new Enemy(new MaterialsList({all:new ColorMaterial(0x0000FF)}),1800,230,1800,9,16);
                enemyArray.push(enemy)
                scene.addChild(enemy.body)
                //2体目生成
                enemy = new Enemy(new MaterialsList({all:new ColorMaterial(0x0000FF)}),-1800,230,1800,9,16);
                enemyArray.push(enemy)
                scene.addChild(enemy.body)
                //3体目生成
                enemy = new Enemy(new MaterialsList({all:new ColorMaterial(0x0000FF)}),0,230,1800,9,16);
                enemyArray.push(enemy)
                scene.addChild(enemy.body)
            } else if (stageNo == 13) {
                //体力１２＆速度２０で敵Cubeを1体生成
                enemy = new Enemy(new MaterialsList({all:new ColorMaterial(0x0000FF)}),0,230,1800,12,20);
                enemyArray.push(enemy)
                scene.addChild(enemy.body)
            } else if (stageNo == 14) {
                //体力１２＆速度２０で敵Cubeを2体生成
                //1体目生成
                enemy = new Enemy(new MaterialsList({all:new ColorMaterial(0x0000FF)}),0,230,1800,12,20);
                enemyArray.push(enemy)
                scene.addChild(enemy.body)
                //2体目生成
                enemy = new Enemy(new MaterialsList({all:new ColorMaterial(0x0000FF)}),-1800,230,1800,12,20);
                enemyArray.push(enemy)
                scene.addChild(enemy.body)
            } else if (stageNo == 15) {
                //体力１２＆速度２０で敵Cubeを3体生成
                //1体目生成
                enemy = new Enemy(new MaterialsList({all:new ColorMaterial(0x0000FF)}),1800,230,1800,12,20);
                enemyArray.push(enemy)
                scene.addChild(enemy.body)
                //2体目生成
                enemy = new Enemy(new MaterialsList({all:new ColorMaterial(0x0000FF)}),-1800,230,1800,12,20);
                enemyArray.push(enemy)
                scene.addChild(enemy.body)
                //3体目生成
                enemy = new Enemy(new MaterialsList({all:new ColorMaterial(0x0000FF)}),0,230,1800,12,20);
                enemyArray.push(enemy)
                scene.addChild(enemy.body)
            } else {
                enemy =  new Enemy(new MaterialsList({all:new ColorMaterial(0x0000FF)}),0,230,2000,3);
                enemyArray.push(enemy);
                scene.addChild(enemy.body);
                gameOver = false;
                stageClear = false;
            }
        }
        //バトル画面から3Dオブジェクトをリリース
        private function removeBattleScrn3DObjs():void {
            viewport.opaqueBackground = 0x0055FF; //背景をもとに戻す
            //ランドマップ配列1行分の処理
            for (var xRedIndex:int = 0; xRedIndex < 10; xRedIndex++){
                //配列1行分の10列のデータを処理
	        for (var zRedIndex:int = 0; zRedIndex < 10; zRedIndex++){
                    //3DPlaneオブジェクトをリリース
                    tempPlaneName = "redPlaneX" + xRedIndex + "_Z" + zRedIndex;
                    scene.removeChildByName(tempPlaneName);
            	}
            }
            scene.removeChild(planeStage);
            //ゲームオーバー時に3D「のまねこ」が画面からリムーブされているのでチェックを行う
            if(!gameOver) {scene.removeChildByName("daeNomaneko");} 
            initEnemyArray();
            initBulleyArray();
        }
//■■■ランド画面←→バトル画面　遷移処理エンド■■■■■■■■■■■■■■■■■■■
//■■■画面遷移ボタン処理エンド■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
//■■■ランド画面ボタン処理スタート(遷移ボタン以外)■■■■■■■■■■■■■■■■■■■■■■■■
        //「はなす」ボタンによるふきだしを表示
        private function onHanasuBtnDown(evt:MouseEvent):void {
            //「はなす」ボタンによるふきだし表示機能をON・OFF
            if (fukidashiState == false) {
                var fukidashiTxt : String;
                //ふきだし用テキストを設定
                if (screenId == LAND_SCREEN_ID) {//ランド画面用ふきだしテキスト表示
                    if(gameOver) {
                        fukidashiTxt = "のま村村長：" + "\n"
                                     + "おお、勇者「のまねこ」よ、死んでしまうとはなにごとじゃ！" + "\n";
                        gameOver = false;
                    } else if (stageClear) {
                        fukidashiTxt = "のま村村長：" + "\n"
                                     + "おお、勇者「のまねこ」よ、よくぞ謎の立方体を倒してくれた！" + "\n"
                                     + "礼をいうぞ！！" + "\n";
                        stageClear = false;
                    } else {
                        fukidashiTxt = "のま村村長：" + "\n"
                                     + "おお、勇者「のまねこ」よ、よくぞまいった！" + "\n"
                                     + "最近この「のま村」の近くにできた異次元に謎の立方体が" + "\n"
                                     + "現れるようになって困っておるのじゃ！" + "\n"
                                     + "どうか代わりにその立方体を退治してくれまいか？" + "\n"
                                     + "異次元には右側の「ステージ選択」ボタンから移動できるぞよ。" + "\n"
                                     + "" + "\n"
                                     + "異次元のバトル画面では、QまたはZボタンで攻撃じゃ。" + "\n";
                    }
                } else if (screenId == BATTLE_SCREEN_ID) {//バトル画面用ふきだしテキスト表示
                    fukidashiTxt = "" + "\n";
                }
                editLabel("fukidashi",fukidashiTxt);
                //ふきだし設定
                addChild(fukiContena);
                fukiContena.addChild(fuki);
                fukiContena.addChild(onfuki);
                fukiContena.addChild(txtField["fukidashi"]);
                fukidashiState = true;
            } else {//ふきだしを非表示
                removeFukidashi();
            } 
        }
        //「ステージ選択」ボタンによるふきだしを表示
        private function onStageSelectionBtnDown(evt:MouseEvent):void {
            //「ステージ選択」ボタンによるふきだし表示機能をON・OFF
            if (fukidashiState == false) {
                var stageInfoTxt : String;
                stageInfoTxt = "ステージ" + "\n"
                             + "\n"
                             + "謎の立方体" + "\n"
                             + "スピード：" + "\n"
                             + "耐久力：" + "\n"
                             + "数：×" + "\n"
                             + "\n"
                             + "クリア報酬：" + "\n";
                editLabel("stageInfo",stageInfoTxt);
                //ふきだし設定
                addChild(fukiContena);
                fukiContena.addChild(fuki);
                fukiContena.addChild(stage1Btn);
                fukiContena.addChild(stage2Btn);
                fukiContena.addChild(stage3Btn);
                fukiContena.addChild(stage4Btn);
                fukiContena.addChild(stage5Btn);
                fukiContena.addChild(stage6Btn);
                fukiContena.addChild(stage7Btn);
                fukiContena.addChild(stage8Btn);
                fukiContena.addChild(stage9Btn);
                fukiContena.addChild(stage10Btn);
                fukiContena.addChild(stage11Btn);
                fukiContena.addChild(stage12Btn);
                fukiContena.addChild(stage13Btn);
                fukiContena.addChild(stage14Btn);
                fukiContena.addChild(stage15Btn);
                fukiContena.addChild(txtField["stageInfo"]);
                fukidashiState = true;
            } else {//ふきだしを非表示
                removeFukidashi();
            } 
        }
        //「スタート」ボタン機能
        private function battleScrnStartBtnDown(evt:MouseEvent):void {
            //「はなす」ボタンによるふきだし表示機能をON・OFF
            if (battleScrnPoseState) {
                if (fukidashiState == true) {
                    //ふきだしを非表示
                    removeFukidashi();
                }

                battleScrnPoseState = false;
            } else {
                if (fukidashiState == false) {
                    var fukidashiTxt : String;
                    //ふきだし用テキストを設定
                    fukidashiTxt = "「スタート」ボタンによるポーズ中です" + "\n"
                                 + "再度「スタート」ボタン押下により解除されます" + "\n";
                    editLabel("fukidashi",fukidashiTxt);
                    //ふきだし設定
                    addChild(fukiContena);
                    fukiContena.addChild(fuki);
                    fukiContena.addChild(onfuki);
                    fukiContena.addChild(txtField["fukidashi"]);
                    fukidashiState = true;
                }

                battleScrnPoseState = true;
            }
        }

        //ステージ選択ボタン上にマウスポインタ存在時の処理設定
        private function overStageSelectionBtn(evt:MouseEvent):void {
            var target : CustomButton;
            target = CustomButton(evt.currentTarget);
            stageNo = target.getBtnNo();

            //「ステージ選択」ボタンによるふきだし表示時にテキストメッセージを変更
            if (fukidashiState == true) {
                var stageInfoTxt : String;
                var enemySpeed : int = 1;
                var enemyLife : int = 1;
                if(stageNo <= 3) {enemySpeed=4;enemyLife=3;} 
                else if(stageNo <= 6) {enemySpeed=8;enemyLife=6;} 
                else if(stageNo <= 9) {enemySpeed=12;enemyLife=9;} 
                else if(stageNo <= 12) {enemySpeed=16;enemyLife=12;} 
                else if(stageNo <= 15) {enemySpeed=20;enemyLife=15;}
                var enemyNum : int = stageNo%3; if(enemyNum == 0){enemyNum = 3;}
                stageInfoTxt = "ステージ" + stageNo + "\n"
                             + "\n"
                             + "謎の立方体" + "\n"
                             + "スピード：" + enemySpeed + "\n"
                             + "耐久力："  + enemyLife + "\n"
                             + "数：×" + enemyNum + "\n"
                             + "\n"
                             + "クリア報酬：" + (10*stageNo) + "\n";
                editLabel("stageInfo",stageInfoTxt);
                //ふきだし設定
                fukiContena.addChild(txtField["stageInfo"]);
            }
        }

        //前進ボタン押下時処理設定
        private function onForwardBtnDown(evt:MouseEvent):void {
            //バトル画面時にゲームオーバーまたはポーズ状態の場合は何も処理を行わない
            if (screenId == BATTLE_SCREEN_ID) { if (gameOver) {return;} if (battleScrnPoseState) {return;}}
            forwardState = true;
        }
        //前進ボタンリリース時処理設定1
        private function onForwardBtnUp(evt:MouseEvent):void {
            forwardState = false;
        }
        //前進ボタンリリース時処理設定2
        private function onForwardBtnOut(evt:MouseEvent):void {
            forwardState = false;
        }
        //後退ボタン押下時処理設定
        private function onBackwardBtnDown(evt:MouseEvent):void {
            //バトル画面時にゲームオーバーまたはポーズ状態の場合は何も処理を行わない
            if (screenId == BATTLE_SCREEN_ID) { if (gameOver) {return;} if (battleScrnPoseState) {return;}}
            backwardState = true;
        }
        //後退ボタンリリース時処理設定1
        private function onBackwardBtnUp(evt:MouseEvent):void {
            backwardState = false;
        }
        //後退ボタンリリース時処理設定2
        private function onBackwardBtnOut(evt:MouseEvent):void {
            backwardState = false;
        }
        //左回転ボタン押下時処理設定
        private function onLeftRotBtnDown(evt:MouseEvent):void {
            //バトル画面時にゲームオーバーまたはポーズ状態の場合は何も処理を行わない
            if (screenId == BATTLE_SCREEN_ID) { if (gameOver) {return;} if (battleScrnPoseState) {return;}}
            leftRotState = true;
        }
        //左回転ボタンリリース時処理設定1
        private function onLeftRotBtnUp(evt:MouseEvent):void {
            leftRotState = false;
        }
        //左回転ボタンリリース時処理設定2
        private function onLeftRotBtnOut(evt:MouseEvent):void {
            leftRotState = false;
        }
        //右回転ボタン押下時処理設定
        private function onRightRotBtnDown(evt:MouseEvent):void {
            //バトル画面時にゲームオーバーまたはポーズ状態の場合は何も処理を行わない
            if (screenId == BATTLE_SCREEN_ID) { if (gameOver) {return;} if (battleScrnPoseState) {return;}}
            rightRotState = true;
        }
        //右回転ボタンリリース時処理設定1
        private function onRightRotBtnUp(evt:MouseEvent):void {
            rightRotState = false;
        }
        //右回転ボタンリリース時処理設定2
        private function onRightRotBtnOut(evt:MouseEvent):void {
            rightRotState = false;
        }
        //Bダッシュボタン押下時処理設定
        private function onBDashBtnDown(evt:MouseEvent):void {
            //バトル画面時にゲームオーバーまたはポーズ状態の場合は何も処理を行わない
            if (screenId == BATTLE_SCREEN_ID) { if (gameOver) {return;} if (battleScrnPoseState) {return;}}
            bDashState = true;
        }
        //Bダッシュボタンリリース時処理設定1
        private function onBDashBtnUp(evt:MouseEvent):void {
            bDashState = false;
        }
        //Bダッシュボタンリリース時処理設定2
        private function onBDashBtnOut(evt:MouseEvent):void {
            bDashState = false;
        }
//■■■ランド画面ボタン処理エンド(遷移ボタン以外)■■■■■■■■■■■■■■■■■■■■■■■■■
//■■■ボタン処理エンド■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
    }
}
//■■■エネミーキューブクラス■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
import flash.display.Sprite;
import org.papervision3d.objects.primitives.Cube;  
import org.papervision3d.materials.ColorMaterial;
import org.papervision3d.materials.utils.MaterialsList; 
//敵Cubeを作成
class Enemy
{
    public var body : Cube; //攻撃対象となる敵本体
    private var energy : int = 1; //体力
    private var duration : int = 0; //
    private var speedX : int = 0; //敵X方向移動速度
    private var speedZ : int = 0; //敵Z方向移動速度　
    private var speed : int = 4; //敵移動速度　
    private const SIZE: int = 300; //敵本体Cubeのサイズ(縦、横、高さ同じ)
    private const DURATION: int = 180; //敵移動先の再計算までの間隔
    public function Enemy(colMateList:MaterialsList,posX:int=0,posY:int=0,posZ:int=0,energy:int=1,speed:int=4):void {
        body = new Cube(colMateList, SIZE, SIZE, SIZE);
        body.x = posX; //　敵のX軸の初期値を設定
        body.y = posY; //　敵のY軸の初期値を設定
        body.z = posZ; //　敵のZ軸の初期値を設定
        this.energy = energy;
        this.speed = speed;
    }
    //操作オブジェクトのXとZ軸の座標を元に、敵の移動先を計算  
    public function move(figX:int,figZ:int):void {
        var dist : Number;
        if (duration > 0) {
            body.x += speedX;
            body.z += speedZ;
            duration--;
        } else {
            dist = Math.sqrt(Math.pow(figX-body.x,2)+Math.pow(figZ-body.z,2));
            speedX = Math.round((figX-body.x)/dist*speed);
            speedZ = Math.round((figZ-body.z)/dist*speed);
            duration = DURATION;
        }
    }
    //敵Cubeが画面指定範囲内かチェック(予定)
    public function boundaryCheck(boundary:int):Boolean {
        if(body.x > boundary || body.x < -1*boundary
           || body.z > boundary || body.z < -1*boundary) {
               return true;
        }
        return false;
    }
    //X軸位置情報を返す 
    public function getPosX():int {
        return body.x;
    }
    //Z軸位置情報を返す
    public function getPosZ():int {
        return body.z;
    }
    //敵Cube左端のX軸位置情報を返す 
    public function getLeftPosX():int {
        return body.x - SIZE/2;
    }
    //敵Cube右端のX軸位置情報を返す
    public function getRightPosX():int {
        return body.x + SIZE/2;
    } 
    //敵Cubeの手前側のZ軸位置情報を返す 
    public function getFrontPosZ():int {
        return body.z - SIZE/2;
    }
    //敵Cubeの奥側のZ軸位置情報を返す
    public function getBackPosZ():int {
        return body.z + SIZE/2;
    }
    //対象と敵CubeのXZ軸端の座標の交差による当たり判定(交差判定によるあたり判定)
    //Y軸は同じ座標にあるものとして判定を行わない
    public function isCollision(bulLeftX:int,bulRightX:int,bulFrontZ:int,bulBackZ:int,attackPow:int=1):Boolean {
        //交差判定による敵Cubeとの当たり判定計算
        if ((getRightPosX() > bulLeftX) && (bulRightX > getLeftPosX()) 
             && (getBackPosZ() > bulBackZ) && (bulFrontZ > getFrontPosZ())) {
            energy -= attackPow; //体力を減らす
            return true;
        } else {
            return false;
        }
    }
    //敵Cubeの体力が残っているか判定
    //Y軸は同じ座標にあるものとして判定を行わない
    public function isAlive():Boolean {
        //体力が0以下の場合、真を返す
        if (energy > 0) {
            return true;
        } else {
            return false;
        }
    }
    //対象と敵Cubeの距離で当たり判定(平方根によるあたり判定)
    //Y軸は同じ座標にあるものとして判定を行わない
    public function isCollisionBySqrt(bulX:int,bulZ:int,compDist:int):Boolean {
        //平方根を用いて弾丸と攻撃対象Cubeとの距離を計算
        var dist : Number = 
        Math.sqrt(Math.pow(bulX-getPosX(),2)+Math.pow(bulZ-getPosX(),2));
        if (dist > compDist) {
            return false;
        } else {
            return true;
        } 
    }         
}    
//■■■Sphere型弾丸クラス■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
import flash.display.Sprite;
import org.papervision3d.objects.primitives.Sphere;  
import org.papervision3d.materials.ColorMaterial;
//弾丸Sphereを作成
class Bullet
{
    public var body : Sphere; //攻撃用の弾丸本体
    private var speedX : int = 0; //弾丸X方向速度
    private var speedZ : int = 0; //弾丸Z方向速度　
    private const SPEED : int = 30; //弾丸の速度　
    private const RADIUS: int = 15; //弾丸本体Sphereの半径
    public function Bullet(figRotation:int=0,figX:int=0,figZ:int=0):void {
        body = new Sphere(new ColorMaterial(0xFFFF00), RADIUS, 8, 6);
        body.x = figX; //　弾丸のX軸の初期値を設定
        body.y = 250; //　弾丸のY軸の初期値を設定
        body.z = figZ; //　弾丸のZ軸の初期値を設定
        //　弾丸速度をX軸の速度成分に分解
        speedX = SPEED * Math.cos((90-figRotation)*Math.PI/180);
        //　弾丸速度をZ軸の速度成分に分解
        speedZ = SPEED * Math.sin((90-figRotation)*Math.PI/180);
    }
    
    //X軸とZ軸の速度成分を加算して、X軸とZ軸の移動先の座標を計算
    public function move():void {
        body.x += speedX;
        body.z += speedZ;
    }    
    //弾丸Sphereが画面指定範囲内かチェック
    public function boundaryCheck(boundary:int):Boolean {
        if(body.x > boundary || body.x < -1*boundary
           || body.z > boundary || body.z < -1*boundary) {
               return true;
        }
        return false;
    } 
    //X軸位置情報を返す 
    public function getPosX():int {
        return body.x;
    }
    //Z軸位置情報を返す
    public function getPosZ():int {
        return body.z;
    }
    //弾丸Sphere左端のX軸位置情報を返す 
    public function getLeftPosX():int {
        return body.x - RADIUS;
    }
    //弾丸Sphere右端のX軸位置情報を返す
    public function getRightPosX():int {
        return body.x + RADIUS;
    } 
    //弾丸Sphereの手前側のZ軸位置情報を返す 
    public function getFrontPosZ():int {
        return body.z - RADIUS;
    }
    //弾丸Sphereの奥側のZ軸位置情報を返す
    public function getBackPosZ():int {
        return body.z + RADIUS;
    }       
}                                         
//■■■カスタムボタンクラス■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
import flash.display.*;
import flash.system.*;
import flash.text.*;
//カスタムボタン
class CustomButton extends SimpleButton {
        private var btnName : String = "";//ボタン名
        private var btnNo : int = 0;//ボタン番号
        //コンストラクタ    
        public function CustomButton(label:String="",no:int=0) {
            btnName = label;
            btnNo = no;
            //状態
            upState = makeSprite(label,0x999999);
            overState = upState;
            downState = makeSprite(label,0x0000FF);
            hitTestState = upState;
        }
        public function getBtnName():String {
            return btnName;
        }
        public function getBtnNo():int {
            return btnNo;
        }
        //ボタン用スプライト作成
        private function makeSprite(text:String,color:uint):Sprite{
            //ボタン用ラベル作成
            var label : TextField = new TextField();
            label.text = text;
            label.autoSize = TextFieldAutoSize.CENTER;
            label.selectable = false;
            //ボタン用スプライト作成
            var sp:Sprite = new Sprite();
            sp.graphics.beginFill(color);
            sp.graphics.drawRoundRect(0, 0, 100, 20, 15);
            sp.graphics.endFill();
            sp.alpha = 0.8;            
            sp.addChild(label);
            //ラベル用フォーマット設定
            var format:TextFormat=new TextFormat();
            format.font = "Courier New";
            format.bold = true;
            format.size = 13;
            label.setTextFormat(format);
            return sp;
        }
}
//■■■ユーティリティクラス■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
import flash.text.TextField;
import flash.text.TextFormat;
import flash.text.AntiAliasType;
import flash.text.TextFormatAlign;
//ユーティリティ
class Util
{
    //テキストフィールドの生成
    public static function makeTxtField(posX:int,posY:int,width:int,height:int):TextField {
        var label:TextField=new TextField();
        label.selectable=false;
        label.x       =posX;
        label.y       =posY;
        label.width   =width;
        label.height  =height;
        label.antiAliasType=AntiAliasType.ADVANCED;
        return label;
    }
    //テキストフォーマットの生成
    public static function makeTextFormat(size:uint,color:uint,
        align:String=TextFormatAlign.LEFT):TextFormat {
        var format:TextFormat=new TextFormat();
        format.font ="Courier New"; // 等幅フォント
        format.size =size;  
        format.color=color;
        format.bold =true;
        format.align=align;
        return format;
    }
}