/**
 * Copyright aobyrne ( http://wonderfl.net/user/aobyrne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/616f
 */

package 
{
    import Box2D.Common.Math.b2Vec2;
    import Box2D.Dynamics.b2Body;
    import com.actionsnippet.qbox.objects.BoxObject;
    import com.actionsnippet.qbox.QuickBox2D;
    import com.actionsnippet.qbox.QuickObject;
    import com.bit101.components.ColorChooser;
    import com.bit101.components.Component;
    import com.bit101.components.HBox;
    import com.bit101.components.HUISlider;
    import com.bit101.components.Label;
    import com.bit101.components.NumericStepper;
    import com.bit101.components.PushButton;
    import com.bit101.components.VBox;
    import flash.display.DisplayObjectContainer;
    import flash.display.MovieClip;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    
    public class Main extends MovieClip
    {
        private const GOLDEN_ANGLE:Number = (137+Math.random()) * Math.PI / 180;
        private var quickBox2D:QuickBox2D;
        private var boxObject:BoxObject;
        private var count:Number;
        private var centerX:Number;
        private var centerY:Number;
        private var radiusSowing:Number=0.1;
        private var loopPeriod:Number = 5;
        private var seedRadius:Number = 0.5;
        private var angle:Number;
        private var initialColor:uint = 0xffffff * Math.random();
        private var finalColor:uint = 0xffffff * Math.random();
        private var _seedCounter:int;
        private var max_seeds:int = 150;
        private var controls:VBox;
        private var seeds:Array=[];
        private var resetPushButton:PushButton;
        private var startPushButton:PushButton;
        private var seedRadiusHUISlider:HUISlider;
        private var seedCounterLabel:Label;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            var simulationMovieClip:MovieClip = MovieClip(addChild(new MovieClip));
            simulationMovieClip.name = "simulationMovieClip";
            quickBox2D = new QuickBox2D(simulationMovieClip, { } );
            //quickBox2D.createStageWalls();
            //quickBox2D.mouseDrag();
            quickBox2D.gravity=new b2Vec2(0, 0);
            //boxObject = BoxObject(quickBox2D.addBox( { x:1, y:1 } ));
            quickBox2D.mouseDrag();
            quickBox2D.start();
            count = 0;
            
            
            controls = new VBox(this, 10, 20);
            controls.name = "controls";
            
            startPushButton = new PushButton(null, 0, 0, "start", startSim);
            addTocontrols(startPushButton);
            seedRadiusHUISlider = new HUISlider(null, 0, 0, "seedRadius", seedRadiusHandler);
            seedRadiusHUISlider.minimum = 0.1;
            seedRadiusHUISlider.maximum = 2;
            seedRadiusHUISlider.value = seedRadius;
            addTocontrols(seedRadiusHUISlider);
            
            var sowingRadiusHUISlider:HUISlider = new HUISlider(null, 0, 0, "sowingRadius", sowingRadiusHandler);
            sowingRadiusHUISlider.minimum = 0.1;
            sowingRadiusHUISlider.maximum = 2;
            sowingRadiusHUISlider.value = radiusSowing;
            addTocontrols(sowingRadiusHUISlider);
            
            var stopPushButton:PushButton = new PushButton(null, 0, 0, "stop", stopSim);
            addTocontrols(stopPushButton);
            
            var initColorChooser:ColorChooser = new ColorChooser(null, 0, 0, initialColor, initColorChooserH);
            initColorChooser.usePopup = true;
            addTocontrols(initColorChooser);
            var finalColorChooser:ColorChooser = new ColorChooser(null, 0, 0, finalColor, finalColorChooserH);
            finalColorChooser.usePopup = true;
            addTocontrols(finalColorChooser);
            
            resetPushButton = new PushButton(null, 0, 0, "reset", resetHandler);
            addTocontrols(resetPushButton);
            
            var removeMovieClipsPushButton:PushButton = new PushButton(null, 0, 0, "remove", removeMovieClipsHandler);
            addTocontrols(removeMovieClipsPushButton);
            
            var maxSeedsNumericStepper:NumericStepper = new NumericStepper(null, 0, 0, numericStepperHandler);
            maxSeedsNumericStepper.minimum = 50;
            maxSeedsNumericStepper.maximum = 300;
            maxSeedsNumericStepper.step = 10;
            maxSeedsNumericStepper.value = max_seeds;
            addTocontrols(maxSeedsNumericStepper);
            
            var seedsHBox:HBox = new HBox(null, 0, 0);
            seedsHBox.addChildAt(new Label(null, 0, 0, '"Seeds":'),seedsHBox.numChildren);
            seedCounterLabel = new Label(null, 0, 0, seedCounter.toString());
            seedsHBox.addChildAt(seedCounterLabel,seedsHBox.numChildren);
            addTocontrols(seedsHBox);
            seedCounter = 0;
                        
            
            swapChildren(simulationMovieClip, controls);
        }
                
        private function removeMovieClipsHandler(e:Event):void 
        {
            for each (var item:QuickObject in seeds) 
            {
                item.userData.parent.removeChild(item.userData);
            }
        }
        
        private function numericStepperHandler(e:Event):void 
        {
            max_seeds = NumericStepper(e.target).value;
        }
        
        private function addTocontrols(cArg:Component):void 
        {
            controls.addChildAt(cArg,controls.numChildren)
        }
        
        private function sowingRadiusHandler(e:Event):void 
        {
            trace("something");
            radiusSowing = HUISlider(e.target).value;
        }
        
        private function seedRadiusHandler(e:Event):void 
        {
            seedRadius = seedRadiusHUISlider.value;
        }
        
        private function stopSim(e:Event):void 
        {
            removeEventListener(Event.ENTER_FRAME, loop);
        }
        
        private function resetHandler(e:Event):void 
        {
            resetSimulation();
            seedCounter = 0;
        }
        
        
        private function resetSimulation():void 
        {
            var body:b2Body = quickBox2D.w.GetBodyList();
            while (body) 
            {
                //DisplayObjectContainer(body.m_userData).parent.removeChild(DisplayObjectContainer(body.m_userData));
                quickBox2D.w.DestroyBody(body);
                body = body.GetNext();
            }
            
        }
        
        private function finalColorChooserH(e:Event):void 
        {
            finalColor = ColorChooser(e.target).value;
            trace( "finalColor : " + finalColor );
        }
        
        private function initColorChooserH(e:Event):void 
        {
            initialColor = ColorChooser(e.target).value;
            trace( "initialColor : " + initialColor );
        }
        
        private function startSim(e:Event):void 
        {
            centerX = (stage.stageWidth >> 1 ) / 30;
            centerY = (stage.stageHeight >> 1) / 30;
            addEventListener(Event.ENTER_FRAME, loop);
            
        }
        
        private function loop(e:Event):void 
        {
            count++;
            if (count%loopPeriod==0) 
            {
                /*
                //trace(Math.random().toFixed(4));
                //boxObject.params["draggable"] = !boxObject.params["draggable"];
                //trace( "boxObject.params[\"draggable\"] : " + boxObject.params["draggable"] );
                //if (boxObject.params["draggable"]) 
                //{
                    //graphics.clear();
                    //graphics.beginFill(0);
                    //graphics.drawRect(0, 0, 100, 100);
                    //graphics.endFill();
                //}
                */
                angle = GOLDEN_ANGLE*seedCounter
                seeds[seeds.length] = quickBox2D.addCircle(
                    {
                        x:centerX + radiusSowing * Math.cos(angle),
                        y:centerY + radiusSowing * Math.sin(angle),
                        radius:seedRadius,
                        density:1,
                        fixedRotation:true,
                        friction:0,
                        fillColor:interpolateColorsCompact(initialColor, finalColor, seedCounter / max_seeds)
                    });
                trace( "seedCounter : " + seedCounter );
                seedCounter++;
                seedCounterLabel.text = seedCounter.toString();
                if (seedCounter>max_seeds) 
                {
                    removeEventListener(Event.ENTER_FRAME, loop);
                    trace( "finalColor : " + interpolateColorsCompact(initialColor,finalColor,(seedCounter-1)/max_seeds) );
                }
            }
        }
        /**
         * From Quasimondo @ 
         * http://wonderfl.net/c/eYx0
         * @param    a
         * @param    b
         * @param    lerp
         * @return
         */
        private function interpolateColorsCompact( a:int, b:int, lerp:Number ):int
        { 
            var MASK1:int = 0xff00ff; 
            var MASK2:int = 0x00ff00; 

            var f2:int = 256 * lerp;
            var f1:int = 256 - f2;

            return  ((((( a & MASK1 ) * f1 ) + ( ( b & MASK1 ) * f2 )) >> 8 ) & MASK1 ) 
                  | ((((( a & MASK2 ) * f1 ) + ( ( b & MASK2 ) * f2 )) >> 8 ) & MASK2 );
                
        } 
        
        public function get seedCounter():int 
        {
            return _seedCounter;
        }
        
        public function set seedCounter(value:int):void 
        {
            _seedCounter = value;
            seedCounterLabel.text = value.toString();
        }
        
    }
    
}